<script type="text/javascript">
	jQuery(function($) {
		$('#example1').DataTable();
		$('#example2').DataTable({
			'paging'      : true,
			'lengthChange': false,
			'searching'   : false,
			'ordering'    : true,
			'info'        : true,
			'autoWidth'   : false
		});		
		//Users Validation
		$('.form-validate-users').validate(
		{
			errorElement: 'div',
			errorClass: 'help-block',
			focusInvalid: false,
			rules:
			{
				username: {    required: true },
				mobile_no: {    required: true },
				email: {
					required: true,
					email:true
				},
				password: {
					required: true,
					minlength: 5
				},
				retypepassword: {
					required: true,
					minlength: 5,
					equalTo: "#password"
				},
			},
			messages: {
				username: " Please enter username.",
				mobile_no: " Please enter mobile no.",
				email: {
					required: " Please enter email.",
					email: "    Please provide a valid email."
				},
				password: {
					required: " Please enter password.",
					minlength: "    Please enter secure password."
				},
				retypepassword: {
					required: " Please enter confirm password.",
					minlength: "    Please enter secure password."
				},
			},
			invalidHandler: function (event, validator) { //display error alert on form submit
				$('.alert-danger', $('.add_new_ajeer')).show();
			},
			highlight: function (e) {
				$(e).closest('.form-group').removeClass('has-info').addClass('has-error');
			},
			success: function (e) {
				$(e).closest('.form-group').removeClass('has-error').addClass('has-info');
				$(e).remove();
			},
			errorPlacement: function (error, element) {
				error.insertAfter(element.parent());
			},
		});
		//username UNIQUE
		$('#username').blur(function()
		{
            var json = {};
            json['value'] = $('#username').val();
            json['id']       = $('#id').val();
            json['table']       = "login";
            json['col']       = "username";
            var request = $.ajax({
                url: "<?php echo base_url('Users/check_unique_exists'); ?>",
                type: "POST",
                data: json,
                dataType: "json",
                success : function(_return)
                {
                    if(_return['_return'] > 0)
                    {
                        $('input[name="username"]').rules('add', {
                            equalTo:'1',
                            messages:   {
                                equalTo: ' Username Already Exists can not be created again.'
							}
						});
                        // trigger immediate validation to update message
                        $('input[name="username"]').valid();
                        $('input[name="username"]').rules('remove','equalTo');
                        var old_username = $('input[name="username"]').attr('old_username');
                        if(old_username != null)
                        {
                            $('input[name="username"]').val(old_username);  
						}else
                        {
                            $('input[name="username"]').val(''); 
						}
					}  
				}
			});
		});
		//email UNIQUE
		$('#email').blur(function()
		{
            var json = {};
            json['value'] = $('#email').val();
            json['id']       = $('#id').val();
            json['table']       = "login";
            json['col']       = "email";
            var request = $.ajax({
                url: "<?php echo base_url('Users/check_unique_exists'); ?>",
                type: "POST",
                data: json,
                dataType: "json",
                success : function(_return)
                {
                    if(_return['_return'] > 0)
                    {
                        $('input[name="email"]').rules('add', {
                            equalTo:'1',
                            messages:   {
                                equalTo: ' Email Already Exists can not be created again.'
							}
						});
                        // trigger immediate validation to update message
                        $('input[name="email"]').valid();
                        $('input[name="email"]').rules('remove','equalTo');
                        var old_email = $('input[name="email"]').attr('old_email');
                        if(old_email != null)
                        {
                            $('input[name="email"]').val(old_email);  
						}else
                        {
                            $('input[name="email"]').val(''); 
						}
					}  
				}
			});
		});
        $("#changepassword").change(function(){
            var change_status = $(this).val();
            if(change_status == 0)
            {
                $('input[type="password"]').prop('disabled',false); 
                $(this).val(1);
			}else
            {
                $('input[type="password"]').prop('disabled',true); 
                $(this).val(0);   
			}
		});
		//Upload Pic token Purpose
		$("#upload_pic_token").click(function()
		{
			$("input[id='my_img']").click();
		});
		$("#my_img").change(function ()
		{
			if (this.files && this.files[0])
			{
				var ext = $('#my_img').val().split('.').pop().toLowerCase();
				if($.inArray(ext, ['gif','png','jpg','jpeg']) == -1)
				{
					alert('Invalid extension Only Upload JPG | PNG | GIF Image!');
					$("#my_img").val("");
				}
				else
				{
					var reader = new FileReader();
					reader.onload = imageIsLoaded;
					reader.readAsDataURL(this.files[0]);
				}
			}
		});
	});
	function imageIsLoaded(e)
    {
        $('#result_pic').removeClass('hide');
        $('#image_status').val(0);
        $('#upload_img').removeClass('hide');
        $('#myImg').attr('src', e.target.result);
	};
    //Image Cancel preview
    function cancel_preview_image()
    {
        $("#image_status").val(1);
        $('#upload_img').addClass('hide');
        $('#result_pic').addClass('hide');
		$("#my_img").val("");
	}
</script>