<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'Frontend/index';
$route['404_override'] = 'Frontend/_404_page';
$route['translate_uri_dashes'] = FALSE;
$route['not-found-404'] = 'Frontend/_404_page';
$route['index.php'] = 'Frontend/redirect_index';



//Searching 
$route['dropdown-search'] = 'Frontend/dropdown_search';
$route['search/(:any)'] = 'Frontend/search_store/$1';
$route['search/(:any)/page/(:num)'] = 'Frontend/search_store/$1/$2';
 
//Home Page
$route['subscribe-submit'] = 'Frontend/subscribe_submit';
$route['unsubscribe/(:any)'] = 'Frontend/unsubscribe/$1';
$route['unsubscribe-submit'] = 'Frontend/unsubscribe_submit';

//Category & Single Category
$route['categories'] = 'Frontend/categories';
$route['category/(:any)'] = 'Frontend/single_category/$1';
$route['category/(:any)/page/(:num)'] = 'Frontend/single_category/$1/$2';






//Single Store
$route['brand/(:any)'] = 'Frontend/single_store/$1';

//Other Pages
$route['about-us'] = 'Frontend/about_us';
$route['faq'] = 'Frontend/faq';
$route['contact-us'] = 'Frontend/contact_us';
$route['contact-us-submit'] = 'Frontend/contact_us_submit';
$route['privacy-policy'] = 'Frontend/privacy_policy';
$route['terms-and-condition'] = 'Frontend/terms_and_condition';
$route['cookies'] = 'Frontend/cookies';


//Stores / Sitemap Pages
$route['brands'] = 'Frontend/sitemap';
$route['brands/voucher-codes-(:any)'] = 'Frontend/single_sitemap/$1';
$route['all-brands'] = 'Frontend/allstores';
//Event Pages
$route['events'] = 'Frontend/events';
$route['event/(:any)'] = 'Frontend/single_event/$1';

//Top 20 Page
$route['top-discount-stores'] = 'Frontend/top_discount';

//Special Page
//$route['(:any)-discount-codes'] = 'Frontend/special_page/$1';
$route['restaurant-vouchers'] = 'Frontend/special_page_restaurant/$1';
$route['student-discount'] = 'Frontend/special_page_student/$1';

//Tags Pages
//$route['(:any)-deals'] = 'Frontend/tags_page/$1';

//Offers & Stores
$route['get-offer-submit'] = 'Frontend/get_offer_submit';
$route['get-store-submit'] = 'Frontend/get_store_submit';


//$route['pagination/category-stores-list/(:any)'] = 'Frontend/ajax_category_stores_list/$1';
//$route['stores'] = 'Frontend/stores';



//API CJ 
$route['api_cj'] = 'Frontend/new_data1';



//Admin Section Route
$route['cms-panel'] = 'Login';
$route['cms-panel/login'] = 'Login';