<?php 
	$mytitle = "DiscountJockey: Contact Us";
	$meta_description = "Contact Us - DiscountJockey is available 24/7.  We support our visitors and merchants to improve your experience and provide the best offers.";
	$meta_keywords = "";
	$meta_canonical = base_url()."contact-us";
	$social_url = base_url()."contact-us";
	$og_image = base_url()."public_html/backend/image/logo/logo.png";
	require "template/header.php"; 
?>
<div class="page-wrap contact-page-wrap">
	<div class="container">
		<div class="breadcrumb">
			<a href="<?php echo base_url(); ?>"><i class="fas fa-home"></i></a>
			<a class="active" href="javascript:;" >Contact Us</a>
		</div>		
		<div class="contact-main">
			<div class="contact-text">				
				<h1 class="heading">Contact Us</h1>
				<p style="text-align:center;">Get in touch with DiscountJockey by filling in this contact form.</p>								
			</div>
			<?php
				if($this->session->flashdata())
				{
					foreach($this->session->flashdata() as $key => $value):
					if($key == 'update' || $key == 'saved')
					{
						$alert_class = 'alert-success';
					}else
					{
						$alert_class = 'alert-danger';
					}
				?>
				<div class="alert alert-block <?php echo $alert_class; ?>">
					<button type="button" class="close" data-dismiss="alert">
						<i class="icon-remove"></i>
					</button>
					<p>
						<strong>
							<i class="icon-ok"></i>
							<?php echo ucwords(strtolower($key)); ?> !
						</strong>
						<?php echo $value; ?>
					</p>
				</div>
				<?php
					endforeach;
				}  ?>
				<form>
					<div class="row">
						<div class="col-lg-6 col-md-6 col-sm-6 col-12 form-col">
							<label>Full Name<sup style="color:red;">*</sup></label>
							<input type="text" id="full_name" name="full_name" class="full_name" />
							<p id="erfname" style="display:none;" class="myerror"></p>
						</div>
						<div class="col-lg-6 col-md-6 col-sm-6 col-12 form-col">
							<label>Email Address<sup style="color:red;">*</sup></label>
							<input type="email" id="email" name="email" class="email" />
							<p id="eremail" style="display:none;" class="myerror"></p>
						</div>
						<div class="col-lg-12 col-md-12 col-sm-12 col-12 form-col">
							<label>Subject</label>
							<input type="text" id="subject" name="subject" class="subject" />
						</div>
						<div class="col-lg-12 col-md-12 col-sm-12 col-12 form-col">
							<label>Message<sup style="color:red;">*</sup></label>
							<textarea class="form-control" cols="40" id="message" name="message" rows="10"></textarea>
							<p id="ermessage" style="display:none;" class="myerror"></p>
						</div>
						<div class="col-lg-12 col-md-12 col-sm-12 col-12 form-col text-center">
							
						</div>
						<div class="col-lg-12 col-md-12 col-sm-12 col-12 text-center">
							<p id="success" style="display:none;" class="mysuccess">Thank you for contacting us.</p>
							<p id="error" style="display:none;" class="myerror">Error form not submit try again.</p>
						</div>			
						<div class="col-lg-12 col-md-12 col-sm-12 col-12 text-center form-col">
							<button class="mybutton" disabled type="button" href="javascript:;" onclick="contactus();">Submit</button>
						</div>
					</div>
				</form>
		</div>
	</div>
</div>
<script src="<?php echo base_url(); ?>public_html/frontend/js/jquery-3.3.1.min.js"></script>
<script type="text/javascript">
	//contactus page
	function contactus()
	{
        $('#full_name').css('border', '1px solid #d1d1d1');
        $('#email').css('border', '1px solid #d1d1d1');
        $('#message').css('border', '1px solid #d1d1d1');
        var full_name = $('#full_name').val();
        var subject = $('#subject').val();
        var email = $('#email').val();
        var message = $('#message').val();
        var error = 0;
        if (full_name == '') {
            $('#full_name').css('border-color', 'red');
            $('#full_name').focus();
			$("#erfname").hide();
			$("#eremail").hide();
			$("#ermessage").hide();
			$("#erfname").show();
			$("#erfname").html("Please provide a full name.");
            error++;
		}else 
        if (email == '') {
            $('#email').css('border-color', 'red');
            $('#email').focus();
			$("#erfname").hide();
			$("#eremail").hide();
			$("#ermessage").hide();
			$("#eremail").show();
			$("#eremail").html("Please provide a email address.");
            error++;
		}else
        if (!validateEmail(email)) {
            error++;
            $('#email').css('border-color', 'red');
            $('#email').focus();
			$("#erfname").hide();
			$("#eremail").hide();
			$("#ermessage").hide();
			$("#eremail").show();
			$("#eremail").html("Please provide a valid email address.");
		}else
        if (message == '') {
            $('#message').css('border-color', 'red');
            $('#message').focus();
			$("#erfname").hide();
			$("#eremail").hide();
			$("#ermessage").hide();
			$("#ermessage").show();
			$("#ermessage").html("Please provide a message.");
            error++;
		}
        if (error == 0) {
            $.ajax({
                url: "<?php echo base_url().'contact-us-submit';?>",
                data: {
                    full_name: full_name,
                    subject: subject,
                    email: email,
                    message: message
				},
                type: "POST",
                success: function (res) 
				{
				    //console.log(res1);
					// exit;
					$("#success").hide();
					$("#error").hide();
					$("#erfname").hide();
					$("#eremail").hide();
					$("#ermessage").hide();
					if(res == "1")
					{
						$('#subject').val("");
						$('#full_name').val("");
						$('#email').val("");
						$('#message').val("");
						$("#success").show();
						$("#success").html("Thank You! We will get back to you soon!");
						grecaptcha.reset();
					}
					else
					{
						$('#subject').val("");
						$('#full_name').val("");
						$('#email').val("");
						$('#message').val("");
						$("#error").show();
						$("#error").html("Error Form not submit try again.");
						grecaptcha.reset();
					}
                    setTimeout(function(){
                        $("#success").hide();
                        $("#error").hide();
					}, 3000);
				}
			});
		}
	}
	function validateEmail(email) {
        var re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
        return re.test(email);
	}
</script>
<?php require "template/footer.php"; ?>
<script src="https://www.google.com/recaptcha/api.js"></script>
<script type="text/javascript">
	var onloadCallback = function() {
        grecaptcha.render('html_element', {
			'sitekey' : '6LfFUKcdAAAAAHkoVxpt9N9oaSfqYBX4tKT8-Aun'
		});
	};
	function recaptcha_callback() {
		$('.mybutton').prop("disabled", false);
	};
</script>