<section class="content-header">
	<h1>
        Coupons
        <small>New Stores Coupons List</small>
	</h1>
	<ol class="breadcrumb">
        <li><a href="<?php echo base_url('Dashboard'); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="">Coupons</li>
        <li class="active">New Stores Coupons List</li>
	</ol>
</section>
<!-- Main content -->
<section class="content">
	<div class="row">
		<div class="col-xs-12">
			<?php
				if($this->session->flashdata())
				{
					foreach($this->session->flashdata() as $key => $value):
					if($key == 'update' || $key == 'saved')
					{
						$alert_class = 'alert-success';
					}else
					{
						$alert_class = 'alert-danger';
					}
				?>
				<div class="alert alert-block <?php echo $alert_class; ?>">
					<button type="button" class="close" data-dismiss="alert">
						<i class="icon-remove"></i>
					</button>
					<p>
						<strong>
							<i class="icon-ok"></i>
							<?php echo ucwords(strtolower($key)); ?> !
						</strong>
						<?php echo $value; ?>
					</p>
				</div>
				<?php
					endforeach;
				}  ?>
				<div class="row">
					<!-- left column -->
					<div class="col-md-6">
						<!-- general form elements -->
						<div class="box box-primary">
							<div class="box-header with-border">
								<h3 class="box-title">Filter New Stores Coupons <i class="loading1 fa fa-spinner fa-spin orange bigger-125 hide"></i></h3> 
							</div>
							<!-- /.box-header -->
							<!-- form start -->
							<div class="box-body">
								<div class="form-group">
									<label for="exampleInputEmail1">Search By</label>
									<input type="text" class="form-control" id="search_all" placeholder="Search By" name="search_all"/>
								</div>
							</div>
							<!-- /.box-body -->
							<div class="box-footer">
								<button type="button" name="search_ncoupons" id="search_ncoupons" class="btn btn-primary pull-right">Search</button>
							</div>
						</div>
						<!-- /.box -->
					</div>
				</div>	
				<div class="box" id="ajax_search_ncoupons">
					<div class="box-header">
						<h3 class="box-title">Results for New Stores Coupons List</h3>
					</div>
					<!-- /.box-header -->
					<div class="box-body">
						<table id="" class="table table-bordered table-striped">
							<thead>
								<tr>
									<th>Store Id</th>
									<th>Coupon Id</th>
									<th>Coupon Title</th>                 
									<th>Coupon Code</th>
									<th>Coupon Offer</th>
									<th>Coupon Expiry</th>                            
									<th>Status</th>
									<th>Detail</th>
									<th>Action</th>
								</tr>
							</thead>
							<tbody>
								<?php
									if(!empty($result_set))
									{
										foreach($result_set as $row)
										{
										?>
										<tr>
											<td><?php echo $row->store_id; ?></td>
											<td><?php echo $row->coupon_id; ?></td>
											<td><?php echo $row->coupon_title; ?></td>
											<td><?php echo $row->coupon_code; ?></td>
											<td><?php echo $row->coupon_offer; ?></td>
											<td><?php echo $row->coupon_expiry; ?></td>
											<td>
												<?php
													if($row->is_active == '1')
													{
													?>
													<button type="button" class="btn btn-block btn-success btn-xs">Enable</button>
													<?php
														}else{
													?>
													<button type="button" class="btn btn-block btn-danger btn-xs">Disable</button>
													<?php
													}
												?>
											</td>
											<td> <a class="green" title="Details" href="<?php echo base_url('Coupons/coupons_details/'.$row->id.''); ?>">
												<i class="fa fa-eye bigger-130"></i>
											</a>
											</td>
											<td> <a class="green" title="Update" href="<?php echo base_url('Coupons/coupons_action/'.$row->id.''); ?>">
												<i class="fa fa-pencil bigger-130"></i>
											</a>
											</td>
										</tr>
										<?php
										}
									}
								?>
							</tbody>
						</table>
						<div class="col-xs-12 text-center">
							<?php echo $this->ajax_pagination->create_links(); ?> <i class="loading fa fa-spinner fa-spin orange bigger-125 hide"></i>
						</div>
					</div>
					<!-- /.box-body -->
				</div>
				<!-- /.box -->
		</div>
	</div>
	<!-- /.row -->
</section>
<script type="text/javascript">
	function searchFilterNCoupons(page_num) 
	{
		page_num = page_num?page_num:0;
		var search_all = $('#search_all').val();
		$.ajax({
			type: 'POST',
			url: '<?php echo base_url(); ?>Coupons/ajax_ncoupons_list/'+page_num,
			data:'page='+page_num+'&search_all='+search_all,
			beforeSend: function () {
				$('.loading').removeClass('hide');
			},
			success: function (html) {
				$('#ajax_search_ncoupons').html(html);
				$('.loading').addClass("hide");
			}
		});
	}
</script>