<?php
	defined('BASEPATH') OR exit('No direct script access allowed');
	class Mdl_coupons extends CI_Model {
		function __construct()
		{
			parent::__construct();
			Modules::run('Login/_login');
		}
		//check relation reference
		public function get_relation_pax($table,$column,$reference,$input)
		{
			$this->db->select($column);
			$this->db->where($reference,$input);
			$result =  $this->db->get($table)->result();
			if(empty($result))
			{
				return 0;
			}
			else
			{
				return $result[0]->$column;
			}
		}
		//Get Multiple Record
		public function check_already_exists_multiple($table,$get_column,$wheres,$type)
		{
			$this->db->select($get_column);
			foreach($wheres as $key_wh => $wh):
            $this->db->where($key_wh,$wh);
            endforeach;
			$query =  $this->db->get($table);   
			if($type == 1)
			{
				$count  = $query->num_rows();
				$return = $count;
			}
			if($type == 2)
			{
				$Q_result  = $query->result();
				$return = $Q_result;
			}
			if($type == 3)
			{
				$Q_result_array  = $query->result_array();
				$return = $Q_result_array;
			}
			if($type == 4)
			{				
				$count  = $query->num_rows();
				$return = $count;
				$Q_result  = $query->result();
				$return = $Q_result;
				$Q_result_array  = $query->result_array();
				$return = $Q_result_array;
				$return = array();
				$return['1']['count'] = $count;
				$return['2']['Query_result'] = $Q_result;
				$return['3']['Query_result_array'] = $Q_result_array;
			}
			return $return;
		}		
		/*
			* Insert data into the database
			* @param $data data to be insert based on the passed parameters
		*/
		public function insert($data = array(),$table) 
		{
			if(!empty($data))
			{
				$data['created_date'] = date('Y-m-d H:i:s');
				$data['created_by'] = $this->session->userdata('id');
				// Insert data
				$insert = $this->db->insert($table, $data);
				// Return the status
				return $insert?$this->db->insert_id():false;
			}
			return false;
		}
		/*
			* Update data into the database
			* @param $data array to be update based on the passed parameters
			* @param $condition array filter data
		*/
		public function update($data, $condition = array(),$table) {
			if(!empty($data)){
				$data['modify_date'] = date('Y-m-d H:i:s');
				$data['modify_by'] = $this->session->userdata('id');
				// Update data
				$update = $this->db->update($table, $data, $condition);
				// Return the status
				return $update?true:false;
			}
			return false;
		}
		//All Coupons Data With Searching
		function getRowsCoupons($params = array())
		{
			$all = "";
			if(!empty($params['search']['mycolumn']))
			{
				$exp = explode(',',$params['search']['mycolumn']);
				$count = count($exp);
				$search_all = array_search('all', $exp, true);
				/* $enable = array_search('status_enable', $exp, true);
					$disable = array_search('status_disable', $exp, true);
				$status_all = array_search('status_all', $exp, true); */
				if($search_all)
				{
					$all = "yes";
				}
			}
			/* echo "<pre>";
				print_r($params);
			exit; */
			//print_r($params);
			$this->db->select('dj_offers.*,dj_brands.*,dj_offers.is_active as coupon_status');
			$this->db->from('dj_offers');			
			if(!empty($params['search']['search_all']) && empty($params['search']['mycolumn']) || $all == 'yes')
			{
				$this->db->group_start();
				$this->db->or_like('dj_offers.network_id',$params['search']['search_all']);
				$this->db->or_like('dj_offers.coupon_id',$params['search']['search_all']);
				$this->db->or_like('dj_offers.store_id',$params['search']['search_all']);
				$this->db->or_like('dj_offers.coupon_title',$params['search']['search_all']);
				$this->db->or_like('dj_offers.coupon_sub_title',$params['search']['search_all']);
				$this->db->or_like('dj_offers.coupon_code',$params['search']['search_all']);
				$this->db->or_like('dj_offers.coupon_offer',$params['search']['search_all']);
				$this->db->or_like('dj_offers.coupon_type',$params['search']['search_all']);
				$this->db->or_like('dj_offers.comment',$params['search']['search_all']);
				$this->db->or_like('dj_offers.coupon_expiry',$params['search']['search_all']);
				$this->db->or_like('dj_offers.coupon_deep_link',$params['search']['search_all']);
				$this->db->or_like('dj_offers.coupon_priority',$params['search']['search_all']); 
				$this->db->or_like('dj_offers.is_active',$params['search']['search_all']); 
				$this->db->or_like('dj_brands.store_name',$params['search']['search_all']);
				$this->db->group_end();
			}
			else
			{
				if(!empty($params['search']['mycolumn']))
				{
					if($count == 1)
					{
						if($params['search']['mycolumn'] == "dj_offers.store_id" || $params['search']['mycolumn'] == "dj_offers.network_id")
						{
							$this->db->where($params['search']['mycolumn'],$params['search']['search_all']);
						}
						else
						{
							$this->db->like($params['search']['mycolumn'],$params['search']['search_all']);
						}
					}
					else
					{
						/*  */
						foreach($exp as $key_wh => $wh):
						$this->db->or_like($wh,$params['search']['search_all']);
						endforeach;						
					}
				}
			}
			if(!empty($params['search']['filter_status']))
			{
				if($params['search']['filter_status'] == "status_enable")
				{
					$this->db->where('dj_offers.is_active','1');
				}
				else if($params['search']['filter_status'] == "status_disable")
				{
					$this->db->where('dj_offers.is_active','0');
				}
			}
			$this->db->order_by('dj_offers.coupon_expiry','desc');
			//set start and limit
			if(array_key_exists("start",$params) && array_key_exists("limit",$params)){
				$this->db->limit($params['limit'],$params['start']);
				}elseif(!array_key_exists("start",$params) && array_key_exists("limit",$params)){
				$this->db->limit($params['limit']);
			} 
			//$this->db->limit(100);
			$this->db->join('dj_brands','dj_brands.store_id = dj_offers.store_id');
			$query = $this->db->get();
			//	echo $this->db->last_query();
			//exit;
			//return fetched data
			if($query->num_rows() > 0)
			{
				return $query->result();
			} 
			else
			{
				return 0;
			}
		}
		//All New Coupons Data With Searching
		function getRowsNCoupons($params = array())
		{
			$this->db->select('*');
			$this->db->from('dj_offers');
			$this->db->where('store_id','10000001');
			if(!empty($params['search']['search_all']))
			{
				$this->db->like('coupon_title',$params['search']['search_all']);
				//$this->db->or_where('store_id',$params['search']['search_all']);
				$this->db->or_like('coupon_id',$params['search']['search_all']);
				$this->db->or_where('coupon_code',$params['search']['search_all']);
				$this->db->or_where('coupon_offer',$params['search']['search_all']);
				$this->db->or_like('coupon_sub_title',$params['search']['search_all']);
			}
			$this->db->order_by('id','desc');
			//set start and limit
			if(array_key_exists("start",$params) && array_key_exists("limit",$params)){
				$this->db->limit($params['limit'],$params['start']);
				}elseif(!array_key_exists("start",$params) && array_key_exists("limit",$params)){
				$this->db->limit($params['limit']);
			}
			$query = $this->db->get();
			//return fetched data
			if($query->num_rows() > 0)
			{
				return $query->result();
			} 
			else
			{
				return 0;
			}
		}
		//All Store Dropdown
		public function store_dd($id = null)
		{
			$this->db->select('*');
			if($id != null)
			{
				$this->db->where('store_id',$id);
			}
			$this->db->limit('1000');
			$this->db->where('is_active',"enable");
			$result =  $this->db->get('dj_brands')->result();
			$array = array(
			'' => 'Select Store'
			);
			if(count($result)){
				foreach($result as $res){
					$array[$res->store_id] = $res->store_name;
				}
			}
			return $array;
		}
		//All Network Dropdown
		public function network_dd($id = null)
		{
			$this->db->select('*');
			if($id != null)
			{
				$this->db->where('network_id',$id);
			}
			// $this->db->where('parent_cate_id',0);
			$this->db->where('is_active',"enable");
			$result =  $this->db->get('dj_networks')->result();
			$array = array(
			'' => 'Select Network'
			);
			if(count($result)){
				foreach($result as $res){
					$array[$res->network_id] = $res->network_name;
				}
			}
			return $array;
		}
		//get coupons excel conditions in
		public function getCouponsExport($coupons_id = null,$mysearch = null,$mycolumn = null,$filter_status = null)
		{
			//Where Store Ids IN
			if(!empty($coupons_id))
			{
				$this->db->select('*');
				$this->db->where_in('id',$coupons_id);
				$order = sprintf('FIELD(id, %s)', implode(', ', $coupons_id));
				$this->db->order_by($order);
				$result =  $this->db->get('dj_offers')->result();
				//echo $this->db->last_query();
				//exit;
				if(empty($result))
				{
					return 0;
				}
				else
				{
					return $result;
				}
			}
			else
			{
				$all = "";
				if(!empty($mycolumn))
				{
					$exp = explode(',',$mycolumn);
					$count = count($exp);
					$search_all = array_search('all', $exp, true);
					if($search_all)
					{
						$all = "yes";
					}
				}
				$this->db->select('dj_offers.*,dj_brands.*,dj_offers.is_active as coupon_status');
				$this->db->from('dj_offers');
				if(!empty($mysearch) && empty($mycolumn) || $all == 'yes')
				{
					$this->db->group_start();
					$this->db->or_like('dj_offers.network_id',$mysearch);            
					$this->db->or_like('dj_offers.coupon_id',$mysearch);            
					$this->db->or_like('dj_offers.store_id',$mysearch);
					$this->db->or_like('dj_offers.coupon_title',$mysearch);
					$this->db->or_like('dj_offers.coupon_sub_title',$mysearch);
					$this->db->or_like('dj_offers.coupon_code',$mysearch);
					$this->db->or_like('dj_offers.coupon_offer',$mysearch);
					$this->db->or_like('dj_offers.coupon_type',$mysearch);
					$this->db->or_like('dj_offers.comment',$mysearch);
					$this->db->or_like('dj_offers.coupon_expiry',$mysearch);
					$this->db->or_like('dj_offers.coupon_deep_link',$mysearch);
					$this->db->or_like('dj_offers.coupon_priority',$mysearch); 
					$this->db->or_like('dj_offers.is_active',$mysearch); 
					$this->db->or_like('dj_brands.store_name',$mysearch);
					$this->db->group_end();
				}
				else
				{
					if(!empty($mycolumn))
					{
						if($count == 1)
						{	
							if($mycolumn == "dj_offers.store_id" || $mycolumn == "dj_offers.network_id")
							{
								$this->db->where($mycolumn,$mysearch);
							}
							else
							{
								$this->db->like($mycolumn,$mysearch);
							}
							//$this->db->like($mycolumn,$mysearch);
						}
						else
						{
							foreach($exp as $key_wh => $wh):
							$this->db->or_like($wh,$mysearch);
							endforeach;						
						}
					}
				}
				if(!empty($filter_status))
				{
					if($filter_status == "status_enable")
					{
						$this->db->where('dj_offers.is_active','1');
					}
					else if($filter_status == "status_disable")
					{
						$this->db->where('dj_offers.is_active','0');
					}
				}
				$this->db->order_by('dj_offers.coupon_expiry','desc');
				$this->db->join('dj_brands','dj_brands.store_id = dj_offers.store_id');
				$query = $this->db->get();
				if($query->num_rows() > 0)
				{
					return $query->result();
				} 
				else
				{
					return 0;
				}				
			}			
		}		
		//Get Total Coupons By Store Ids
		public function get_total_coupons_list($store_id)
		{
			$query = $this->db->query("SELECT slug,SUM(gc.is_views) as total_views,COUNT(gs.slug) total_counts,SUM(IF(date(gc.coupon_expiry) < CURDATE(),1,0)) as inactive,SUM(IF(date(gc.coupon_expiry) > CURDATE(),1,0)) as active FROM dj_brands gs LEFT JOIN dj_offers gc ON gs.store_id = gc.store_id WHERE gs.store_id = '".$store_id."' GROUP by gs.slug");		
			//echo $this->db->last_query();
			//exit;
			$result =  $query->result();
			return $result;
		}
		//Get Last Date Coupons By Store Ids
		public function get_last_date_coupons_list($store_id)
		{
			$query = $this->db->query("SELECT gc.created as coupon_created,gc.modify_date as coupon_modified FROM dj_offers gc WHERE gc.store_id = '".$store_id."' order by gc.created DESC,gc.modify_date DESC");
			//echo $this->db->last_query();
			//exit;
			$result =  $query->result();
			return $result;
		}
	}		