<?php
	defined('BASEPATH') OR exit('No direct script access allowed');
	class Coupons extends MX_Controller {
		/**
			* Index Page for this controller.
			*
			* Maps to the following URL
			* 		http://example.com/index.php/welcome
			*	- or -
			* 		http://example.com/index.php/welcome/index
			*	- or -
			* Since this controller is set as the default controller in
			* config/routes.php, it's displayed at http://example.com/
			*
			* So any other public methods not prefixed with an underscore will
			* map to /index.php/welcome/<method_name>
			* @see http://codeigniter.com/user_guide/general/urls.html
		*/
		function __construct() {
			parent::__construct();
			// Load member model
			$this->load->model('Mdl_coupons');
			// Load form validation library
			$this->load->library('form_validation');
			$this->load->library('Ajax_pagination');
			// Load file helper
			$this->load->helper('file');
			$this->load->library('email');
			Modules::run('Login/_login');
			//Coupons List Data Par Page
			$this->perPageCoupon = 25;
			$this->perPageNCoupon = 50;
		}
		public function index()
		{
			redirect(base_url().'_404_page.html','refresh');
		}
		//Import Coupons
		public function import_coupons()
		{
			$post = $this->input->post();
			if(isset($post['importSubmit']))
			{
				$this->load->library('PHPExcel');
				$data_post   	= $this->input->post();
				if($_FILES['upload_file']['name']!="")
				{
					$targetDir = FCPATH."public_html/backend/file/coupons_file/";
					$fileName = "coupons_".date('dmYHis').$_FILES['upload_file']['name'];
					//move_uploaded_file($_FILES['upload_file']['tmp_name'], $targetDir.$fileName);
					//$inputFileName = FCPATH."public_html/backend/file/stores_file/".$fileName;
					$inputFileName = $_FILES['upload_file']['tmp_name'];
					try 
					{
						$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
						$objReader = PHPExcel_IOFactory::createReader($inputFileType);
						$objPHPExcel = @$objReader->load($inputFileName);
					}
					catch(Exception $e) 
					{
						die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
						$data['content']  = 'Coupons/import_coupons';
						$this->load->view('Template/template',$data);
					}
					$cell_collection = $objPHPExcel->getActiveSheet()->getCellCollection();
					$createArray = array
					(
					'Store Id',
					'Coupon Id',
					'Title',		
					'Description',
					'Code',
					'Offer',		
					'Offer Type',
					'Comment',		
					'Expiry Date',		
					'Deep Link',		
					'Coupon Priority',
					);										
					$arr_data = array();
					$header = array();
					foreach ($cell_collection as $cell) 
					{
						$column = $objPHPExcel->getActiveSheet()->getCell($cell)->getColumn();
						$row = $objPHPExcel->getActiveSheet()->getCell($cell)->getRow();
						$data_value = $objPHPExcel->getActiveSheet()->getCell($cell)->getValue();
						//header will/should be in row 1 only. of course this can be modified to suit your need.
						if ($row == 1) 
						{
							$header[] = $data_value;
						}
						elseif ($data_value != NULL) 
						{
							$arr_data[$row][$column] = $data_value;
						}
					}
					$res = $this->identical_values($createArray,$header);
					if ($res == "yes") 
					{
						$message = "";
						$status = "yes";
						$alreadyCount = $insertCount = $updateCount = $rowCount = $notAddCount = 0;
						foreach ($arr_data as $key => $data) 
						{
							if(empty(($data['A'])) || empty(($data['C'])) || empty(($data['F'])) || empty(($data['G'])) || empty(($data['I'])))
							{
								$status = "no";
								$message = "Plz fill out required column such as (store id,title,offer,offer type,expiry date) on Row No: ".$key;
								break;
							}
							/* else if(strpos($data['C']," ") || strpos($data['C'],"'") || strpos($data['C'],".") || strpos($data['C'],","))
								{
								$status = "no";
								$message = "Plz remove space '., in slug on Row No: ".$key;
								break;
							} */
							else
							{
								//$net_id = $this->Mdl_coupons->get_relation_pax('dj_networks','network_id','network_id',$data['L']);
								/* $cat_id = $this->Mdl_coupons->get_relation_pax('dj_categories','cate_id','cate_id',$data['H']);
									$net_id = $this->Mdl_coupons->get_relation_pax('dj_networks','network_id','network_id',$data['A']);
									if($cat_id == 0)
									{
									$status = "no";
									$message = "Plz enter correct category id on Row No: ".$key;
									break;
									}
									else if($net_id == 0)
									{
									$status = "no";
									$message = "Plz enter correct network id on Row No: ".$key;
									break;
									}
									else
									{
									$status = "yes";
								} */
								$status = "yes";	
							}						
						}				
						$duplicate_slug = array();
						foreach ($arr_data as $key2 => $data2) 
						{
							$duplicate_slug[$key2] = $data2['A'];
						}
						$final_dd = array_diff_assoc($duplicate_slug,array_unique($duplicate_slug));
						if($status == "no")
						{
							//$this->session->set_flashdata('error', $message); 
							$data['myerror1']  = $message;
							//	exit;
							//echo "<pre>qq"; 
							//print_r($message);
							$data['content']  = 'Coupons/import_coupons';
							$this->load->view('Template/template',$data);
						}
						else
						{
							/* if(!empty($final_dd))
								{
								$abc = implode(",",array_keys($final_dd));
								$status = "no";
								$message = "Plz remove duplicate store id on Row No: ".$abc;
								$this->session->set_flashdata('error', $message);
								}
								else
							{ */
							foreach ($arr_data as $key1 => $data1) 
							{
								$rowCount++;
								$this->db->trans_start();
								$where_stores = array(
								'store_id' => $data1['A']
								);
								$prevCountStore = $this->Mdl_coupons->check_already_exists_multiple('dj_brands','store_id',$where_stores,4);
								//Update Stores
								if($prevCountStore[1]['count'] > 0)
								{
									$net_id = $this->Mdl_coupons->get_relation_pax('dj_brands','network_id','store_id',@$data1['A']);
									//Check Already Exists Offers
									$where_coupons = array(
									'store_id' => $data1['A'],
									'coupon_id' => @$data1['B'],
									'network_id' => @$net_id,
									);
									$prevOffers = $this->Mdl_coupons->check_already_exists_multiple('dj_offers','*',$where_coupons,4);
									//Update Stores
									if($prevOffers[1]['count'] > 0)
									{
										$alreadyCount++;
									}
									else
									{
										$insertData211 = array
										(
										'store_id' => $data1['A'],
										'coupon_id' => @$data1['B'],
										'coupon_title' => $data1['C'],						
										'coupon_desc' => @$data1['D'],
										'coupon_code' => @$data1['E'],
										'coupon_offer' => $data1['F'],
										'comment' => @$data1['H'],
										'coupon_expiry' => str_replace("\"","",$data1['I']),
										'coupon_type' => $data1['G'],
										'coupon_deep_link' => @$data1['J'],
										'coupon_priority' => @$data1['K'],
										'network_id' => @$net_id,
										'is_active' => "1",
										);
										$update = $this->Mdl_coupons->insert($insertData211, 'dj_offers');
										$updateCount++;
									}
								} //Insert New Stores (10000001)
								else
								{
									/* if(!empty($data['E']))
										{
										$store_logo = $data['E'];
										}
										else
										{
										$store_logo = "";
									} */
									//Add New Coupons
									$insertData2 = array
									(
									'store_id' => "10000001",
									'network_id' => "0",
									'coupon_id' => @$data1['B'],
									'coupon_title' => $data1['C'],						
									'coupon_desc' => @$data1['D'],
									'coupon_code' => @$data1['E'],
									'coupon_offer' => $data1['F'],
									'comment' => @$data1['H'],
									'coupon_expiry' => str_replace("\"","",$data1['I']),
									'coupon_type' => $data1['G'],
									'coupon_deep_link' => @$data1['J'],
									'coupon_priority' => @$data1['K'],
									);
									$insert = $this->Mdl_coupons->insert($insertData2, 'dj_offers');
									$insertCount++;
								} 
								$this->db->trans_complete();
							}
							// Status message with imported data count
							$notAddCount = ($rowCount - ($insertCount + $updateCount) - $alreadyCount);				
							if(@$insert || @$update || @$alreadyCount)
							{
								@move_uploaded_file($_FILES['upload_file']['tmp_name'], $targetDir.$fileName);
								$message = 'Coupons Imported Successfully. Total Rows ('.$rowCount.') | Inserted ('.$updateCount.') | Duplicate ('.$insertCount.') | Already Add ('.$alreadyCount.') | Not Inserted ('.$notAddCount.')';
								//$this->session->set_flashdata('saved', $message);
								$data['myerror']  = $message;	
							}
							else
							{
								$message = 'Coupons Not Imported Plz Try Again...!';
								$data['myerror1']  = $message;	 
							}
							/* } */
						}
						$data['content']  = 'Coupons/import_coupons';
						$this->load->view('Template/template',$data);
						//exit;
					}
					else 
					{
						//$this->session->set_flashdata('error', 'file data error plz upload correct format data'); 
						$data['myerror1']  = 'file data error plz upload correct format data';					
						//redirect(base_url().'Coupons/import_coupons','refresh'); 
						$data['content']  = 'Coupons/import_coupons';
						$this->load->view('Template/template',$data); 
					}         			
				}
				else
				{
					/* $this->session->set_flashdata('error', 'your data not uploaded plz try again');    
					redirect(base_url().'Coupons/import_coupons','refresh');   */
					$data['myerror1']  = 'your data not uploaded plz try again';
					$data['content']  = 'Coupons/import_coupons';
					$this->load->view('Template/template',$data);
				}
			}
			else
			{
				$data['content']  = 'Coupons/import_coupons';
				$this->load->view('Template/template',$data);
				//$this->load->view('import_coupons');				
			}
		}
		//import_coupons_submit
		public function import_coupons_submit_OLD()
		{
			$this->load->library('PHPExcel');
			$data_post   	= $this->input->post();
			if($_FILES['upload_file']['name']!="")
			{
				$targetDir = FCPATH."public_html/backend/file/coupons_file/";
				$fileName = "coupons_".date('dmYHis').$_FILES['upload_file']['name'];
				//move_uploaded_file($_FILES['upload_file']['tmp_name'], $targetDir.$fileName);
				//$inputFileName = FCPATH."public_html/backend/file/stores_file/".$fileName;
				$inputFileName = $_FILES['upload_file']['tmp_name'];
				try 
				{
					$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
					$objReader = PHPExcel_IOFactory::createReader($inputFileType);
					$objPHPExcel = $objReader->load($inputFileName);
				}
				catch(Exception $e) 
				{
					die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
				}
				$cell_collection = $objPHPExcel->getActiveSheet()->getCellCollection();
				$createArray = array
				(
				'Store Id',
				'Coupon Id',
				'Title',		
				'Description',
				'Code',
				'Offer',		
				'Offer Type',
				'Comment',		
				'Expiry Date',		
				'Deep Link',		
				'Coupon Priority',
				);										
				$arr_data = array();
				$header = array();
				foreach ($cell_collection as $cell) 
				{
					$column = $objPHPExcel->getActiveSheet()->getCell($cell)->getColumn();
					$row = $objPHPExcel->getActiveSheet()->getCell($cell)->getRow();
					$data_value = $objPHPExcel->getActiveSheet()->getCell($cell)->getValue();
					//header will/should be in row 1 only. of course this can be modified to suit your need.
					if ($row == 1) 
					{
						$header[] = $data_value;
					}
					elseif ($data_value != NULL) 
					{
						$arr_data[$row][$column] = $data_value;
					}
				}
				$res = $this->identical_values($createArray,$header);
				if ($res == "yes") 
				{
					$message = "";
					$status = "yes";
					$insertCount = $updateCount = $rowCount = $notAddCount = 0;
					foreach ($arr_data as $key => $data) 
					{
						if(empty(($data['A'])) || empty(($data['C'])) || empty(($data['F'])) || empty(($data['G'])) || empty(($data['I'])))
						{
							$status = "no";
							$message = "Plz fill out required column such as (store id,title,offer,offer type,expiry date) on Row No: ".$key;
							break;
						}
						/* else if(strpos($data['C']," ") || strpos($data['C'],"'") || strpos($data['C'],".") || strpos($data['C'],","))
							{
							$status = "no";
							$message = "Plz remove space '., in slug on Row No: ".$key;
							break;
						} */
						else
						{
							//$net_id = $this->Mdl_coupons->get_relation_pax('dj_networks','network_id','network_id',$data['L']);
							/* $cat_id = $this->Mdl_coupons->get_relation_pax('dj_categories','cate_id','cate_id',$data['H']);
								$net_id = $this->Mdl_coupons->get_relation_pax('dj_networks','network_id','network_id',$data['A']);
								if($cat_id == 0)
								{
								$status = "no";
								$message = "Plz enter correct category id on Row No: ".$key;
								break;
								}
								else if($net_id == 0)
								{
								$status = "no";
								$message = "Plz enter correct network id on Row No: ".$key;
								break;
								}
								else
								{
								$status = "yes";
							} */
							$status = "yes";	
						}						
					}				
					$duplicate_slug = array();
					foreach ($arr_data as $key2 => $data2) 
					{
						$duplicate_slug[$key2] = $data2['A'];
					}
					$final_dd = array_diff_assoc($duplicate_slug,array_unique($duplicate_slug));
					if($status == "no")
					{
						$this->session->set_flashdata('error', $message);  
					}
					else
					{
						/* if(!empty($final_dd))
							{
							$abc = implode(",",array_keys($final_dd));
							$status = "no";
							$message = "Plz remove duplicate store id on Row No: ".$abc;
							$this->session->set_flashdata('error', $message);
							}
							else
						{ */
						foreach ($arr_data as $key1 => $data1) 
						{
							$rowCount++;
							$this->db->trans_start();
							$where_stores = array(
							'store_id' => $data1['A']
							);
							$prevCountStore = $this->Mdl_coupons->check_already_exists_multiple('dj_brands','store_id',$where_stores,4);
							//Update Stores
							if($prevCountStore[1]['count'] > 0)
							{
								$net_id = $this->Mdl_coupons->get_relation_pax('dj_brands','network_id','store_id',@$data1['A']);
								$insertData211 = array
								(
								'store_id' => $data1['A'],
								'coupon_id' => @$data1['B'],
								'coupon_title' => $data1['C'],						
								'coupon_desc' => @$data1['D'],
								'coupon_code' => @$data1['E'],
								'coupon_offer' => $data1['F'],
								'comment' => @$data1['H'],
								'coupon_expiry' => $data1['I'],
								'coupon_type' => $data1['G'],
								'coupon_deep_link' => @$data1['J'],
								'coupon_priority' => @$data1['K'],
								'network_id' => @$net_id,
								'is_active' => "1",
								);
								$update = $this->Mdl_coupons->insert($insertData211, 'dj_offers');
								$updateCount++;
							} //Insert New Stores (10000001)
							else
							{
								/* if(!empty($data['E']))
									{
									$store_logo = $data['E'];
									}
									else
									{
									$store_logo = "";
								} */
								//Add New Coupons
								$insertData2 = array
								(
								'store_id' => "10000001",
								'network_id' => "0",
								'coupon_id' => @$data1['B'],
								'coupon_title' => $data1['C'],						
								'coupon_desc' => @$data1['D'],
								'coupon_code' => @$data1['E'],
								'coupon_offer' => $data1['F'],
								'comment' => @$data1['H'],
								'coupon_expiry' => $data1['I'],
								'coupon_type' => $data1['G'],
								'coupon_deep_link' => @$data1['J'],
								'coupon_priority' => @$data1['K'],
								);
								$insert = $this->Mdl_coupons->insert($insertData2, 'dj_offers');
								$insertCount++;
							} 
							$this->db->trans_complete();
						}
						// Status message with imported data count
						$notAddCount = ($rowCount - ($insertCount + $updateCount));				
						if(@$insert || @$update)
						{
							@move_uploaded_file($_FILES['upload_file']['tmp_name'], $targetDir.$fileName);
							$message = 'Coupons Imported Successfully. Total Rows ('.$rowCount.') | Inserted ('.$updateCount.') | Duplicate ('.$insertCount.') | Not Inserted ('.$notAddCount.')';
							$this->session->set_flashdata('saved', $message);  
						}
						else
						{
							$message = 'Coupons Not Imported Plz Try Again...!';
							$this->session->set_flashdata('error', $message);  
						}
						/* } */
					}
					redirect(base_url().'Coupons/import_coupons','refresh');
					exit;
				}
				else 
				{
					$this->session->set_flashdata('error', 'file data error plz upload correct format data');    
					redirect(base_url().'Coupons/import_coupons','refresh'); 
				}         			
			}
			else
			{
				$this->session->set_flashdata('error', 'your data not uploaded plz try again');    
				redirect(base_url().'Coupons/import_coupons','refresh');  
			}
		}
		//Compare Values
		public function identical_values($arrayA,$arrayB)
		{
			sort($arrayA); 
			sort($arrayB); 
			if($arrayA == $arrayB)
			{
				return "yes";
			}
			else
			{
				return "no";
			}
		}
		//export_actice_stores_list
		public function export_actice_stores_list()
		{
			$where_stores = array( 'is_active' => 'enable' );
			$result = $this->Mdl_coupons->check_already_exists_multiple('dj_brands','*',$where_stores,4);
			if($result[1]['count'] > 0)
			{
				$this->load->library('PHPExcel');
				$object = new PHPExcel();
				$object->setActiveSheetIndex(0);
				$table_columns = array("Store Id","Store Name","Slug","Merchant Id","Network Id","Store Logo","Store Display Url","Store Summary","Store Description","Tracking Url","Cate Ids","Comment","Address","Phone","Email","Fb Url","Twitter Url","Youtube","Gplus","Is Featured","Store Priority","Status","Created Date","Created By","Modify Date","Modify By","Is Logo","Parent Category Id","Total Views","Total Coupons","Active","Inactive","Last Updated");
				$object->getActiveSheet()->setTitle('Active Stores List');
				$column = 0;
				foreach($table_columns as $field)
				{
					$object->getActiveSheet()->setCellValueByColumnAndRow($column, 1, $field);
					$column++;
				}
				for ($col = ord('A'); $col <= ord('Z'); $col++) 
				{
					//set column dimension
					$object->getActiveSheet()->getColumnDimension(chr($col))->setAutoSize(true);
					$object->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('H1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('I1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('J1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('K1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('L1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('M1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('N1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('O1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('P1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('Q1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('R1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('S1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('T1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('U1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('V1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('W1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('X1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('Y1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('Z1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('AA1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('AB1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('AC1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('AD1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('AE1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('AF1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('AG1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('AH1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('AI1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('AJ1')->getFont()->setBold(true);
					//change the font size
					$object->getActiveSheet()->getStyle(chr($col))->getFont()->setSize(12);
				}
				$excel_row = 2;
				$i = 1;
				foreach($result[2]['Query_result'] as $row)
				{  
					if(@$row->store_logo != "")
					{
						$image_pic11 = FCPATH."public_html/backend/image/store_logo/" .@$row->store_logo;
						//echo $image_pic;
						if(file_exists($image_pic11))
						{
							$fimg_url11 = "YES";
						}
						else
						{
							$fimg_url11 = "NO";
						}
					}
					else
					{
						$fimg_url11 = "NO";
					}
					$total_views = 0;
					$total_coupon = 0;
					$total_active_coupon = 0;
					$total_inactive_coupon = 0;
					$last_updatedate_coupon = "";
					//get total Coupons
					$total_coupon_check = $this->Mdl_coupons->get_total_coupons_list($row->store_id);
					//print_r($total_coupon);
					if(!empty($total_coupon_check))
					{
						if($total_coupon_check[0]->active == 0 && $total_coupon_check[0]->inactive == 0)
						{
							$total_views = 0;
							$total_coupon = 0;
							$total_active_coupon = 0;
							$total_inactive_coupon = 0;
						}
						else
						{
							$total_views = $total_coupon_check[0]->total_views;
							$total_coupon = $total_coupon_check[0]->total_counts;
							$total_active_coupon = $total_coupon_check[0]->active;
							$total_inactive_coupon = $total_coupon_check[0]->inactive;
						}
					}
					else
					{
						$total_views = 0;
						$total_coupon = 0;
						$total_active_coupon = 0;
						$total_inactive_coupon = 0;
					}
					//get last date coupon
					$last_date_coupon = $this->Mdl_coupons->get_last_date_coupons_list($row->store_id);
					//print_r($last_date_coupon);
					if(!empty($last_date_coupon))
					{
						//$last_updated = strtotime($m_store_coupon[0]->coupon_created);
						$update_date_array = array();
						$create_date_array = array();
						for($i=0; $i<count($last_date_coupon); $i++)
						{
							if(!empty($last_date_coupon[$i]->coupon_modified) && $last_date_coupon[$i]->coupon_modified != "" && $last_date_coupon[$i]->coupon_modified != "0000-00-00 00:00:00")
							{
								$update_date_array[] = ($last_date_coupon[$i]->coupon_modified);
							}
							$create_date_array[] = ($last_date_coupon[$i]->coupon_created);
							/* if(strtotime($m_store_coupon[$i]->coupon_created) > $last_updated)
								{
								$last_updated = strtotime($last_date_coupon[$i]->coupon_created);;
							} */
						}
						$max_update_date_array = "";
						$max_create_date_array = "";
						if(!empty($update_date_array))
						{
							$max_update_date_array = max($update_date_array);
						}
						if(!empty($create_date_array))
						{
							$max_create_date_array = max($create_date_array);
						}
						if(!empty($max_update_date_array) && !empty($max_create_date_array))
						{
							if($max_create_date_array > $max_update_date_array)
							{
								$date_2 = new DateTime($max_create_date_array);
								$f_date = $date_2->format('d-F-Y');
							}
							else
							{
								$date_2 = new DateTime($max_update_date_array);
								$f_date = $date_2->format('d-F-Y');
							}
						}
						else
						{
							$date_2 = new DateTime($max_create_date_array);
							$f_date = $date_2->format('d-F-Y');
						}
						$last_updatedate_coupon = $f_date;
					}
					else
					{
						$last_updatedate_coupon = " ";
					}
					//CREATED DATE & BY //MODIFY DATE & BY
					$final_created_date = "";
					$final_created_by = "";
					$final_modified_date = "";
					$final_modified_by = "";
					if(!empty($row->created_date))
					{
						$date_1 = new DateTime($row->created_date);
						$final_created_date = $date_1->format('d-m-Y H:i:s');
					}
					if(!empty($row->modify_date))
					{
						$date_2 = new DateTime($row->modify_date);
						$final_modified_date = $date_2->format('d-m-Y H:i:s');
					}
					if(!empty($row->created_by))
					{
						$final_created_by = $this->Mdl_coupons->get_relation_pax('login','username','id',$row->created_by);
					}
					if(!empty($row->modify_by))
					{
						$final_modified_by = $this->Mdl_coupons->get_relation_pax('login','username','id',$row->modify_by);
					}
					$object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $row->store_id);
					$object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $row->store_name);
					$object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $row->slug);
					$object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $row->merchant_id);
					$object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $row->network_id);
					$object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $row->store_logo);
					$object->getActiveSheet()->setCellValueByColumnAndRow(6, $excel_row, $row->store_display_url);
					$object->getActiveSheet()->setCellValueByColumnAndRow(7, $excel_row, $row->store_summary);
					$object->getActiveSheet()->setCellValueByColumnAndRow(8, $excel_row, $row->store_desc);
					$object->getActiveSheet()->setCellValueByColumnAndRow(9, $excel_row, $row->tracking_url);
					$object->getActiveSheet()->setCellValueByColumnAndRow(10, $excel_row, $row->cate_ids);
					$object->getActiveSheet()->setCellValueByColumnAndRow(11, $excel_row, $row->comment);
					$object->getActiveSheet()->setCellValueByColumnAndRow(12, $excel_row, $row->address);
					$object->getActiveSheet()->setCellValueByColumnAndRow(13, $excel_row, $row->phone);
					$object->getActiveSheet()->setCellValueByColumnAndRow(14, $excel_row, $row->email);
					$object->getActiveSheet()->setCellValueByColumnAndRow(15, $excel_row, $row->fb_url);
					$object->getActiveSheet()->setCellValueByColumnAndRow(16, $excel_row, $row->twitter_url);
					$object->getActiveSheet()->setCellValueByColumnAndRow(17, $excel_row, $row->youtube);
					$object->getActiveSheet()->setCellValueByColumnAndRow(18, $excel_row, $row->gplus);
					$object->getActiveSheet()->setCellValueByColumnAndRow(19, $excel_row, $row->is_featured);
					$object->getActiveSheet()->setCellValueByColumnAndRow(20, $excel_row, $row->store_priority);
					$object->getActiveSheet()->setCellValueByColumnAndRow(21, $excel_row, $row->is_active);
					$object->getActiveSheet()->setCellValueByColumnAndRow(22, $excel_row, $final_created_date);
					$object->getActiveSheet()->setCellValueByColumnAndRow(23, $excel_row, $final_created_by);
					$object->getActiveSheet()->setCellValueByColumnAndRow(24, $excel_row, $final_modified_date);
					$object->getActiveSheet()->setCellValueByColumnAndRow(25, $excel_row, $final_modified_by);
					$object->getActiveSheet()->setCellValueByColumnAndRow(26, $excel_row, $fimg_url11);
					$object->getActiveSheet()->setCellValueByColumnAndRow(27, $excel_row, $row->parent_cate_id);
					$object->getActiveSheet()->setCellValueByColumnAndRow(28, $excel_row, $total_views);
					$object->getActiveSheet()->setCellValueByColumnAndRow(29, $excel_row, $total_coupon);
					$object->getActiveSheet()->setCellValueByColumnAndRow(30, $excel_row, $total_active_coupon);
					$object->getActiveSheet()->setCellValueByColumnAndRow(31, $excel_row, $total_inactive_coupon);
					$object->getActiveSheet()->setCellValueByColumnAndRow(32, $excel_row, $last_updatedate_coupon);
					$excel_row++;
					$i++;
				}
				$object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel2007');
				header('Content-Type: application/vnd.ms-excel');
				header('Content-Disposition: attachment;filename="Active_Stores_GGD.xlsx"');
				$object_writer->save('php://output');
			}
			else
			{
				$this->session->set_flashdata('error', 'your data not found please try again');    
				redirect(base_url().'Coupons/import_coupons','refresh');  
			}
		}
		//export_deactice_stores_list
		public function export_deactice_stores_list()
		{
			$where_stores = array( 'is_active' => 'disable' );
			$result = $this->Mdl_coupons->check_already_exists_multiple('dj_brands','*',$where_stores,4);
			if($result[1]['count'] > 0)
			{
				$this->load->library('PHPExcel');
				$object = new PHPExcel();
				$object->setActiveSheetIndex(0);
				$table_columns = array("Store Id","Store Name","Slug","Merchant Id","Network Id","Store Logo","Store Display Url","Store Summary","Store Description","Tracking Url","Cate Ids","Comment","Address","Phone","Email","Fb Url","Twitter Url","Youtube","Gplus","Is Featured","Store Priority","Status","Created Date","Created By","Modify Date","Modify By","Is Logo","Parent Category Id","Total Views","Total Coupons","Active","Inactive","Last Updated");
				$object->getActiveSheet()->setTitle('Deactive Stores List');
				$column = 0;
				foreach($table_columns as $field)
				{
					$object->getActiveSheet()->setCellValueByColumnAndRow($column, 1, $field);
					$column++;
				}
				for ($col = ord('A'); $col <= ord('Z'); $col++) 
				{
					//set column dimension
					$object->getActiveSheet()->getColumnDimension(chr($col))->setAutoSize(true);
					$object->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('H1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('I1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('J1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('K1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('L1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('M1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('N1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('O1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('P1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('Q1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('R1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('S1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('T1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('U1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('V1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('W1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('X1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('Y1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('Z1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('AA1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('AB1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('AC1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('AD1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('AE1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('AF1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('AG1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('AH1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('AI1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('AJ1')->getFont()->setBold(true);
					//change the font size
					$object->getActiveSheet()->getStyle(chr($col))->getFont()->setSize(12);
				}
				$excel_row = 2;
				$i = 1;
				foreach($result[2]['Query_result'] as $row)
				{  
					if(@$row->store_logo != "")
					{
						$image_pic11 = FCPATH."public_html/backend/image/store_logo/" .@$row->store_logo;
						//echo $image_pic;
						if(file_exists($image_pic11))
						{
							$fimg_url11 = "YES";
						}
						else
						{
							$fimg_url11 = "NO";
						}
					}
					else
					{
						$fimg_url11 = "NO";
					}
					$total_views = 0;
					$total_coupon = 0;
					$total_active_coupon = 0;
					$total_inactive_coupon = 0;
					$last_updatedate_coupon = "";
					//get total Coupons
					$total_coupon_check = $this->Mdl_coupons->get_total_coupons_list($row->store_id);
					//print_r($total_coupon);
					if(!empty($total_coupon_check))
					{
						if($total_coupon_check[0]->active == 0 && $total_coupon_check[0]->inactive == 0)
						{
							$total_views = 0;
							$total_coupon = 0;
							$total_active_coupon = 0;
							$total_inactive_coupon = 0;
						}
						else
						{
							$total_views = $total_coupon_check[0]->total_views;
							$total_coupon = $total_coupon_check[0]->total_counts;
							$total_active_coupon = $total_coupon_check[0]->active;
							$total_inactive_coupon = $total_coupon_check[0]->inactive;
						}
					}
					else
					{
						$total_views = 0;
						$total_coupon = 0;
						$total_active_coupon = 0;
						$total_inactive_coupon = 0;
					}
					//get last date coupon
					$last_date_coupon = $this->Mdl_coupons->get_last_date_coupons_list($row->store_id);
					//print_r($last_date_coupon);
					if(!empty($last_date_coupon))
					{
						//$last_updated = strtotime($m_store_coupon[0]->coupon_created);
						$update_date_array = array();
						$create_date_array = array();
						for($i=0; $i<count($last_date_coupon); $i++)
						{
							if(!empty($last_date_coupon[$i]->coupon_modified) && $last_date_coupon[$i]->coupon_modified != "" && $last_date_coupon[$i]->coupon_modified != "0000-00-00 00:00:00")
							{
								$update_date_array[] = ($last_date_coupon[$i]->coupon_modified);
							}
							$create_date_array[] = ($last_date_coupon[$i]->coupon_created);
							/* if(strtotime($m_store_coupon[$i]->coupon_created) > $last_updated)
								{
								$last_updated = strtotime($last_date_coupon[$i]->coupon_created);;
							} */
						}
						$max_update_date_array = "";
						$max_create_date_array = "";
						if(!empty($update_date_array))
						{
							$max_update_date_array = max($update_date_array);
						}
						if(!empty($create_date_array))
						{
							$max_create_date_array = max($create_date_array);
						}
						if(!empty($max_update_date_array) && !empty($max_create_date_array))
						{
							if($max_create_date_array > $max_update_date_array)
							{
								$date_2 = new DateTime($max_create_date_array);
								$f_date = $date_2->format('d-F-Y');
							}
							else
							{
								$date_2 = new DateTime($max_update_date_array);
								$f_date = $date_2->format('d-F-Y');
							}
						}
						else
						{
							$date_2 = new DateTime($max_create_date_array);
							$f_date = $date_2->format('d-F-Y');
						}
						$last_updatedate_coupon = $f_date;
					}
					else
					{
						$last_updatedate_coupon = " ";
					}
					//CREATED DATE & BY //MODIFY DATE & BY
					$final_created_date = "";
					$final_created_by = "";
					$final_modified_date = "";
					$final_modified_by = "";
					if(!empty($row->created_date))
					{
						$date_1 = new DateTime($row->created_date);
						$final_created_date = $date_1->format('d-m-Y H:i:s');
					}
					if(!empty($row->modify_date))
					{
						$date_2 = new DateTime($row->modify_date);
						$final_modified_date = $date_2->format('d-m-Y H:i:s');
					}
					if(!empty($row->created_by))
					{
						$final_created_by = $this->Mdl_coupons->get_relation_pax('login','username','id',$row->created_by);
					}
					if(!empty($row->modify_by))
					{
						$final_modified_by = $this->Mdl_coupons->get_relation_pax('login','username','id',$row->modify_by);
					}
					$object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $row->store_id);
					$object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $row->store_name);
					$object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $row->slug);
					$object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $row->merchant_id);
					$object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $row->network_id);
					$object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $row->store_logo);
					$object->getActiveSheet()->setCellValueByColumnAndRow(6, $excel_row, $row->store_display_url);
					$object->getActiveSheet()->setCellValueByColumnAndRow(7, $excel_row, $row->store_summary);
					$object->getActiveSheet()->setCellValueByColumnAndRow(8, $excel_row, $row->store_desc);
					$object->getActiveSheet()->setCellValueByColumnAndRow(9, $excel_row, $row->tracking_url);
					$object->getActiveSheet()->setCellValueByColumnAndRow(10, $excel_row, $row->cate_ids);
					$object->getActiveSheet()->setCellValueByColumnAndRow(11, $excel_row, $row->comment);
					$object->getActiveSheet()->setCellValueByColumnAndRow(12, $excel_row, $row->address);
					$object->getActiveSheet()->setCellValueByColumnAndRow(13, $excel_row, $row->phone);
					$object->getActiveSheet()->setCellValueByColumnAndRow(14, $excel_row, $row->email);
					$object->getActiveSheet()->setCellValueByColumnAndRow(15, $excel_row, $row->fb_url);
					$object->getActiveSheet()->setCellValueByColumnAndRow(16, $excel_row, $row->twitter_url);
					$object->getActiveSheet()->setCellValueByColumnAndRow(17, $excel_row, $row->youtube);
					$object->getActiveSheet()->setCellValueByColumnAndRow(18, $excel_row, $row->gplus);
					$object->getActiveSheet()->setCellValueByColumnAndRow(19, $excel_row, $row->is_featured);
					$object->getActiveSheet()->setCellValueByColumnAndRow(20, $excel_row, $row->store_priority);
					$object->getActiveSheet()->setCellValueByColumnAndRow(21, $excel_row, $row->is_active);
					$object->getActiveSheet()->setCellValueByColumnAndRow(22, $excel_row, $final_created_date);
					$object->getActiveSheet()->setCellValueByColumnAndRow(23, $excel_row, $final_created_by);
					$object->getActiveSheet()->setCellValueByColumnAndRow(24, $excel_row, $final_modified_date);
					$object->getActiveSheet()->setCellValueByColumnAndRow(25, $excel_row, $final_modified_by);
					$object->getActiveSheet()->setCellValueByColumnAndRow(26, $excel_row, $fimg_url11);
					$object->getActiveSheet()->setCellValueByColumnAndRow(27, $excel_row, $row->parent_cate_id);
					$object->getActiveSheet()->setCellValueByColumnAndRow(28, $excel_row, $total_views);
					$object->getActiveSheet()->setCellValueByColumnAndRow(29, $excel_row, $total_coupon);
					$object->getActiveSheet()->setCellValueByColumnAndRow(30, $excel_row, $total_active_coupon);
					$object->getActiveSheet()->setCellValueByColumnAndRow(31, $excel_row, $total_inactive_coupon);
					$object->getActiveSheet()->setCellValueByColumnAndRow(32, $excel_row, $last_updatedate_coupon);
					$excel_row++;
					$i++;
				}
				$object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel2007');
				header('Content-Type: application/vnd.ms-excel');
				header('Content-Disposition: attachment;filename="Deactive_Stores_GGD.xlsx"');
				$object_writer->save('php://output');
			}
			else
			{
				$this->session->set_flashdata('error', 'your data not found please try again');    
				redirect(base_url().'Coupons/import_coupons','refresh');  
			}
		}
		//coupons_list
		public function coupons_list()
		{
			$conditions = array();
			//For Individual Coupons List by Store
			$store_id = $this->uri->segment(3);
			if(!empty($store_id))
			{
				$conditions['search']['mycolumn'] = 'dj_offers.store_id';
				$conditions['search']['search_all'] = $store_id;
				$data['my_store_id'] = $store_id;
			}
			//End		
			//$conditions['search']['filter_status'] = "status_all";
			$page = 0;
			if(!$page){
				$offset = 0;
				}else{
				$offset = $page;
			} 
			//print_r($this->Mdl_coupons->getRowsCoupons());
			if($this->Mdl_coupons->getRowsCoupons($conditions) == 0)
			{
				$totalRec = 0;
			}
			else
			{
				$totalRec = count(@$this->Mdl_coupons->getRowsCoupons($conditions));
			}
			$config['target']      = '#ajax_search_coupons';
			$config['base_url']    = base_url().'Coupons/ajax_coupons_list';
			$config['total_rows']  = $totalRec;
			$config['per_page']    = $this->perPageCoupon;
			$config['link_func']   = 'searchFilterCoupons';
			$this->ajax_pagination->initialize($config);
			$conditions['start'] = $offset;
			$conditions['limit'] = $this->perPageCoupon;
			//For Individual Coupons List by Store
			if(!empty($store_id))
			{
				$data['result_set'] = $this->Mdl_coupons->getRowsCoupons($conditions);
			}
			else
			{
				$data['result_set'] = $this->Mdl_coupons->getRowsCoupons(array('limit'=>$this->perPageCoupon));
			}
			$data['change_limit'] = $this->perPageCoupon;
			$data['mypage'] = $page;
			$data['content']  = 'Coupons/coupons_list';
			$this->load->view('Template/template',$data);
		}
		//Pagination Coupon List
		function ajax_coupons_list()
		{
			$conditions = array();
			$page = $this->input->post('page');
			if(!$page){
				$offset = 0;
				}else{
				$offset = $page;
			}
			$post = $this->input->post();
			/*  echo "<pre>";
				print_r($post);
			exit; */ 
			$search_all = @$post['search_all'];
			$mycolumn = @$post['mycolumn'];
			if(!empty($post['change_limit']))
			{
				$change_limit = @$post['change_limit'];
			}
			else
			{
				$change_limit = 25;
			}
			if(!empty($this->input->post('search_all')))
			{
				$conditions['search']['search_all'] = $search_all;
			}
			if(!empty($mycolumn))
			{
				$conditions['search']['mycolumn'] = $mycolumn;
			}
			if(!empty($post['filter_status']))
			{
				$conditions['search']['filter_status'] = $post['filter_status'];
				$filter_status = $post['filter_status'];
			}
			else
			{
				$conditions['search']['filter_status'] = "status_all";
				$filter_status = "status_all";
			}
			if($this->Mdl_coupons->getRowsCoupons($conditions) == 0)
			{
				$totalRec = 0;
			}
			else
			{
				$totalRec = count($this->Mdl_coupons->getRowsCoupons($conditions));
			}
			$config['target']      = '#ajax_search_coupons';
			$config['base_url']    = base_url().'Coupons/ajax_coupons_list';
			$config['total_rows']  = $totalRec;
			$config['per_page']    = $change_limit;
			$config['link_func']   = 'searchFilterCoupons';
			$this->ajax_pagination->initialize($config);
			$conditions['start'] = $offset;
			$conditions['limit'] = $change_limit;
			$data['result_set'] = $this->Mdl_coupons->getRowsCoupons($conditions);
			$data['change_limit'] = $change_limit;
			$data['filter_status'] = $filter_status;
			$data['mypage'] = $page;
			$this->load->view('Coupons/ajax_coupons_list',$data);
		}
		//new_stores_coupons
		public function new_stores_coupons()
		{
			$conditions = array();
			$page = 0;
			if(!$page){
				$offset = 0;
				}else{
				$offset = $page;
			} 
			if($this->Mdl_coupons->getRowsNCoupons() == 0)
			{
				$totalRec = 0;
			}
			else
			{
				$totalRec = count($this->Mdl_coupons->getRowsNCoupons($conditions));
			}
			//echo $totalRec;
			$config['target']      = '#ajax_search_ncoupons';
			$config['base_url']    = base_url().'Coupons/ajax_ncoupons_list';
			$config['total_rows']  = $totalRec;
			$config['per_page']    = $this->perPageNCoupon;
			$config['link_func']   = 'searchFilterNCoupons';
			$this->ajax_pagination->initialize($config);
			$conditions['start'] = $offset;
			$conditions['limit'] = $this->perPageNCoupon;
			$data['result_set'] = $this->Mdl_coupons->getRowsNCoupons(array('limit'=>$this->perPageNCoupon));
			$data['content']  = 'Coupons/new_stores_coupons';
			$this->load->view('Template/template',$data);
		}
		//Pagination New Stores Coupon List
		function ajax_ncoupons_list()
		{
			$conditions = array();
			$page = $this->input->post('page');
			if(!$page){
				$offset = 0;
				}else{
				$offset = $page;
			}
			$post = $this->input->post();
			$search_all = @$post['search_all'];
			if(!empty($this->input->post('search_all')))
			{
				$conditions['search']['search_all'] = $search_all;
			}
			if($this->Mdl_coupons->getRowsNCoupons($conditions) == 0)
			{
				$totalRec = 0;
			}
			else
			{
				$totalRec = count($this->Mdl_coupons->getRowsNCoupons($conditions));
			}
			$config['target']      = '#ajax_search_ncoupons';
			$config['base_url']    = base_url().'Coupons/ajax_ncoupons_list';
			$config['total_rows']  = $totalRec;
			$config['per_page']    = $this->perPageNCoupon;
			$config['link_func']   = 'searchFilterNCoupons';
			$this->ajax_pagination->initialize($config);
			$conditions['start'] = $offset;
			$conditions['limit'] = $this->perPageNCoupon;
			$data['result_set'] = $this->Mdl_coupons->getRowsNCoupons($conditions);
			$this->load->view('Coupons/ajax_ncoupons_list',$data);
		}
		//coupons_action
		public function coupons_action()
		{
			$id = $this->uri->segment(3);
			if(!empty($id))
			{
				$where_sys = array(
				'id' => $id,
				);
				$getRec = $this->Mdl_coupons->check_already_exists_multiple('dj_offers','*',$where_sys,4);
				//print_r($getRec);
				if(empty($id) || $getRec[1]['count'] == 0)
				{
					redirect(base_url().'_404_page.html','refresh');
				}
				else
				{
					$data['result_count']  = $getRec[1]['count'];
					$data['result_update']  = $getRec[2]['Query_result'];
					$data['content']  = 'Coupons/coupons_action';
					$this->load->view('Template/template',$data);
				}	
			}
			else
			{
				$data['content']  = 'Coupons/coupons_action';
				$this->load->view('Template/template',$data);
			}	
		}
		//coupons_details
		public function coupons_details()
		{
			$id = $this->uri->segment(3);
			if(!empty($id))
			{
				$where_sys = array(
				'id' => $id,
				);
				$getRec = $this->Mdl_coupons->check_already_exists_multiple('dj_offers','*',$where_sys,4);
				//print_r($getRec);
				if(empty($id) || $getRec[1]['count'] == 0)
				{
					redirect(base_url().'_404_page.html','refresh');
				}
				else
				{
					$data['result_count']  = $getRec[1]['count'];
					$data['result_update']  = $getRec[2]['Query_result'];
					$data['content']  = 'Coupons/coupons_details';
					$this->load->view('Template/template',$data);
				}	
			}
			else
			{
				$data['content']  = 'Coupons/coupons_details';
				$this->load->view('Template/template',$data);
			}	
		}
		//coupons_submit
		public function coupons_submit()
		{
			$post   	= $this->input->post();
			/*  echo "<pre>";
				print_r($post);
			exit;  */
			//Update
			if(!empty($post['id']))
			{
				$net_id = $this->Mdl_coupons->get_relation_pax('dj_brands','network_id','store_id',@$post['store_id']);
				$this->db->trans_start();
				$updateData = array
				(
			    'coupon_id' => $post['coupon_id'],
				'store_id' => $post['store_id'],
				'coupon_title' => $post['coupon_title'],
				'coupon_sub_title' => $post['coupon_sub_title'],
				'coupon_desc' => $post['coupon_desc'],
				'coupon_code' => $post['coupon_code'],
				'coupon_offer' => $post['coupon_offer'],
				'coupon_type' => $post['coupon_type'],
				'comment' => $post['comment'],
				'coupon_expiry' => $post['coupon_expiry'],
				'coupon_deep_link' => $post['coupon_deep_link'],
				'coupon_priority' => $post['coupon_priority'],
				'network_id' => $net_id,
				'is_active' => $post['status'],
				);
				// Update data
				$condition_update = array('id' => $post['id']);
				$update = $this->Mdl_coupons->update($updateData, $condition_update,'dj_offers');
				$this->db->trans_complete();
				if(@$update)
				{
					$this->session->set_flashdata('saved', "Success: Record has been updated...!");
				}
				else
				{
					$this->session->set_flashdata('error', " Record has not been updated...!");
				}
				redirect(base_url().'Coupons/coupons_list','refresh');		
			}
			else
			{
				$net_id = $this->Mdl_coupons->get_relation_pax('dj_brands','network_id','store_id',@$post['store_id']);
				$this->db->trans_start();
				$insData = array
				(
			    'coupon_id' => $post['coupon_id'],
				'store_id' => $post['store_id'],
				'coupon_title' => $post['coupon_title'],
				'coupon_sub_title' => $post['coupon_sub_title'],
				'coupon_desc' => $post['coupon_desc'],
				'coupon_code' => $post['coupon_code'],
				'coupon_offer' => $post['coupon_offer'],
				'coupon_type' => $post['coupon_type'],
				'comment' => $post['comment'],
				'coupon_expiry' => $post['coupon_expiry'],
				'coupon_deep_link' => $post['coupon_deep_link'],
				'coupon_priority' => $post['coupon_priority'],
				'network_id' => $net_id,
				'is_active' => $post['status'],
				);
				$insert = $this->Mdl_coupons->insert($insData, 'dj_offers');
				$this->db->trans_complete();
				if(@$insert)
				{
					$this->session->set_flashdata('saved', "Success: Record has been inserted...!");
				}
				else
				{
					$this->session->set_flashdata('error', " Record has not been inserted...!");
				}
				redirect(base_url().'Coupons/coupons_list','refresh');		
			}
		}
		//Change change_status_coupon
		public function change_status_coupon()
		{
			$post =  $this->input->post();
			$id = $post['couponid'];
			$status = $post['couponstatus'];
			if($status == "1")
			{
				$final_status = "0";
			}
			else
			{
				$final_status = "1";
			}
			$this->db->trans_start();
			$updateData = array
			(
			'is_active' => $final_status,				
			);
			// Update data
			$condition_update = array('id' => $id);
			$update = $this->Mdl_coupons->update($updateData, $condition_update,'dj_offers');
			$this->db->trans_complete();
			if(@$update)
			{
				$cmd_return = 1;
				//$this->session->set_flashdata('saved', "Success: Record has been updated...!");
			}
			else
			{
				$cmd_return = 0;
				//$this->session->set_flashdata('error', " Record has not been updated...!");
			}
			$_return['_return'] =  $cmd_return;
			$return = json_encode($_return);
			echo $return;
		}
		//Change change_status_coupons_bulk
		public function change_status_coupons_bulk()
		{
			$post =  $this->input->post();
			$mycolumn = $post['mycolumn'];
			$change_status = $post['change_status'];
			//$slug = $post['slug'];
			if($change_status == "enable")
			{
				$final_status = "1";
			}
			else if($change_status == "disable")
			{
				$final_status = "0";
			}
			$my_slug = array();
			$this->db->trans_start();
			$exp = explode(",",$mycolumn);
			foreach($exp as $ee)  
			{
				$change_status = $final_status;
				$updateData = array
				(
				'is_active' => $change_status,				
				);
				// Update data
				$condition_update = array('id' => $ee);
				$update = $this->Mdl_coupons->update($updateData, $condition_update,'dj_offers');
				$update = true;
			}
			$this->db->trans_complete();
			//$final_slug = $slug;
			if(@$update == true)
			{
				/* $system_name = 'DiscountsJockey';
					$from_email = "";
					$to_email = 'iamwajahatbaig@gmail.com';		
					$htmlmessage = '<p><b style="color: #777777;">Dear Admin</b>,<br/>Stores Slug = '.$final_slug.'<br/>Status Change = '.$change_status.'<br/>User Name = '.ucwords($this->session->userdata('name')).'<br/>DateTime = '.date('d-m-Y h:i:s').'<br/>Thanks</p>';
					//Admin Email
					$config['charset'] = 'utf-8';
					$config['wordwrap'] = TRUE;
					$config['mailtype'] = 'html';
					$this->email->initialize($config);
					$this->email->from($from_email, $system_name);
					$this->email->to($to_email);
					$this->email->subject('Stores Status Change '.$system_name);
					$this->email->message($htmlmessage);
				$send_email = $this->email->send(); */
				/* if($send_email)
					{
					$this->session->set_flashdata('saved', "Success: Record has been updated & email Send...!");
					}
					else
					{
					$this->session->set_flashdata('saved', "Success: Record has been updated & email not send...!");
				} */
				$cmd_return = 1;
				//$this->session->set_flashdata('saved', "Success: Record has been updated...!");
			}
			else
			{
				$cmd_return = 0;
				//$this->session->set_flashdata('error', " Record has not been updated...!");
			}
			$_return['_return'] =  $cmd_return;
			$return = json_encode($_return);
			echo $return;
		}
		//Change Status
		public function change_status()
		{
			$id = $this->uri->segment(3);
			$status = $this->uri->segment(4);
		    if($status == "1")
			{
				$final_status = "0";
			}
			else
			{
				$final_status = "1";
			}
			$this->db->trans_start();
			$updateData = array
			(
			'is_active' => $final_status,				
			);
			// Update data
			$condition_update = array('id' => $id);
			$update = $this->Mdl_coupons->update($updateData, $condition_update,'dj_offers');
			$this->db->trans_complete();
			if(@$update)
			{
				$this->session->set_flashdata('saved', "Success: Record has been updated...!");
			}
			else
			{
				$this->session->set_flashdata('error', " Record has not been updated...!");
			}
			redirect(base_url().'Coupons/coupons_list','refresh');
		}
		//COupons Search Submit
		public function coupons_search_submit()
		{
			$post = $this->input->post();
			/* echo "<pre>";
				print_r($post);
			exit; */
			if(isset($post['update_status']))
			{
				if($post['change_status'] != "select")
				{
					if($post['change_status'] == "enable")
					{
						$final_status = "1";
					}
					else if($post['change_status'] == "disable")
					{
						$final_status = "0";
					}
					$this->db->trans_start();
					for ($i=0; $i < count($post['mystatus']); $i++)  
					{
						$change_status = $final_status;
						$id = $post['mystatus'][$i];  
						$updateData = array
						(
						'is_active' => $change_status,				
						);
						// Update data
						$condition_update = array('id' => $id);
						$update = $this->Mdl_coupons->update($updateData, $condition_update,'dj_offers');
					}
					$this->db->trans_complete();
					if(@$update)
					{
						$this->session->set_flashdata('saved', "Success: Record has been updated...!");
					}
					else
					{
						$this->session->set_flashdata('error', " Record has not been updated...!");
					}
					redirect(base_url().'Coupons/coupons_list','refresh');
				}
				else
				{
					$this->session->set_flashdata('error', " Please select status...!");
					redirect(base_url().'Coupons/coupons_list','refresh');
				}
			}
			else if(isset($post['export_coupons']))
			{
				/* echo "<pre>";
					print_r($post);
				exit; */
				if(!isset($post['mystatus']))
				{
					if(!empty($post['filter_status']))
					{
						$filter_status = $post['filter_status'];
					}
					else
					{
						$filter_status = "status_all";
					}
					$result_set = $this->Mdl_coupons->getCouponsExport('',$post['mysearch'],$post['mycolumn'],$filter_status);
					if(@$result_set > 0)
					{
						$this->load->library('PHPExcel');
						$object = new PHPExcel();
						$object->setActiveSheetIndex(0);
						$table_columns = array("Coupon Id","Store Id","Store Name","Network Id","Network Name","Coupon Title","Coupon Sub Title","Coupon Desc","Coupon Code","Coupon Offer","Comment","Coupon Expiry","Coupon Type","Coupon Deep Link","Coupon Priority","Status","Created Date","Created By","Modify Date","Modify By");
						$object->getActiveSheet()->setTitle('Coupons List');
						$column = 0;
						foreach($table_columns as $field)
						{
							$object->getActiveSheet()->setCellValueByColumnAndRow($column, 1, $field);
							$column++;
						}
						for ($col = ord('A'); $col <= ord('Z'); $col++) 
						{
							//set column dimension
							$object->getActiveSheet()->getColumnDimension(chr($col))->setAutoSize(true);
							$object->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('H1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('I1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('J1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('K1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('L1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('M1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('N1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('O1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('P1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('Q1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('R1')->getFont()->setBold(true);
							//change the font size
							$object->getActiveSheet()->getStyle(chr($col))->getFont()->setSize(12);
						}
						$excel_row = 2;
						$i = 1;
						foreach($result_set as $row)
						{
							//echo $row->store_id;
							$store_name = $this->Mdl_coupons->get_relation_pax('dj_brands','store_name','store_id',$row->store_id);
							if(!empty($store_name))
							{
								$mstore = $store_name;
							}
							else
							{
								$mstore	= "";
							}
							//Network Name
							$net_name = $this->Mdl_coupons->get_relation_pax('dj_networks','network_name','network_id',$row->network_id);
							if(!empty($net_name))
							{
								$net_name1 = $net_name;
							}
							else
							{
								$net_name1	= "";
							}
							//CREATED DATE & BY //MODIFY DATE & BY
							$final_created_date = "";
							$final_created_by = "";
							$final_modified_date = "";
							$final_modified_by = "";
							if(!empty($row->created_date))
							{
								$date_1 = new DateTime($row->created_date);
								$final_created_date = $date_1->format('d-m-Y H:i:s');
							}
							if(!empty($row->modify_date))
							{
								$date_2 = new DateTime($row->modify_date);
								$final_modified_date = $date_2->format('d-m-Y H:i:s');
							}
							if(!empty($row->created_by))
							{
								$final_created_by = $this->Mdl_coupons->get_relation_pax('login','username','id',$row->created_by);
							}
							if(!empty($row->modify_by))
							{
								$final_modified_by = $this->Mdl_coupons->get_relation_pax('login','username','id',$row->modify_by);
							}	
							$object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $row->coupon_id);
							$object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $row->store_id);
							$object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $mstore);
							$object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $row->network_id);
							$object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $net_name1);
							$object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $row->coupon_title);
							$object->getActiveSheet()->setCellValueByColumnAndRow(6, $excel_row, $row->coupon_sub_title);
							$object->getActiveSheet()->setCellValueByColumnAndRow(7, $excel_row, $row->coupon_desc);
							$object->getActiveSheet()->setCellValueByColumnAndRow(8, $excel_row, $row->coupon_code);
							$object->getActiveSheet()->setCellValueByColumnAndRow(9, $excel_row, $row->coupon_offer);
							$object->getActiveSheet()->setCellValueByColumnAndRow(10, $excel_row, $row->comment);
							$object->getActiveSheet()->setCellValueByColumnAndRow(11, $excel_row, $row->coupon_expiry);
							$object->getActiveSheet()->setCellValueByColumnAndRow(12, $excel_row, $row->coupon_type);
							$object->getActiveSheet()->setCellValueByColumnAndRow(13, $excel_row, $row->coupon_deep_link);
							$object->getActiveSheet()->setCellValueByColumnAndRow(14, $excel_row, $row->coupon_priority);
							$object->getActiveSheet()->setCellValueByColumnAndRow(15, $excel_row, $row->is_active);
							$object->getActiveSheet()->setCellValueByColumnAndRow(16, $excel_row, $final_created_date);
							$object->getActiveSheet()->setCellValueByColumnAndRow(17, $excel_row, $final_created_by);
							$object->getActiveSheet()->setCellValueByColumnAndRow(18, $excel_row, $final_modified_date);
							$object->getActiveSheet()->setCellValueByColumnAndRow(19, $excel_row, $final_modified_by);
							$excel_row++;
							$i++; 
						}
						$object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel2007');
						header('Content-Type: application/vnd.ms-excel');
						header('Content-Disposition: attachment;filename="Coupons.xlsx"');
						$object_writer->save('php://output');
					}
					else
					{
						$this->session->set_flashdata('error', " Excel file not export...!");
						redirect(base_url().'Coupons/coupons_list','refresh');
					}
				}
				else
				{
					$final_coupons_id = "";
					for ($i=0; $i < count($post['mystatus']); $i++)  
					{
						$final_coupons_id .= $post['mystatus'][$i].",";
					}
					$result_set = $this->Mdl_coupons->getCouponsExport($post['mystatus']);
					if(@$result_set > 0)
					{
						$this->load->library('PHPExcel');
						$object = new PHPExcel();
						$object->setActiveSheetIndex(0);
						$table_columns = array("Coupon Id","Store Id","Store Name","Network Id","Network Name","Coupon Title","Coupon Sub Title","Coupon Desc","Coupon Code","Coupon Offer","Comment","Coupon Expiry","Coupon Type","Coupon Deep Link","Coupon Priority","Status","Created Date","Created By","Modify Date","Modify By");
						$object->getActiveSheet()->setTitle('Coupons List');
						$column = 0;
						foreach($table_columns as $field)
						{
							$object->getActiveSheet()->setCellValueByColumnAndRow($column, 1, $field);
							$column++;
						}
						for ($col = ord('A'); $col <= ord('Z'); $col++) 
						{
							//set column dimension
							$object->getActiveSheet()->getColumnDimension(chr($col))->setAutoSize(true);
							$object->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('H1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('I1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('J1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('K1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('L1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('M1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('N1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('O1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('P1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('Q1')->getFont()->setBold(true);
							$object->getActiveSheet()->getStyle('R1')->getFont()->setBold(true);
							//change the font size
							$object->getActiveSheet()->getStyle(chr($col))->getFont()->setSize(12);
						}
						$excel_row = 2;
						$i = 1;
						foreach($result_set as $row)
						{
							//echo $row->store_id;
							$store_name = $this->Mdl_coupons->get_relation_pax('dj_brands','store_name','store_id',$row->store_id);
							if(!empty($store_name))
							{
								$mstore = $store_name;
							}
							else
							{
								$mstore	= "";
							}
							$net_name = $this->Mdl_coupons->get_relation_pax('dj_networks','network_name','network_id',$row->network_id);
							if(!empty($net_name))
							{
								$net_name1 = $net_name;
							}
							else
							{
								$net_name1	= "";
							}
							//CREATED DATE & BY //MODIFY DATE & BY
							$final_created_date = "";
							$final_created_by = "";
							$final_modified_date = "";
							$final_modified_by = "";
							if(!empty($row->created_date))
							{
								$date_1 = new DateTime($row->created_date);
								$final_created_date = $date_1->format('d-m-Y H:i:s');
							}
							if(!empty($row->modify_date))
							{
								$date_2 = new DateTime($row->modify_date);
								$final_modified_date = $date_2->format('d-m-Y H:i:s');
							}
							if(!empty($row->created_by))
							{
								$final_created_by = $this->Mdl_coupons->get_relation_pax('login','username','id',$row->created_by);
							}
							if(!empty($row->modify_by))
							{
								$final_modified_by = $this->Mdl_coupons->get_relation_pax('login','username','id',$row->modify_by);
							}	
							$object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $row->coupon_id);
							$object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $row->store_id);
							$object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $mstore);
							$object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $row->network_id);
							$object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $net_name1);
							$object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $row->coupon_title);
							$object->getActiveSheet()->setCellValueByColumnAndRow(6, $excel_row, $row->coupon_sub_title);
							$object->getActiveSheet()->setCellValueByColumnAndRow(7, $excel_row, $row->coupon_desc);
							$object->getActiveSheet()->setCellValueByColumnAndRow(8, $excel_row, $row->coupon_code);
							$object->getActiveSheet()->setCellValueByColumnAndRow(9, $excel_row, $row->coupon_offer);
							$object->getActiveSheet()->setCellValueByColumnAndRow(10, $excel_row, $row->comment);
							$object->getActiveSheet()->setCellValueByColumnAndRow(11, $excel_row, $row->coupon_expiry);
							$object->getActiveSheet()->setCellValueByColumnAndRow(12, $excel_row, $row->coupon_type);
							$object->getActiveSheet()->setCellValueByColumnAndRow(13, $excel_row, $row->coupon_deep_link);
							$object->getActiveSheet()->setCellValueByColumnAndRow(14, $excel_row, $row->coupon_priority);
							$object->getActiveSheet()->setCellValueByColumnAndRow(15, $excel_row, $row->is_active);
							$object->getActiveSheet()->setCellValueByColumnAndRow(16, $excel_row, $final_created_date);
							$object->getActiveSheet()->setCellValueByColumnAndRow(17, $excel_row, $final_created_by);
							$object->getActiveSheet()->setCellValueByColumnAndRow(18, $excel_row, $final_modified_date);
							$object->getActiveSheet()->setCellValueByColumnAndRow(19, $excel_row, $final_modified_by);
							$excel_row++;
							$i++; 
						}
						$object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel2007');
						header('Content-Type: application/vnd.ms-excel');
						header('Content-Disposition: attachment;filename="Coupons.xlsx"');
						$object_writer->save('php://output');
					}
					else
					{
						$this->session->set_flashdata('error', " Excel file not export...!");
						redirect(base_url().'Coupons/coupons_list','refresh');
					}				
				}
				//exit;
			}
			else
			{
				redirect(base_url().'_404_page.html','refresh');
			}
		}
	}			