<section class="content-header">
	<h1>
        Stores
        <small>Duplicate Stores List</small>
	</h1>
	<ol class="breadcrumb">
        <li><a href="<?php echo base_url('Dashboard'); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="">Stores</li>
        <li class="active">Duplicate Stores List</li>
	</ol>
</section>
<!-- Main content -->
<section class="content">
	<div class="row">
		<div class="col-xs-12">
			<?php
				if($this->session->flashdata())
				{
					foreach($this->session->flashdata() as $key => $value):
					if($key == 'update' || $key == 'saved')
					{
						$alert_class = 'alert-success';
					}else
					{
						$alert_class = 'alert-danger';
					}
				?>
				<div class="alert alert-block <?php echo $alert_class; ?>">
					<button type="button" class="close" data-dismiss="alert">
						<i class="icon-remove"></i>
					</button>
					<p>
						<strong>
							<i class="icon-ok"></i>
							<?php echo ucwords(strtolower($key)); ?> !
						</strong>
						<?php echo $value; ?>
					</p>
				</div>
				<?php
					endforeach;
				}  ?>
				<!--<a href="#" class="btn bigger-50 ws-btn-font  btn-success">Add New </a>-->
				<div class="row">
					<!-- left column -->
					<div class="col-md-6">
						<!-- general form elements -->
						<div class="box box-primary">
							<div class="box-header with-border">
								<h3 class="box-title">Filter Duplicate Stores <i class="loading1 fa fa-spinner fa-spin orange bigger-125 hide"></i></h3> 
							</div>
							<!-- /.box-header -->
							<!-- form start -->
							<div class="box-body">
								<div class="form-group">
									<label for="exampleInputEmail1">Search By</label>
									<input type="text" class="form-control" id="search_all" placeholder="Search By" name="search_all"/>
								</div>
							</div>
							<!-- /.box-body -->
							<div class="box-footer">
								<button type="button" name="search_dstores" id="search_dstores" class="btn btn-primary pull-right">Search</button>
							</div>
						</div>
						<!-- /.box -->
					</div>
				</div>
				<div class="box" id="ajax_search_dstores">
					<div class="box-header">
						<h3 class="box-title">Results for Duplicate Stores List</h3>
					</div>
					<!-- /.box-header -->
					<div class="box-body">
						<table class="table table-bordered table-striped">
							<thead>
								<tr>
									<th>Store Id</th>
									<th>Merchant Id</th>
									<th>Network Id</th>
									<th>Store Name</th>
									<th>Slug</th>
									<th>Created Date</th>
									<th>Created By</th>
									<!--<th>Tracking Url</th>-->                              
									<th>Status</th>
									<th>Detail</th>
								</tr>
							</thead>
							<tbody>
								<?php
									if(!empty($result_set))
									{
										foreach(@$result_set as $row)
										{
										?>
										<tr>
											<td><?php echo $row->store_id; ?></td>
											<td><?php echo $row->merchant_id; ?></td>
											<td><?php echo $row->network_id; ?></td>
											<td><a href="../../<?php echo "store/".$row->slug; ?>" target="_blank"><?php
												$store_name = $this->Mdl_stores->get_relation_pax('dj_brands','store_name','store_id',$row->store_id);
												echo $store_name;
											?></a></td>
											<td><?php echo $row->slug; ?></td>
											<td><?php
												if(!empty($row->created_date))
												{
													$date_1 = new DateTime($row->created_date);
													$date_F1 = $date_1->format('d-m-Y H:i:s');
													echo $date_F1;
												}
											?></td>
											<td><?php 
												$us_name = $this->Mdl_stores->get_relation_pax('login','username','id',@$row->created_by);
												echo $us_name;
											?></td>
											<td>
												<?php
													if($row->is_active == 'enable')
													{
													?>
													<button type="button" class="btn btn-block btn-success btn-xs">Enable</button>
													<?php
														}else{
													?>
													<button type="button" class="btn btn-block btn-danger btn-xs">Disable</button>
													<?php
													}
												?>
											</td>
											<td> <a class="green" title="Details" href="<?php echo base_url('Stores/stores_details/'.$row->store_id.'/duplicate'); ?>">
												<i class="fa fa-eye bigger-130"></i>
											</a></td>
										</tr>
										<?php
										}
									}
								?>
							</tbody>
						</table>
						<div class="col-xs-12 text-center">
							<?php echo $this->ajax_pagination->create_links(); ?> <i class="loading fa fa-spinner fa-spin orange bigger-125 hide"></i>
						</div>
					</div>
					<!-- /.box-body -->
				</div>
				<!-- /.box -->
		</div>
	</div>
	<!-- /.row -->
</section>
<script type="text/javascript">
	function searchFilterDStores(page_num) 
	{
		page_num = page_num?page_num:0;
		var search_all = $('#search_all').val();
		$.ajax({
			type: 'POST',
			url: '<?php echo base_url(); ?>Stores/ajax_dstores_list/'+page_num,
			data:'page='+page_num+'&search_all='+search_all,
			beforeSend: function () {
				$('.loading').removeClass('hide');
			},
			success: function (html) {
				$('#ajax_search_dstores').html(html);
				$('.loading').addClass("hide");
			}
		});
	}
</script>