<?php
	defined('BASEPATH') OR exit('No direct script access allowed');
	class Mdl_stores extends CI_Model {
		function __construct()
		{
			parent::__construct();
			//Modules::run('Login/_login');
			//$this->load->module('Hierarchy');
		}
		//check relation reference
		public function get_relation_pax($table,$column,$reference,$input)
		{
			$this->db->select($column);
			$this->db->where($reference,$input);
			$result =  $this->db->get($table)->result();
			if(empty($result))
			{
				return 0;
			}
			else
			{
				return $result[0]->$column;
			}
		}
		//Get Multiple Record
		public function check_already_exists_multiple($table,$get_column,$wheres,$type)
		{
			$this->db->select($get_column);
			foreach($wheres as $key_wh => $wh):
            $this->db->where($key_wh,$wh);
            endforeach;
			$query =  $this->db->get($table);
			if($type == 1)
			{
				$count  = $query->num_rows();
				$return = $count;
			}
			if($type == 2)
			{
				$Q_result  = $query->result();
				$return = $Q_result;
			}
			if($type == 3)
			{
				$Q_result_array  = $query->result_array();
				$return = $Q_result_array;
			}
			if($type == 4)
			{
				$count  = $query->num_rows();
				$return = $count;
				$Q_result  = $query->result();
				$return = $Q_result;
				$Q_result_array  = $query->result_array();
				$return = $Q_result_array;
				$return = array();
				$return['1']['count'] = $count;
				$return['2']['Query_result'] = $Q_result;
				$return['3']['Query_result_array'] = $Q_result_array;
			}
			return $return;
		}
		/*
			* Insert data into the database
			* @param $data data to be insert based on the passed parameters
		*/
		public function insert($data = array(),$table) 
		{
			if(!empty($data))
			{
				$data['created_date'] = date('Y-m-d H:i:s');
				$data['created_by'] = $this->session->userdata('id');
				// Insert data
				$insert = $this->db->insert($table, $data);
				// Return the status
				return $insert?$this->db->insert_id():false;
			}
			return false;
		}
		/*
			* Update data into the database
			* @param $data array to be update based on the passed parameters
			* @param $condition array filter data
		*/
		public function update($data, $condition = array(),$table) {
			if(!empty($data)){
				$data['modify_date'] = date('Y-m-d H:i:s');
				$data['modify_by'] = $this->session->userdata('id');
				// Update data
				$update = $this->db->update($table, $data, $condition);
				// Return the status
				return $update?true:false;
			}
			return false;
		}
		//_get_single_record_byid Check Unique Value
		public function _get_single_record_byid($col,$value,$id,$table)
		{  
			$this->db->select('*'); 
			$this->db->where($col ,$value);       
			$query =  $this->db->get($table);
			$row   = $query->num_rows();  
			if($id != null)
			{
				$result = $query->result();
				if($row > 0)
				{
					if($result[0]->id == $id)
					{
						return 0;
					}else
					{
						return 1; 
					} 
				}else
				{
					return $row;
				}   
			}else
			{
				return  $row; 
			}
		}
		//_get_single_record_bycatslug Check Unique Value
		public function _get_single_record_bycatslug($col,$value,$id,$table)
		{  
			$this->db->select('*'); 
			$this->db->where($col ,$value);       
			$query =  $this->db->get($table);
			$row   = $query->num_rows();  
			if($id != null)
			{
				$result = $query->result();
				if($row > 0)
				{
					if($result[0]->cate_id == $id)
					{
						return 0;
					}else
					{
						return 1; 
					} 
				}else
				{
					return $row;
				}   
			}else
			{
				return  $row; 
			}
		}
		//_get_single_record_bystoreslug Check Unique Value
		public function _get_single_record_bystoreslug($col,$value,$id,$table)
		{  
			$this->db->select('*'); 
			$this->db->where($col ,$value);       
			$query =  $this->db->get($table);
			$row   = $query->num_rows();  
			if($id != null)
			{
				$result = $query->result();
				if($row > 0)
				{
					if($result[0]->store_id == $id)
					{
						return 0;
					}else
					{
						return 1; 
					} 
				}else
				{
					return $row;
				}   
			}else
			{
				return  $row; 
			}
		}
		//PArent Category Dropdown
		public function parent_category_dd($id = null)
		{
			$this->db->select('*');
			if($id != null)
			{
				$this->db->where('cate_id',$id);
			}
			$this->db->where('parent_cate_id',0);
			$this->db->where('is_active',"1");
			$result =  $this->db->get('dj_categories')->result();
			$array = array(
			'' => 'Select Parent Category'
			);
			if(count($result)){
				foreach($result as $res){
					$array[$res->cate_id] = $res->category;
				}
			}
			return $array;
		}
		//All Category Dropdown
		public function all_category_dd($id = null)
		{
			$this->db->select('*');
			if($id != null)
			{
				$this->db->where('cate_id',$id);
			}
			$this->db->where('parent_cate_id',0);
			$this->db->where('is_active',"1");
			$result =  $this->db->get('dj_categories')->result();
			$array = array(
			'' => 'Select Category'
			);
			if(count($result)){
				foreach($result as $res){
					$array[$res->cate_id] = $res->category;
				}
			}
			return $array;
		}
		//All Network Dropdown
		public function network_dd($id = null)
		{
			$this->db->select('*');
			if($id != null)
			{
				$this->db->where('network_id',$id);
			}
			// $this->db->where('parent_cate_id',0);
			$this->db->where('is_active',"enable");
			$result =  $this->db->get('dj_networks')->result();
			$array = array(
			'' => 'Select Network'
			);
			if(count($result)){
				foreach($result as $res){
					$array[$res->network_id] = $res->network_name;
				}
			}
			return $array;
		}
		//All Stores Data With Searching
		function getRowsStores($params = array())
		{
			$all = "";
			if(!empty($params['search']['mycolumn']))
			{
				$exp = explode(',',$params['search']['mycolumn']);
				$count = count($exp);
				$search_all = array_search('all', $exp, true);
				if($search_all)
				{
					$all = "yes";
				}
			}
			//print_r($params);
			$this->db->select('dj_categories.*,dj_brands.*,dj_brands.is_active as stores_status');
			$this->db->from('dj_brands');			
			if(!empty($params['search']['search_all']) && empty($params['search']['mycolumn']) || $all == 'yes')
			{
				$this->db->group_start();
				$this->db->like('dj_brands.store_name',$params['search']['search_all']);
				$this->db->or_where('dj_brands.store_id',$params['search']['search_all']);
				$this->db->or_where('dj_brands.merchant_id',$params['search']['search_all']);
				$this->db->or_where('dj_brands.network_id',$params['search']['search_all']);
				$this->db->or_where('dj_brands.parent_cate_id',$params['search']['search_all']);
				$this->db->or_like('dj_brands.slug',$params['search']['search_all']);
				$this->db->or_like('dj_brands.store_logo',$params['search']['search_all']);
				$this->db->or_like('dj_brands.store_display_url',$params['search']['search_all']);
				$this->db->or_like('dj_brands.store_summary',$params['search']['search_all']);
				$this->db->or_like('dj_brands.store_desc',$params['search']['search_all']);
				$this->db->or_like('dj_brands.tracking_url',$params['search']['search_all']);
				$this->db->or_like('dj_brands.comment',$params['search']['search_all']);
				$this->db->or_like('dj_brands.address',$params['search']['search_all']);
				$this->db->or_like('dj_brands.phone',$params['search']['search_all']);
				$this->db->or_like('dj_brands.email',$params['search']['search_all']);
				$this->db->or_like('dj_brands.fb_url',$params['search']['search_all']);
				$this->db->or_like('dj_brands.twitter_url',$params['search']['search_all']);
				$this->db->or_like('dj_brands.youtube',$params['search']['search_all']);
				$this->db->or_like('dj_brands.gplus',$params['search']['search_all']);
				$this->db->or_like('dj_brands.is_featured',$params['search']['search_all']);
				$this->db->or_like('dj_brands.store_priority',$params['search']['search_all']);
				$this->db->or_like('dj_brands.is_active',$params['search']['search_all']);
				$this->db->or_like('dj_categories.category',$params['search']['search_all']);
				//$this->db->or_like('dj_brands.is_api',$params['search']['search_all']);
				$this->db->group_end();
			}
			else
			{
				if(!empty($params['search']['mycolumn']))
				{
					if($count == 1)
					{
						if($params['search']['mycolumn'] == "dj_brands.store_id" || $params['search']['mycolumn'] == "dj_brands.merchant_id" || $params['search']['mycolumn'] == "dj_brands.network_id" || $params['search']['mycolumn'] == "dj_brands.store_id" || $params['search']['mycolumn'] == "dj_brands.parent_cate_id")
						{
							$this->db->where($params['search']['mycolumn'],$params['search']['search_all']);
						}
						else
						{
							if($params['search']['mycolumn'] == "dj_brands.is_api")
							{
								if(strtolower($params['search']['search_all']) == "yes")
								{
									$this->db->where('dj_brands.is_api','1');
								} 
								else if(strtolower($params['search']['search_all']) == "no")
								{
									$this->db->where('dj_brands.is_api','0');
								}
							}
							else
							{
								$this->db->like($params['search']['mycolumn'],$params['search']['search_all']);
							}
						}
					}
					else
					{
						foreach($exp as $key_wh => $wh):
						if($wh == "dj_brands.is_api")
						{
							if(strtolower($params['search']['search_all']) == "yes")
							{
								$this->db->where('dj_brands.is_api','1');
							} 
							else if(strtolower($params['search']['search_all']) == "no")
							{
								$this->db->where('dj_brands.is_api','0');
							}
						}
						else
						{
							$this->db->or_like($wh,$params['search']['search_all']);
						}
						endforeach;						
					}
				}
			}
			if(!empty($params['search']['filter_status']))
			{
				if($params['search']['filter_status'] == "status_enable")
				{
					$this->db->where('dj_brands.is_active','enable');
				}
				else if($params['search']['filter_status'] == "status_disable")
				{
					$this->db->where('dj_brands.is_active','disable');
				}
			}
			$this->db->order_by('dj_brands.store_id','desc');
			//set start and limit
			if(array_key_exists("start",$params) && array_key_exists("limit",$params)){
				$this->db->limit($params['limit'],$params['start']);
				}elseif(!array_key_exists("start",$params) && array_key_exists("limit",$params)){
				$this->db->limit($params['limit']);
			}
			$this->db->join('dj_categories','dj_categories.cate_id = dj_brands.parent_cate_id');
			$query = $this->db->get();
			//echo $this->db->last_query();
			//return fetched data
			if($query->num_rows() > 0)
			{
				return $query->result();
			} 
			else
			{
				return 0;
			}
		}
		//All Duplicate Stores Data With Searching
		function getRowsDStores($params = array())
		{
			$this->db->select('*');
			$this->db->from('store_history_list');
			$this->db->where('store_type','normal');
			if(!empty($params['search']['search_all']))
			{
				$this->db->like('slug',$params['search']['search_all']);
				$this->db->or_where('store_id',$params['search']['search_all']);
				$this->db->or_where('merchant_id',$params['search']['search_all']);
				$this->db->or_where('network_id',$params['search']['search_all']);
				$this->db->or_like('tracking_url',$params['search']['search_all']);
			}
			$this->db->order_by('id','desc');
			//set start and limit
			if(array_key_exists("start",$params) && array_key_exists("limit",$params)){
				$this->db->limit($params['limit'],$params['start']);
				}elseif(!array_key_exists("start",$params) && array_key_exists("limit",$params)){
				$this->db->limit($params['limit']);
			}
			$query = $this->db->get();
			//return fetched data
			if($query->num_rows() > 0)
			{
				return $query->result();
			} 
			else
			{
				return 0;
			}
		}
		//get coupons excel conditions in
		public function getStoresExport($store_id = null,$mysearch = null,$mycolumn = null,$filter_status = null)
		{
			//Where Store Ids IN
			if(!empty($store_id))
			{
				$this->db->select('dj_categories.*,dj_brands.*,dj_brands.is_active as stores_status');
				$this->db->from('dj_brands');
				$this->db->where_in('dj_brands.store_id',$store_id);
				$order = sprintf('FIELD(dj_brands.store_id, %s)', implode(', ', $store_id));
				$this->db->order_by($order);				
				$this->db->join('dj_categories','dj_categories.cate_id = dj_brands.parent_cate_id');
				$query = $this->db->get();
				//echo $this->db->last_query();
				//return fetched data
				if($query->num_rows() > 0)
				{
					return $query->result();
				} 
				else
				{
					return 0;
				}
			}
			else
			{
				$all = "";
				if(!empty($mycolumn))
				{
					$exp = explode(',',$mycolumn);
					$count = count($exp);
					$search_all = array_search('all', $exp, true);
					if($search_all)
					{
						$all = "yes";
					}
				}			
				$this->db->select('dj_categories.*,dj_brands.*,dj_brands.is_active as stores_status');
				$this->db->from('dj_brands');			
				if(!empty($mysearch) && empty($mycolumn) || $all == 'yes')
				{
					$this->db->group_start();
					$this->db->like('dj_brands.store_name',$mysearch);
					$this->db->or_where('dj_brands.store_id',$mysearch);
					$this->db->or_where('dj_brands.merchant_id',$mysearch);
					$this->db->or_where('dj_brands.network_id',$mysearch);
					$this->db->or_where('dj_brands.parent_cate_id',$mysearch);
					$this->db->or_like('dj_brands.slug',$mysearch);
					$this->db->or_like('dj_brands.store_logo',$mysearch);
					$this->db->or_like('dj_brands.store_display_url',$mysearch);
					$this->db->or_like('dj_brands.store_summary',$mysearch);
					$this->db->or_like('dj_brands.store_desc',$mysearch);
					$this->db->or_like('dj_brands.tracking_url',$mysearch);
					$this->db->or_like('dj_brands.comment',$mysearch);
					$this->db->or_like('dj_brands.address',$mysearch);
					$this->db->or_like('dj_brands.phone',$mysearch);
					$this->db->or_like('dj_brands.email',$mysearch);
					$this->db->or_like('dj_brands.fb_url',$mysearch);
					$this->db->or_like('dj_brands.twitter_url',$mysearch);
					$this->db->or_like('dj_brands.youtube',$mysearch);
					$this->db->or_like('dj_brands.gplus',$mysearch);
					$this->db->or_like('dj_brands.is_featured',$mysearch);
					$this->db->or_like('dj_brands.store_priority',$mysearch);
					$this->db->or_like('dj_brands.is_active',$mysearch);
					$this->db->or_like('dj_categories.category',$mysearch);
					$this->db->group_end();
				}
				else
				{
					if(!empty($mycolumn))
					{
						if($count == 1)
						{
							if($mycolumn == "dj_brands.store_id" || $mycolumn == "dj_brands.merchant_id" || $mycolumn == "dj_brands.network_id" || $mycolumn == "dj_brands.store_id")
							{
								$this->db->where($mycolumn,$mysearch);
							}
							else
							{
								if($mycolumn == "dj_brands.is_api")
								{
									if(strtolower($mysearch) == "yes")
									{
										$this->db->where('dj_brands.is_api','1');
									} 
									else if(strtolower($mysearch) == "no")
									{
										$this->db->where('dj_brands.is_api','0');
									}
								}
								else
								{
									$this->db->like($mycolumn,$mysearch);
								}
							}
						}
						else
						{
							foreach($exp as $key_wh => $wh):
							if($wh == "dj_brands.is_api")
							{
								if(strtolower($mysearch) == "yes")
								{
									$this->db->where('dj_brands.is_api','1');
								} 
								else if(strtolower($mysearch) == "no")
								{
									$this->db->where('dj_brands.is_api','0');
								}
							}
							else
							{
								$this->db->or_like($wh,$mysearch);
							}
							//$this->db->or_like($wh,$mysearch);
							endforeach;						
						}
					}
				}
				if(!empty($filter_status))
				{
					if($filter_status == "status_enable")
					{
						$this->db->where('dj_brands.is_active','enable');
					}
					else if($filter_status == "status_disable")
					{
						$this->db->where('dj_brands.is_active','disable');
					}
				}
				$this->db->order_by('dj_brands.store_id','desc');
				$this->db->join('dj_categories','dj_categories.cate_id = dj_brands.parent_cate_id');
				$query = $this->db->get();
				//echo $this->db->last_query();
				//return fetched data
				if($query->num_rows() > 0)
				{
					return $query->result();
				} 
				else
				{
					return 0;
				}				
			}			
		}		
		//Get Total Coupons By Store Ids
		public function get_total_coupons_list($store_id)
		{
			$query = $this->db->query("SELECT slug,SUM(gc.is_views) as total_views,COUNT(gs.slug) total_counts,SUM(IF(date(gc.coupon_expiry) < CURDATE(),1,0)) as inactive,SUM(IF(date(gc.coupon_expiry) > CURDATE(),1,0)) as active FROM dj_brands gs LEFT JOIN dj_offers gc ON gs.store_id = gc.store_id WHERE gs.store_id = '".$store_id."' GROUP by gs.slug");		
			//echo $this->db->last_query();
			//exit;
			$result =  $query->result();
			return $result;
		}
		//Get Last Date Coupons By Store Ids
		public function get_last_date_coupons_list($store_id)
		{
			$query = $this->db->query("SELECT gc.created as coupon_created,gc.modify_date as coupon_modified FROM dj_offers gc WHERE gc.store_id = '".$store_id."' order by gc.created DESC,gc.modify_date DESC");
			//	echo $this->db->last_query();
			//exit;
			$result =  $query->result();
			return $result;
		}
	}
?>