<?php
	defined('BASEPATH') OR exit('No direct script access allowed');
	class Mdl_frontend extends CI_Model {
		function __construct()
		{
			parent::__construct();
		}
	
		function getMovies($limit=null,$offset=NULL){
			$this->db->select("*");
			$this->db->from('dj_brands');
			$this->db->limit($limit, $offset);
			$query = $this->db->get();
			return $query->result();
		}
		function totalMovies(){
			return $this->db->count_all_results('dj_brands');
		}
		//total_categories_stores
		function total_categories_stores($cat_id)
		{
			$this->db->where('is_active' ,'enable');
			$this->db->where('parent_cate_id' ,$cat_id);
			return $this->db->count_all_results('dj_brands');
		}
		//get total_categories_stores
		function get_total_categories_stores($cat_id,$limit=null,$offset=NULL)
		{
			$this->db->select("store_id,store_name,slug,store_logo");
			$this->db->from('dj_brands');
			$this->db->where('is_active' ,'enable');
			$this->db->where('parent_cate_id' ,$cat_id);
			$this->db->limit($limit, $offset);
			$query = $this->db->get();
			//echo $this->db->last_query();
			return $query->result();
		}
		//get_search_stores
		function get_search_stores_wh($search)
		{
			$this->db->select('store_name,slug,store_logo,comment');			
			$this->db->where('is_active','enable');
			$this->db->group_start();
			$this->db->where('dj_brands.store_name',$search);
			$this->db->group_end();
			$this->db->order_by('store_priority','desc');
			$this->db->limit(16);
			$this->db->from('dj_brands');
			$result =  $this->db->get()->result_array();
			return $result;
		}
		//get_search_stores
		function get_search_stores_lk($search)
		{
			$this->db->select('store_name,slug,store_logo,comment');			
			$this->db->where('is_active','enable');
			$this->db->group_start();
			if(!empty($search))
			{
				$final_search = explode(' ',$search);
				if(!empty($final_search))
				{
					foreach($final_search as $key_wh => $wh):
					$this->db->or_like('dj_brands.store_name',$wh);
					endforeach;
				}
			}		
			$this->db->group_end();
			$this->db->order_by('store_priority','desc');
			$this->db->limit(16);
			$this->db->from('dj_brands');
			$result =  $this->db->get()->result_array();
			return $result;
		}
		//total_search_stores_offers
		function total_search_stores_offers($search)
		{
			$query1 = "SELECT `dj_offers`.`coupon_title`, `dj_offers`.`coupon_deep_link`, `dj_offers`.`coupon_type`, `dj_offers`.`coupon_code`, `dj_offers`.`coupon_expiry`, `dj_offers`.`id`, `dj_offers`.`store_id`, `dj_brands`.`store_logo`, `dj_brands`.`store_banner`, `dj_brands`.`store_name`, `dj_brands`.`slug`, `dj_brands`.`tracking_url`, `dj_offers`.`is_views` FROM `dj_offers` RIGHT JOIN `dj_brands` ON `dj_brands`.`store_id` = `dj_offers`.`store_id` WHERE `dj_offers`.`is_active` = '1' AND `dj_brands`.`is_active` = 'enable' AND `dj_offers`.`coupon_expiry` >= '".date('Y-m-d')."' AND ( `dj_offers`.`coupon_title` = '".$search."' OR `dj_offers`.`coupon_title` LIKE '%".$search."%' ESCAPE '!' )";
			$query2 = "SELECT `dj_offers`.`coupon_title`, `dj_offers`.`coupon_deep_link`, `dj_offers`.`coupon_type`, `dj_offers`.`coupon_code`, `dj_offers`.`coupon_expiry`, `dj_offers`.`id`, `dj_offers`.`store_id`, `dj_brands`.`store_logo`, `dj_brands`.`store_banner`, `dj_brands`.`store_name`, `dj_brands`.`slug`, `dj_brands`.`tracking_url`, `dj_offers`.`is_views` FROM `dj_offers` RIGHT JOIN `dj_brands` ON `dj_brands`.`store_id` = `dj_offers`.`store_id` WHERE `dj_offers`.`is_active` = '1' AND `dj_brands`.`is_active` = 'enable' AND `dj_offers`.`coupon_expiry` >= '".date('Y-m-d')."' AND (";
			$final_search = explode(' ',$search);
			if(!empty($final_search))
			{
				$numItems = count($final_search);
				$i = 0;
				foreach($final_search as $key_wh => $wh):
				$query2 .= "dj_offers.coupon_title LIKE '%".$wh."%'";
				if(++$i === $numItems) 
				{
				}
				else
				{
					$query2 .= " OR ";
				}
				endforeach;
			}
			$query2 .= ")";
			$result = $this->db->query('('.$query1 . ') UNION (' . $query2.')')->result(); 
			///echo $this->db->last_query();
			return $result;
		}
		//get total_categories_stores
		function get_total_search_stores_offers($search,$limit=null,$offset=NULL)
		{
			$query1 = "SELECT `dj_offers`.`coupon_title`, `dj_offers`.`coupon_deep_link`, `dj_offers`.`coupon_type`, `dj_offers`.`coupon_code`, `dj_offers`.`coupon_expiry`, `dj_offers`.`id`, `dj_offers`.`store_id`, `dj_brands`.`store_logo`, `dj_brands`.`store_banner`, `dj_brands`.`store_name`, `dj_brands`.`slug`, `dj_brands`.`tracking_url`, `dj_offers`.`is_views` FROM `dj_offers` RIGHT JOIN `dj_brands` ON `dj_brands`.`store_id` = `dj_offers`.`store_id` WHERE `dj_offers`.`is_active` = '1' AND `dj_brands`.`is_active` = 'enable' AND `dj_offers`.`coupon_expiry` >= '".date('Y-m-d')."' AND ( `dj_offers`.`coupon_title` = '".$search."' OR `dj_offers`.`coupon_title` LIKE '%".$search."%' ESCAPE '!' )";
			$query2 = "SELECT `dj_offers`.`coupon_title`, `dj_offers`.`coupon_deep_link`, `dj_offers`.`coupon_type`, `dj_offers`.`coupon_code`, `dj_offers`.`coupon_expiry`, `dj_offers`.`id`, `dj_offers`.`store_id`, `dj_brands`.`store_logo`, `dj_brands`.`store_banner`, `dj_brands`.`store_name`, `dj_brands`.`slug`, `dj_brands`.`tracking_url`, `dj_offers`.`is_views` FROM `dj_offers` RIGHT JOIN `dj_brands` ON `dj_brands`.`store_id` = `dj_offers`.`store_id` WHERE `dj_offers`.`is_active` = '1' AND `dj_brands`.`is_active` = 'enable' AND  `dj_offers`.`coupon_expiry` >= '".date('Y-m-d')."' AND (";
			$final_search = explode(' ',$search);
			if(!empty($final_search))
			{
				$numItems = count($final_search);
				$i = 0;
				foreach($final_search as $key_wh => $wh):
				$query2 .= "dj_offers.coupon_title LIKE '%".$wh."%'";
				if(++$i === $numItems) 
				{
				}
				else
				{
					$query2 .= " OR ";
				}
				endforeach;
			}
			$query2 .= ")";
			$result = $this->db->query('('.$query1 . ') UNION (' . $query2.') LIMIT '.$offset.','.$limit.'')->result(); 
			//echo "<BR><BR><BR>".$this->db->last_query();
			return $result;
		}
		//events keyword search
		function event_search_stores_offers($search)
		{
			//print_r($search);
			$event_keyword_final = implode(" ",$search);
			$query1 = "SELECT `dj_offers`.`coupon_title`, `dj_offers`.`coupon_deep_link`, `dj_offers`.`coupon_type`, `dj_offers`.`coupon_code`, `dj_offers`.`coupon_expiry`, `dj_offers`.`id`, `dj_offers`.`store_id`, `dj_brands`.`store_logo`, `dj_brands`.`store_banner`, `dj_brands`.`store_name`,`dj_brands`.`store_id`, `dj_brands`.`slug`, `dj_brands`.`tracking_url`, `dj_offers`.`is_views` FROM `dj_offers` RIGHT JOIN `dj_brands` ON `dj_brands`.`store_id` = `dj_offers`.`store_id` WHERE `dj_offers`.`is_active` = '1' AND `dj_brands`.`is_active` = 'enable' AND `dj_offers`.`coupon_expiry` >= '".date('Y-m-d')."' AND (";
			if(!empty($search))
			{
				$numItems1 = count($search);
				$i1 = 0;
				foreach($search as $key_wh1 => $wh1):
				$query1 .= "dj_offers.coupon_title = '".$wh1."'";
				if(++$i1 === $numItems1) 
				{
				}
				else
				{
					$query1 .= " OR ";
				} 
				endforeach;
			}
			$query1 .= ")";
			$query2 = "SELECT `dj_offers`.`coupon_title`, `dj_offers`.`coupon_deep_link`, `dj_offers`.`coupon_type`, `dj_offers`.`coupon_code`, `dj_offers`.`coupon_expiry`, `dj_offers`.`id`, `dj_offers`.`store_id`, `dj_brands`.`store_logo`, `dj_brands`.`store_banner`, `dj_brands`.`store_name`,`dj_brands`.`store_id`, `dj_brands`.`slug`, `dj_brands`.`tracking_url`, `dj_offers`.`is_views` FROM `dj_offers` RIGHT JOIN `dj_brands` ON `dj_brands`.`store_id` = `dj_offers`.`store_id` WHERE `dj_offers`.`is_active` = '1' AND `dj_brands`.`is_active` = 'enable' AND `dj_offers`.`coupon_expiry` >= '".date('Y-m-d')."' AND (";
			$final_search = explode(' ',$event_keyword_final);
			if(!empty($final_search))
			{
				$numItems = count($final_search);
				$i = 0;
				foreach($final_search as $key_wh => $wh):
				$query2 .= "dj_offers.coupon_title LIKE '%".$wh."%'";
				if(++$i === $numItems) 
				{
				}
				else
				{
					$query2 .= " OR ";
				}
				endforeach;
			}
			$query2 .= ")";
			$result = $this->db->query('('.$query1 . ') UNION (' . $query2.') LIMIT 100')->result(); 
			//echo $this->db->last_query();
			return $result;
		}
		//Get Admin Email
		public function _get_admin_email()
		{
			$this->db->select('email');
			$this->db->where('user_type' ,1);
			$query =  $this->db->get('login');
			return $query->result();
		}
		//System Setting List
		public function _get_system_setting_list()
		{
			$this->db->select('system_image,system_title');
			$this->db->where('is_enable',1);
			$result = $this->db->get('system_setting_list')->result();
			return $result;
		}
		//Pages List
		public function _get_pages_list($page_name=null)
		{
			$this->db->select('page_name,title,long_description,pages_image');
			if(!empty($page_name))
			{
				$this->db->where('page_name',$page_name);
			}
			$this->db->where('is_enable',1);
			$result = $this->db->get('pages_list')->result();
			//echo $this->db->last_query();
			//exit;
			return $result;
		}
		//Slider List
		public function _get_slider_list()
		{
			$this->db->select('id,slider_name,slider_image1,slider_image2,slider_url');
			$this->db->where('is_enable',1);
			$result = $this->db->get('slider_list')->result();
			//echo $this->db->last_query();exit;
			return $result;
		}
		//Category List
		public function _get_category_list($id=null)
		{
			$this->db->select('*');
			if($id > 0 )
			{
				$this->db->where('id',$id);
			}
			$this->db->where('is_active',1);
			$result = $this->db->get('dj_categories')->result();
			return $result;
		}
		//Single Stores List
		public function _get_single_store_list($id)
		{
			$this->db->select('*');
			$this->db->where('store_id',$id);
			$this->db->where('is_active','enable');
			$result = $this->db->get('dj_brands')->result();
			return $result;
		}
		//Single Category List
		public function _get_single_category_list($id)
		{
			$this->db->select('*');
			$this->db->where('cate_id',$id);
			$this->db->where('is_active','1');
			$result = $this->db->get('dj_categories')->result();
			return $result;
		}
		//Parent Category List
		public function _get_parent_category_list()
		{
			$this->db->select('category_image,category,cate_slug,cate_id');
			$this->db->where('parent_cate_id','0');
			$this->db->where('is_active','1');
			$this->db->order_by('category','asc');
			$result = $this->db->get('dj_categories')->result();
			return $result;
		}
		//GET SIMILAR Category Wise Store List
		public function _get_similar_category_list($limit,$orderby)
		{		
			$this->db->select('cate_id,cate_slug,category');
			$this->db->where('parent_cate_id','0');
			$this->db->where('is_active','1');
			foreach($orderby as $key_or => $or):
            $this->db->order_by($key_or,$or);
			endforeach;
			$this->db->limit($limit);
			$result = $this->db->get('dj_categories')->result();
			//echo $this->db->last_query();
			return $result;
		}
		//GET SIMILAR Category Wise Tags List
		public function _get_similar_category_tags_list($limit,$orderby,$cate_id)
		{		
			$this->db->select('tags_name,tags_slug');
			if(!empty($cate_id))
			{
				$this->db->where('category_id',$cate_id);
			}
			$this->db->where('is_enable','1');
			foreach($orderby as $key_or => $or):
            $this->db->order_by($key_or,$or);
			endforeach;
			if(!empty($limit))
			{
				$this->db->limit($limit);
			}			
			$result = $this->db->get('dj_categories_tags_list')->result();
			//echo $this->db->last_query();
			return $result;
		}
		//GET SIMILAR Stores List Category Wise
		public function _get_similar_stores_list($limit,$orderby,$cate_id,$store_id)
		{		
			$this->db->select('store_name,slug');
			$this->db->where('parent_cate_id',$cate_id);
			if(!empty($store_id))
			{
				$this->db->where('store_id!=',$store_id);
			}
			$this->db->where('is_active','enable');
			foreach($orderby as $key_or => $or):
            $this->db->order_by($key_or,$or);
			endforeach;
			$this->db->limit($limit);
			$result = $this->db->get('dj_brands')->result();
			//echo $this->db->last_query();
			return $result;
		}
		//All Stores List
		public function _get_all_stores_list($char)
		{
			$this->db->select('store_name,slug');		
			$this->db->where('is_active','enable');
			$this->db->like('store_name',$char, 'after');
			$this->db->order_by('store_name','asc');
			$result = $this->db->get('dj_brands')->result();
			//echo $this->db->last_query();
			return $result;
		}
		//Category Wise Store List
		public function _get_category_store_list($cate_id,$limit,$is_featured,$orderby)
		{		
			$this->db->select('store_name,slug,store_logo');
			$this->db->where('parent_cate_id',$cate_id);
			if(!empty($is_featured))
			{
			    $this->db->where('is_featured',$is_featured);
			}
			$this->db->where('is_active','enable');
			foreach($orderby as $key_or => $or):
            $this->db->order_by($key_or,$or);
			endforeach;
			$this->db->limit($limit);
			$result = $this->db->get('dj_brands')->result();
			//echo $this->db->last_query();exit;
			return $result;
		}
		/* 	SELECT 
			FROM `dj_offers` 
			INNER JOIN dj_brands ON dj_offers.store_id = dj_brands.store_id
			WHERE dj_offers.is_active = '1'              
			AND dj_offers.store_id = $store_id
			ORDER BY dj_offers.coupon_priority DESC 
		LIMIT 1 */
		//Coupons Wise Store List
		public function _get_store_coupons_list($store_id,$limit,$orderby,$type)
		{
			$this->db->select('dj_offers.coupon_title,dj_offers.is_views,dj_offers.coupon_deep_link,dj_offers.coupon_type,dj_offers.coupon_code,dj_offers.coupon_expiry,dj_offers.id, dj_brands.store_logo,dj_brands.store_banner,dj_brands.store_name,dj_brands.slug,dj_brands.tracking_url,dj_brands.store_name,dj_brands.slug');		
			$this->db->where('dj_offers.store_id',$store_id);
			$this->db->where('dj_offers.is_active','1');
			$this->db->where('dj_brands.is_active','enable');
			$this->db->where('dj_offers.coupon_expiry>=',date('Y-m-d'));
			if(!empty($type))
			{
				$this->db->where('dj_offers.coupon_type',$type);
			}		
			foreach($orderby as $key_or => $or):
            $this->db->order_by($key_or,$or);
			endforeach;       
			$this->db->limit($limit);
			$this->db->from('dj_offers');
			$this->db->join('dj_brands','dj_brands.store_id = dj_offers.store_id');
			$result =  $this->db->get()->result();
			//echo $this->db->last_query();
			//exit;
			return $result;
		}
		//Single Stores Active Not Expire Coupons List 
		public function _get_single_store_coupons_list($store_id,$orderby)
		{
			$this->db->select('dj_offers.coupon_title,dj_offers.is_views,dj_offers.coupon_deep_link,dj_offers.coupon_type,dj_offers.coupon_code,dj_offers.coupon_expiry,dj_offers.id,dj_offers.coupon_offer,dj_offers.store_id,dj_brands.store_logo,dj_brands.store_banner,dj_brands.tracking_url,dj_brands.store_name,dj_brands.slug,dj_offers.coupon_priority,dj_offers.coupons_seo,dj_offers.created as coupon_created,dj_offers.modify_date as coupon_modified,dj_offers.created,');		
			$this->db->where('dj_offers.store_id',$store_id);
			$this->db->where('dj_offers.is_active','1');
			$this->db->where('dj_offers.coupon_expiry>=',date('Y-m-d'));
			foreach($orderby as $key_or => $or):
            $this->db->order_by($key_or,$or);
			endforeach;       
			$this->db->from('dj_offers');
			$this->db->join('dj_brands','dj_brands.store_id = dj_offers.store_id');
			$result =  $this->db->get()->result();
			return $result;
		}
		//Single Stores Active Not Expire Coupons List 
		public function _get_single_coupons_by_category_list($cate_id,$orderby,$limit)
		{
			$this->db->select('dj_offers.coupon_title,dj_offers.is_views,dj_offers.coupon_deep_link,dj_offers.coupon_type,dj_offers.coupon_code,dj_offers.coupon_expiry,dj_offers.id,dj_offers.coupon_offer,dj_offers.store_id,dj_brands.store_logo,dj_brands.store_banner,dj_brands.tracking_url,dj_brands.store_name,dj_brands.slug,dj_offers.coupon_priority,dj_offers.coupons_seo,dj_offers.created as coupon_created,dj_offers.modify_date as coupon_modified,dj_offers.created,');		
			$this->db->where('dj_brands.parent_cate_id',$cate_id);
			$this->db->where('dj_offers.is_active','1');
			$this->db->where('dj_offers.coupon_expiry>=',date('Y-m-d'));
			foreach($orderby as $key_or => $or):
            $this->db->order_by($key_or,$or);
			endforeach;       
			$this->db->limit($limit);
			$this->db->group_by('dj_brands.store_id');
			$this->db->from('dj_offers');
			$this->db->join('dj_brands','dj_brands.store_id = dj_offers.store_id');
			$result =  $this->db->get()->result();
			return $result;
		}
		//GEt Static Offers
		public function _get_static_coupons_list($store_id)
		{
			$this->db->select('*');
			$this->db->where('store_id',$store_id);
			$this->db->order_by('id','asc');
			$this->db->from('dj_offers');			
			$result = $this->db->get()->result();
			return $result;
		}
		//GEt Total Views By Stores ID
		public function _get_total_views_coupons_list($store_id)
		{
			$this->db->select_sum('is_views');
			$this->db->where('store_id',$store_id);
			$this->db->where('dj_offers.is_active','1');
			//$this->db->where('dj_offers.coupon_expiry>=',date('Y-m-d'));
			$this->db->group_by('store_id');
			$this->db->from('dj_offers');			
			$result = $this->db->get()->result();
			return $result;
		}
		//Thousand List Convert
		public function thousandsCurrencyFormat($num) 
		{
			if($num > 1000) 
			{
				$x = round($num);
				$x_number_format = number_format($x);
				$x_array = explode(',', $x_number_format);
				$x_parts = array('k', 'm', 'b', 't');
				$x_count_parts = count($x_array) - 1;
				$x_display = $x;
				$x_display = $x_array[0] . ((int) $x_array[1][0] !== 0 ? '.' . $x_array[1][0] : '');
				$x_display .= $x_parts[$x_count_parts - 1];	
				return $x_display;
			}
			return $num;
		}
		//Single Stores Expire Coupons List 
		public function _get_single_store_expire_coupons_list($store_id,$orderby)
		{
			$this->db->select('dj_offers.coupon_title,dj_offers.coupon_expiry, dj_brands.store_logo,dj_brands.store_banner,dj_brands.tracking_url,dj_brands.store_name,dj_brands.store_id,dj_brands.slug');		
			$this->db->where('dj_offers.store_id',$store_id);
			$this->db->where('dj_offers.is_active','1');
			$this->db->where('dj_offers.coupon_expiry<',date('Y-m-d'));
			foreach($orderby as $key_or => $or):
            $this->db->order_by($key_or,$or);
			endforeach;       
			$this->db->from('dj_offers');
			$this->db->join('dj_brands','dj_brands.store_id = dj_offers.store_id');
			$result =  $this->db->get()->result();
			return $result;
		}
		//GET All Events
		public function _get_event_list($limit,$orderby)
		{		
			$this->db->select('event_slug,event_title,event_image');
			$this->db->where('is_enable','1');
			foreach($orderby as $key_or => $or):
            $this->db->order_by($key_or,$or);
			endforeach;
			if($limit)
			{
				$this->db->limit($limit);
			}
			$result = $this->db->get('event_list')->result();
			//echo $this->db->last_query();
			return $result;
		}
		//GET SIMILAR Event List
		public function _get_similar_event_list($limit,$orderby,$event_id)
		{		
			$this->db->select('event_title,event_slug');
			//$this->db->where('parent_cate_id',$cate_id);
			if(!empty($event_id))
			{
				$this->db->where('event_id!=',$event_id);
			}
			$this->db->where('is_enable','1');
			foreach($orderby as $key_or => $or):
            $this->db->order_by($key_or,$or);
			endforeach;
			$this->db->limit($limit);
			$result = $this->db->get('event_list')->result();
			//echo $this->db->last_query();
			return $result;
		}
		//Get All Coupons List By Event Search Keywords
		public function _get_single_event_coupons_list($event_like)
		{
			$query = $this->db->query("SELECT dj_offers.coupon_title,dj_offers.coupon_deep_link,dj_offers.coupon_type,dj_offers.coupon_code,dj_offers.coupon_expiry,dj_offers.is_views,dj_offers.id,dj_offers.store_id,dj_brands.store_logo,dj_brands.store_banner,dj_brands.store_name,dj_brands.slug,dj_brands.tracking_url 
			FROM `dj_offers` 
			RIGHT JOIN dj_brands ON dj_offers.store_id = dj_brands.store_id
			WHERE dj_offers.is_active = '1'              
			AND `dj_brands`.`is_active` = 'enable' AND dj_offers.coupon_expiry >='".date('Y-m-d')."'
			AND ({$event_like})                
			ORDER BY dj_offers.coupon_priority DESC");		
			//echo $this->db->last_query();
			$result =  $query->result();
			return $result;
		}
		//Get All Coupons List By Special Pages Search Keywords
		public function _get_single_special_coupons_list($search_like,$limit)
		{
			$query = $this->db->query("SELECT dj_offers.coupon_title,dj_offers.is_views,dj_offers.coupon_deep_link,dj_offers.coupon_type,dj_offers.coupon_code,dj_offers.coupon_expiry,dj_offers.id,dj_offers.store_id,dj_brands.store_logo,dj_brands.store_banner,dj_brands.store_name,dj_brands.slug,dj_brands.tracking_url 
			FROM `dj_offers` 
			RIGHT JOIN dj_brands ON dj_offers.store_id = dj_brands.store_id
			WHERE dj_offers.is_active = '1'              
			AND `dj_brands`.`is_active` = 'enable' AND dj_offers.coupon_expiry>='".date('Y-m-d')."'
			AND {$search_like} {$limit}                
			");		
			//echo $this->db->last_query();
			//exit;
			$result =  $query->result();
			return $result;
		}
		//Get All Stores List By Event Search Keywords Stores
		public function _get_single_event_store_list($store_ids,$limit)
		{
			/* $query = $this->db->query("SELECT dj_brands.store_name,dj_brands.store_logo,dj_brands.slug FROM `dj_brands` 
				WHERE dj_brands.store_id IN ($store_ids)  
				AND dj_brands.is_active = 'enable' 
				AND 
				dj_brands.network_id IN (SELECT 
				network_id
				FROM
				dj_networks
				WHERE
				is_active = 'enable')
			ORDER BY dj_brands.store_priority DESC Limit $limit");	 */	
			$query = $this->db->query("SELECT dj_brands.store_name,dj_brands.store_id,dj_brands.store_logo,dj_brands.store_banner,dj_brands.slug FROM `dj_brands` 
			WHERE dj_brands.store_id IN ($store_ids)  
			AND dj_brands.is_active = 'enable' ORDER BY dj_brands.store_priority DESC Limit $limit");	
			//echo $this->db->last_query();
			$result =  $query->result();
			return $result;
		}
		//All Stores Data With Searching
		function getRowsStores($params = array())
		{
			$this->db->select('*');
			$this->db->from('dj_brands');
			$this->db->where('is_active','enable');
			if(!empty($params['search']['cat_id']))
			{
				$this->db->where('parent_cate_id',$params['search']['cat_id']);
			}		
			$this->db->order_by('store_priority','desc');
			//set start and limit
			if(array_key_exists("start",$params) && array_key_exists("limit",$params)){
				$this->db->limit($params['limit'],$params['start']);
				}elseif(!array_key_exists("start",$params) && array_key_exists("limit",$params)){
				$this->db->limit($params['limit']);
			}
			$query = $this->db->get();
			//echo $this->db->last_query();
			//return fetched data
			if($query->num_rows() > 0)
			{
				return $query->result();
			} 
			else
			{
				return 0;
			}
		}
		//Get Multiple Record
		public function check_already_exists_multiple($table,$get_column,$wheres,$type)
		{
			//echo "YES";
			$this->db->select($get_column);
			foreach($wheres as $key_wh => $wh):
            $this->db->where($key_wh,$wh);
            endforeach;
			$query =  $this->db->get($table);   
			//echo $this->db->last_query();
			//exit; 
			if($type == 1)
			{
				$count  = $query->num_rows();
				$return = $count;
			}
			if($type == 2)
			{
				$Q_result  = $query->result();
				$return = $Q_result;
			}
			if($type == 3)
			{
				$Q_result_array  = $query->result_array();
				$return = $Q_result_array;
			}
			if($type == 4)
			{
				$count  = $query->num_rows();
				$return = $count;
				$Q_result  = $query->result();
				$return = $Q_result;
				$Q_result_array  = $query->result_array();
				$return = $Q_result_array;
				$return = array();
				$return['1']['count'] = $count;
				$return['2']['Query_result'] = $Q_result;
				$return['3']['Query_result_array'] = $Q_result_array;
			}
			return $return;
		}
		/*
			* Insert data into the database
			* @param $data data to be insert based on the passed parameters
		*/
		public function insert($data = array(),$table) 
		{
			if(!empty($data))
			{
				$data['created_date'] = date('Y-m-d H:i:s');
				$data['created_by'] = $this->session->userdata('id');
				// Insert data
				$insert = $this->db->insert($table, $data);
				// Return the status
				return $insert?$this->db->insert_id():false;
			}
			return false;
		}
		/*
			* Update data into the database
			* @param $data array to be update based on the passed parameters
			* @param $condition array filter data
		*/
		public function update($data, $condition = array(),$table) {
			if(!empty($data)){
				$data['modify_date'] = date('Y-m-d H:i:s');
				$data['modify_by'] = $this->session->userdata('id');
				// Update data
				$update = $this->db->update($table, $data, $condition);
				// Return the status
				return $update?true:false;
			}
			return false;
		}
		//check relation reference
		public function get_relation_pax($table,$column,$reference,$input)
		{
			$this->db->select($column);
			$this->db->where($reference,$input);
			$this->db->where('is_enable',1);
			$result =  $this->db->get($table)->result();
			return $result[0]->$column;
		}
		//check relation reference email
		public function get_relation_pax_email($table,$column,$reference,$input)
		{
			$this->db->select($column);
			$this->db->where($reference,$input);
			$result =  $this->db->get($table)->result();
			return @$result[0]->$column;
		}
		//check relation reference multiple
		public function get_relation_pax_multiple($table,$column,$wheres)
		{
			$this->db->select($column);
			//$this->db->where($reference,$input);
			foreach($wheres as $key_wh => $wh):
            $this->db->where($key_wh,$wh);
			endforeach;
			$this->db->where('is_enable',1);
			$result =  $this->db->get($table)->result();
			return $result[0]->$column;
		}
		//Check already Exit
		public function check_already_exists($column,$value,$table)
		{
			$this->db->select('*');
			$this->db->where($column,$value);
			$query =  $this->db->get($table);
			$count = $query->num_rows();
			return array(
            'row_count' => $count,
            'result_data' => $query->result()
			);
		}
		public function _delete($id)
		{
			$delete = $this->db_delete($id,$this->_table_name);
			return $delete;
		} 
		public function db_command($data, $id ,$table)
		{
			// Insert
			if ($id == NULL)
			{
				$this->db->set($data);
				$this->db->insert($table);
				$id = $this->db->insert_id();
			}
			// Update
			else
			{
				$filter = 'id';
				$id     = $filter($id);
				$this->db->set($data);
				$this->db->where('id', $id);
				$this->db->update($table);
			}
			return $id;
		}
		public function db_delete($id,$table)
		{
			$this->db->where($this->_primary_key, $id);
			$delete =  $this->db->delete($table);
			if($delete)
			{
				return 1;
			}else
			{
				return 0;
			}
		}
	}
?>