<?php
	defined('BASEPATH') OR exit('No direct script access allowed');
	class Frontend extends MX_Controller {
		public $admin_email = array();
		public $data = array();
		public $footer_array = array();
		public $header_array = array();
		public $home_array = array();
		/**
			* Index Page for this controller.
			*
			* Maps to the following URL
			* 		http://example.com/index.php/welcome
			*	- or -
			* 		http://example.com/index.php/welcome/index
			*	- or -
			* Since this controller is set as the default controller in
			* config/routes.php, it's displayed at http://example.com/
			*
			* So any other public methods not prefixed with an underscore will
			* map to /index.php/welcome/<method_name>
			* @see http://codeigniter.com/user_guide/general/urls.html
		*/
		function __construct() {
			parent::__construct();
			// Load member model
			$this->load->model('Mdl_frontend');
			$this->load->library('email');
		    $this->data['system_info'] = $this->Mdl_frontend->_get_system_setting_list();
			//For Menu Categories IDs
			$data_pages_list = $this->Mdl_frontend->_get_pages_list('menu_category');
			//Footer Section Dynamic List Start
			$my_menu_category = array();
			/////////////////////////////////////////////FOR Header
			if(!empty($data_pages_list))
			{
				$my_menu_category = explode(",",$data_pages_list[0]->long_description);
			}			
			//Footer Section Dynamic List End
			//Header Section Dynamic Start
			$this->header_array['my_menu_category'] = $my_menu_category;
			if(!empty($my_menu_category))
			{
				for ($i = 0; $i < count($my_menu_category); $i++) 
				{
					if($i > 8)
					{
						break;
					}
					$where_cat = array( 'is_active' => '1','cate_id' => $my_menu_category[$i] );
					$result_cat = $this->Mdl_frontend->check_already_exists_multiple('gg_categories','category,cate_slug',$where_cat,4);
					//exit;
					if($result_cat[1]['count'] > 0)
					{
						$this->header_array['header_cat_name'][$my_menu_category[$i]] = ucwords($result_cat[2]['Query_result'][0]->category);
						$this->header_array['header_cat_slug'][$my_menu_category[$i]] = strtolower($result_cat[2]['Query_result'][0]->cate_slug);
						$morder = array('store_priority'=>'desc');
						$m_category_store = $this->Mdl_frontend->_get_category_store_list($my_menu_category[$i],4,'no',$morder);
						$this->header_array['header_store_list'][$my_menu_category[$i]] = $m_category_store;
					}
				}
			}
			$this->data['header_section'] = $this->header_array;
			//Header Section Dynamic End
		}
		//_404_page
		public function _404_page()
		{ 
			$this->data['pages_list'] = $this->Mdl_frontend->_get_pages_list();
			$my_vstore = array();
			$my_store_category = array();
			$my_dstore = array();
			//Pages List
			foreach ($this->data['pages_list'] as $home_data) 
			{
				/////////////////////////////////////////////FOR Home Page
				//For Home Voucher Codes Stores
				if($home_data->page_name == 'home_voucher_codes')
				{
					$this->home_array['home_voucher_codes_title'] = $home_data->title;
					$my_vstore = explode(",",$home_data->long_description);
					$this->home_array['is_home_voucher_codes'] = 1;
				}
			}
			//For Home Voucher Codes Stores
			$this->home_array['my_vstore'] = $my_vstore;
			if(!empty($my_vstore))
			{
				$m_cat11 = 0;
				for ($i = 0; $i < count($my_vstore); $i++) 
				{
					$where_vcat = array( 'is_active' => 'enable','store_id' => $my_vstore[$i] );
					$result_vcat = $this->Mdl_frontend->check_already_exists_multiple('gg_stores','store_id',$where_vcat,4);
					//echo "<pre>";
					//print_r($result_vcat);
					if(!empty($result_vcat[1]['count']))
					{
						if($m_cat11 > 8)
						{
							break;
						}
						$m_cat11++;
						$store_id = $result_vcat[2]['Query_result'][0]->store_id;
						$morder11 = array('gg_coupons.coupon_priority'=>'desc');
						$m_store_coupon = $this->Mdl_frontend->_get_store_coupons_list($store_id,1,$morder11,"code");
						if(!empty($m_store_coupon))
						{
							$this->home_array['home_voucher_codes_stores_list'][$store_id] = $m_store_coupon;
						}
						else
						{
							$this->home_array['home_voucher_codes_stores_list'][$store_id] = array();
						}
					}
				}
			}
			$this->data['home_section'] = $this->home_array;
			$this->load->view('_404_page',$this->data);
		}
		public function testing($offset=0){
			//echo CI_VERSION;
			$this->load->library('pagination');
			$config['total_rows'] = $this->Mdl_frontend->totalMovies();
			$config['base_url'] = base_url()."Frontend/testing/page";
			$config['per_page'] = 5;
			$config['uri_segment'] = '4';
			$config['use_page_numbers'] = TRUE;
			$config['full_tag_open'] = '<div class="pagination"><ul>';
			$config['full_tag_close'] = '</ul></div>';
			$config['first_link'] = '« First';
			$config['first_tag_open'] = '<li class="prev page">';
			$config['first_tag_close'] = '</li>';
			$config['last_link'] = 'Last »';
			$config['last_tag_open'] = '<li class="next page">';
			$config['last_tag_close'] = '</li>';
			$config['next_link'] = 'Next →';
			$config['next_tag_open'] = '<li class="next page">';
			$config['next_tag_close'] = '</li>';
			$config['prev_link'] = '← Previous';
			$config['prev_tag_open'] = '<li class="prev page">';
			$config['prev_tag_close'] = '</li>';
			$config['cur_tag_open'] = '<li class="active"><a href="">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li class="page">';
			$config['num_tag_close'] = '</li>';
			$this->pagination->initialize($config);
			$page = ($this->uri->segment(4)) ? ($this->uri->segment(4) - 1) : 0;
			$query = $this->Mdl_frontend->getMovies($config["per_page"], ($config["per_page"] * $page));
			$data['MOVIES'] = null;
			if($query){
				$data['MOVIES'] =  $query;
			}
			$this->load->view('testing', $data);
		}
		public function removeunderscores($res)
		{
			$abc = str_replace('--',',',$res);
			return  str_replace('_',' ',$abc);
		}
		public function removeunderscores_product($res)
		{
			$abc = str_replace('--',',',$res);
			return  str_replace('-',' ',$abc);
		}
		//Main Page
		public function index()
		{
			$this->data['pages_list'] = $this->Mdl_frontend->_get_pages_list();
			$my_vstore = array();
			$my_store_category = array();
			$my_dstore = array();
			//Pages List
			foreach ($this->data['pages_list'] as $home_data) 
			{
				/////////////////////////////////////////////FOR Home Page
				//For Home Voucher Codes Stores
				if($home_data->page_name == 'home_voucher_codes')
				{
					$this->home_array['home_voucher_codes_title'] = $home_data->title;
					$my_vstore = explode(",",$home_data->long_description);
					$this->home_array['is_home_voucher_codes'] = 1;
				}
				//For Home Store Category
				if($home_data->page_name == 'home_store_category')
				{
					$this->home_array['home_store_category_title'] = $home_data->title;
					$my_store_category = explode(",",$home_data->long_description);
					$this->home_array['is_home_store_category'] = 1;
				}
				//For Home Voucher Deals Stores
				if($home_data->page_name == 'home_voucher_deals')
				{
					$this->home_array['home_voucher_deals_title'] = $home_data->title;
					$my_dstore = explode(",",$home_data->long_description);
					$this->home_array['is_home_voucher_deals'] = 1;
				}
			}
			//For Home Voucher Codes Stores
			$this->home_array['my_vstore'] = $my_vstore;
			if(!empty($my_vstore))
			{
				$m_cat11 = 0;
				for ($i = 0; $i < count($my_vstore); $i++) 
				{
					$where_vcat = array( 'is_active' => 'enable','store_id' => $my_vstore[$i] );
					$result_vcat = $this->Mdl_frontend->check_already_exists_multiple('gg_stores','store_id',$where_vcat,4);
					//echo "<pre>";
					//print_r($result_vcat);
					if(!empty($result_vcat[1]['count']))
					{
						if($m_cat11 > 8)
						{
							break;
						}
						$m_cat11++;
						$store_id = $result_vcat[2]['Query_result'][0]->store_id;
						$morder11 = array('gg_coupons.coupon_priority'=>'desc');
						$m_store_coupon = $this->Mdl_frontend->_get_store_coupons_list($store_id,1,$morder11,"code");
						if(!empty($m_store_coupon))
						{
							$this->home_array['home_voucher_codes_stores_list'][$store_id] = $m_store_coupon;
						}
						else
						{
							$this->home_array['home_voucher_codes_stores_list'][$store_id] = array();
						}
					}
				}
			}
			//For Home Voucher Deals Stores
			$this->home_array['my_dstore'] = $my_dstore;
			if(!empty($my_dstore))
			{
				$m_cat11 = 0;
				for ($i = 0; $i < count($my_dstore); $i++) 
				{
					$where_vcat = array( 'is_active' => 'enable','store_id' => $my_dstore[$i] );
					$result_vcat = $this->Mdl_frontend->check_already_exists_multiple('gg_stores','store_id',$where_vcat,4);
					//echo "<pre>";
					//print_r($result_vcat);
					if(!empty($result_vcat[1]['count']))
					{
						if($m_cat11 > 7)
						{
							break;
						}
						$m_cat11++;
						$store_id = $result_vcat[2]['Query_result'][0]->store_id;
						$morder11 = array('gg_coupons.coupon_priority'=>'desc');
						$m_store_coupon = $this->Mdl_frontend->_get_store_coupons_list($store_id,1,$morder11,"deal");							
						if(!empty($m_store_coupon))
						{
							$this->home_array['home_voucher_deals_stores_list'][$store_id] = $m_store_coupon;
						}
						else
						{
							$this->home_array['home_voucher_deals_stores_list'][$store_id] = array();
						}
					}
				}
			}
			//Show Home Store Categories Dynamic
			$this->home_array['my_store_category'] = $my_store_category;
			if(!empty($my_store_category))
			{
				for ($i = 0; $i < count($my_store_category); $i++) 
				{
					if($i > 5)
					{
						break;
					}
					$where_cat = array( 'is_active' => '1','cate_id' => $my_store_category[$i] );
					$result_cat = $this->Mdl_frontend->check_already_exists_multiple('gg_categories','category,cate_slug',$where_cat,4);
					if($result_cat[1]['count'] > 0)
					{
						$this->home_array['home_cat_name'][$my_store_category[$i]] = ucwords($result_cat[2]['Query_result'][0]->category);
						$this->home_array['home_cat_slug'][$my_store_category[$i]] = strtolower($result_cat[2]['Query_result'][0]->cate_slug);
						$morder = array('store_priority'=>'desc');
						$m_category_store = $this->Mdl_frontend->_get_category_store_list($my_store_category[$i],16,'no',$morder);
						if(!empty($m_category_store))
						{
						    $this->home_array['home_store_list'][$my_store_category[$i]] = $m_category_store;
						}
					}
				}
			}
			$this->data['home_section'] = $this->home_array;
			$this->data['slider_list'] = $this->Mdl_frontend->_get_slider_list();
			$wp_blog_list = $this->Mdl_frontend->_get_wp_blog_list(4);
			$my_blog = array();
			if(!empty($wp_blog_list))
			{
				foreach($wp_blog_list as $blog)
				{
					$wp_blog_image_list = @$this->Mdl_frontend->_get_wp_blog_image_list($blog->ID);
					$my_blog['post_title'][$blog->ID] = $blog->post_title;
					$my_blog['post_link'][$blog->ID] = $blog->post_name;
					$my_blog['post_image'][$blog->ID] = @$wp_blog_image_list[0]->guid;
				}
			}
			//print_r($my_blog);
			$this->data['wp_blog_list'] = $wp_blog_list;
			$this->data['my_blog'] = $my_blog; 
			$this->load->view('index',$this->data);
		}
		//redirect_index
		public function redirect_index()
		{
		    redirect(base_url(),'refresh');
		}
		
		//Searching Start
		public function dropdown_search() 
		{
			//echo "YES";
			$store = $this->input->get('term');
			//$slug = urldecode($slug);
			$query = $this->db->query("SELECT store_name,slug,store_logo FROM `gg_stores` 
			WHERE gg_stores.is_active = 'enable' AND gg_stores.store_name LIKE '%$store%'
			AND gg_stores.is_active = 'enable' ORDER BY gg_stores.store_priority DESC LIMIT 5");
			$srchValue = $query->result();
			$userData = array();
			$value = '[';
			for($i=0; $i<count($srchValue); $i++)
			{
				if(@$srchValue[$i]->store_logo != "")
				{
					$image_pic11 = FCPATH."public_html/backend/image/store_logo/" .@$srchValue[$i]->store_logo;
					//echo $image_pic;
					if(file_exists($image_pic11))
					{
						$search_logo_url = base_url()."public_html/backend/image/store_logo/" . @$srchValue[$i]->store_logo;
					}
					else
					{
						$search_logo_url = base_url().'public_html/backend/image/default_store.jpg';
					}
				}
				else
				{
					$search_logo_url = base_url().'public_html/backend/image/default_store.jpg';
				}
				$data['value'] = strtolower($srchValue[$i]->slug);
				$data['myname'] = ($srchValue[$i]->store_name);
				$data['label'] = '        
				<img src="'.$search_logo_url.'" width="60" height="60"/>
				'.$srchValue[$i]->store_name.'
				';
				array_push($userData, $data);
			}
			//rtrim($value,",");
			// $value .='];';
			echo json_encode($userData);
		}
		public function search_store($search_name = NULL) 
		{
			/* try 
			{ */
			$store_name = htmlspecialchars(urldecode($search_name));
			if(!empty($store_name))
			{
				$final_stores = array();
				$getRec_wh = $this->Mdl_frontend->get_search_stores_wh($store_name);
				$this->data['my_search_store_wh']  = $getRec_wh;
				$getRec_lk = $this->Mdl_frontend->get_search_stores_lk($store_name);
				$this->data['my_search_store_lk']  = $getRec_lk;
				$my_search_store  = array_merge($getRec_wh,$getRec_lk);
				$this->data['my_search_store_final']  = array_map("unserialize", array_unique(array_map("serialize", $my_search_store)));
				$this->data['search_value']  = $store_name;
				//**BY OFFERS SEARCH START
				$mysearch = " gg_coupons.coupon_title LIKE '%$store_name%'";
				$mylimit = "ORDER BY gg_coupons.coupon_priority DESC";
				//** Related Categories Stores Pagination Start **//
				$this->load->library('pagination');
				$total_rows = $this->Mdl_frontend->total_search_stores_offers($store_name);
				//print_r(count($total_rows));
				$config['total_rows'] = count($total_rows);
				$config['base_url'] = base_url()."search/".$store_name."/page";
				$config['per_page'] = 50;
				$config['first_url'] = 1;
				//$config['uri_segment'] = '4';
				$config['use_page_numbers'] = TRUE;
				$config['full_tag_open'] = '<div class="pagination">';
				$config['full_tag_close'] = '</div>';
				$config['first_link'] = '« First';
				$config['first_tag_open'] = '';
				$config['first_tag_close'] = '';
				$config['last_link'] = 'Last »';
				$config['last_tag_open'] = '';
				$config['last_tag_close'] = '';
				$config['next_link'] = 'Next';
				$config['next_tag_open'] = '';
				$config['next_tag_close'] = '';
				$config['prev_link'] = 'Previous';
				$config['prev_tag_open'] = '';
				$config['prev_tag_close'] = '';
				$config['cur_tag_open'] = '<p>';
				$config['cur_tag_close'] = '</p>';
				$config['num_tag_open'] = '';
				$config['num_tag_close'] = '';
				$this->pagination->initialize($config);
				$page = ($this->uri->segment(4)) ? ($this->uri->segment(4) - 1) : 0;
				$query = $this->Mdl_frontend->get_total_search_stores_offers($store_name,$config["per_page"], ($config["per_page"] * $page));
				$this->data['result_set_coupon'] = null;
				$this->data['result_count_coupon']  = 0;
				if($query)
				{
					$this->data['result_count_coupon']  = count($query);
					$this->data['result_set_coupon'] =  $query;
					$store_ids = '';
					$store_array = array();
					for($i=0; $i<count($query);$i++){
						$store_array[] = $query[$i]->store_id; 
					}
					$final_dd = array_unique($store_array);			
					$store_ids = implode(',',$final_dd);			
					$getEventStores = $this->Mdl_frontend->_get_single_event_store_list($store_ids,'30');    
					//Similar Stores
					$this->data['result_count_fstore']  = count($getEventStores);
					$this->data['result_set_fstore']  = $getEventStores;	
				}
				//$config['links'] = $this->pagination->create_links();
				//** Related Categories Stores Pagination End **// 	
				//For Pagination URL
				if(!empty($this->uri->segment(3)) && !empty($this->uri->segment(4)))
				{
					$this->data['my_url']  = base_url()."search/".strtolower($store_name)."/".$this->uri->segment(3)."/".$this->uri->segment(4);
					$this->data['my_title']  = $this->uri->segment(4);
				}
				else
				{
					$this->data['my_url']  = base_url()."search/".strtolower($store_name);
				}
				//$this->data['result_count_coupon']  = count($getCoupon);
				//$this->data['result_set_coupon']  = $getCoupon;
				//Similar Category
				$morder = array('cate_id'=>'desc');
				$getRec1 = $this->Mdl_frontend->_get_similar_category_list('8',$morder);
				$this->data['result_count_cat']  = count($getRec1);
				$this->data['result_set_cat']  = $getRec1;
				$store_array = array();
			foreach($getRec1 as $res1)
			{
				$morder22 = array('store_priority'=>'desc');
				$m_category_store11 = $this->Mdl_frontend->_get_category_store_list($res1->cate_id,40,'no',$morder22);
				$store_array[$res1->cate_id] = $m_category_store11;
			}
			$this->data['result_mystores1']  = $store_array;
				//**BY OFFERS SEARCH END
				$this->load->view('search_store',$this->data);			
			}
			else
			{
				redirect(base_url().'_404_page.html','refresh');
			}
			/* } catch  (Exception $e) {
				echo 'Received exception : ',  $e->getMessage(), "\n";
			}  */
		}
		//Searching End
		//Popup Tracking URL START
		public function get_offer_submit()
		{
			$offer_id = $this->input->post('offer_id');
			$href = $this->input->post('href');
			$query = $this->db->query("SELECT gg_coupons.coupon_title,gg_coupons.id,gg_coupons.is_views,gg_coupons.coupon_expiry,gg_coupons.coupon_desc,gg_coupons.coupon_deep_link,gg_coupons.coupon_type,gg_coupons.coupon_code,gg_stores.store_logo,gg_stores.tracking_url,gg_stores.store_name 
			FROM `gg_coupons` 
			RIGHT JOIN gg_stores ON gg_coupons.store_id = gg_stores.store_id
			WHERE gg_coupons.is_active = '1'              
			AND gg_coupons.id = $offer_id
			");
			$m_coupon = $query->result();
			//echo $this->db->last_query();
			//exit;
			if(!empty($m_coupon))
			{
				//$trc = $data[0]->is_views;
				if ($m_coupon[0]->coupon_type == "code") 
				{ 
					if (empty($m_coupon[0]->coupon_deep_link)) 
					{
						$click_link = $href."?promo=".$m_coupon[0]->id;
						$href_link = trim(preg_replace('/\s+/', '', $m_coupon[0]->tracking_url));
					}
					else
					{
						$click_link = $href."?promo=".$m_coupon[0]->id;
						$href_link = trim(preg_replace('/\s+/', '', $m_coupon[0]->coupon_deep_link));
					}
				}
				else if ($m_coupon[0]->coupon_type == "deal") 
				{ 
					if (empty($m_coupon[0]->coupon_deep_link)) 
					{
						$click_link = trim(preg_replace('/\s+/', '', $m_coupon[0]->tracking_url));
						$href_link = $href. "?promo=".$m_coupon[0]->id;
					}
					else
					{
						$click_link = trim(preg_replace('/\s+/', '', $m_coupon[0]->coupon_deep_link));
						$href_link = $href."?promo=".$m_coupon[0]->id;
					}
				}
				$_return = array('link1'=>$click_link,'link2'=>$href_link);
 				$return = json_encode($_return);
				echo $return; 
			}
			else
			{
			}
		}
		//Popup Tracking URL START
		public function get_store_submit()
		{
			$store_id = $this->input->post('store_id');
			$href = $this->input->post('href');
			$query = $this->db->query("SELECT gg_stores.tracking_url FROM gg_stores WHERE gg_stores.is_active = 'enable' AND gg_stores.store_id = $store_id
			");
			$m_stores = $query->result();
			//echo $this->db->last_query();
			//exit;
			if(!empty($m_stores))
			{
				$click_link = trim(preg_replace('/\s+/', '', $m_stores[0]->tracking_url));
				$_return = array('link1'=>$click_link);
 				$return = json_encode($_return);
				echo $return;			
			}
			else
			{
			}
		}
		//Popup Tracking URL END
		//about_us Page
		public function about_us()
		{
			$page_data = $this->Mdl_frontend->_get_pages_list('about_us');
			//For about_us
			if(!empty($page_data))
			{
				$this->data['about_us_title'] = $page_data[0]->title;
				$this->data['about_us_desc'] = $page_data[0]->long_description;
				$this->data['is_about_us'] = 1;
			}			
			$this->load->view('about_us',$this->data);
		}
		//top_discount Page
		public function top_discount()
		{
			//Heading Top Discount
			$this->data['is_top_store'] = $this->Mdl_frontend->_get_pages_list('top_20_discount_store');
			//Description
			$this->data['is_description'] = $this->Mdl_frontend->_get_pages_list('top_20_discount_store_info');
			//For Top 20 Stores & Offers
			$my_vstore = array();						
			if(!empty($this->data['is_top_store']))
			{
				$my_vstore = explode(",",$this->data['is_top_store'][0]->long_description);
				$m_cat11 = 0;
				for ($i = 0; $i < count($my_vstore); $i++) 
				{
					$where_vcat = array( 'is_active' => 'enable','store_id' => $my_vstore[$i] );
					$result_vcat = $this->Mdl_frontend->check_already_exists_multiple('gg_stores','store_name,store_logo,slug,store_id',$where_vcat,4);
					if($result_vcat[1]['count'] > 0)
					{
						$this->data['is_top_store_list'][$my_vstore[$i]] = $result_vcat[2]['Query_result'][0];
						$morder11 = array('gg_coupons.coupon_priority'=>'desc');
						$m_store_coupon = $this->Mdl_frontend->_get_store_coupons_list($my_vstore[$i],1,$morder11,"");
						if(!empty($m_store_coupon))
						{
							$this->data['is_top_coupon_list'][$my_vstore[$i]] = $m_store_coupon;
						}
						else
						{	
							$this->data['is_top_coupon_list'][$my_vstore[$i]] = array();
						}
					}
					else
					{
						$this->data['is_top_store_list'][$my_vstore[$i]] = array();
					}
				}
			}
			$this->data['my_vstore'] = $my_vstore;			
			//Right Side Bar Banner
			$this->data['is_right_side_banner1'] = $this->Mdl_frontend->_get_pages_list('right_side_banner');
			$this->load->view('top_discount',$this->data);
		}
		//contact_us Page
		public function contact_us()
		{
			$this->load->view('contact_us',$this->data);
		}
		//contact us submit
		public function contact_us_submit()
		{
			$post_data = $this->input->post();
			$data = array(
			'name' => $post_data['full_name'],
			'subject' => $post_data['subject'],
			'email' => $post_data['email'],
			'msg' => $post_data['message'],
			'ip_address' => $this->input->ip_address(),
			);
			$ins = $this->db->insert('gg_contact', $data);
			if($this->db->affected_rows() == 1)
			{
				$system_name = 'DiscountsLove';
				$site_footer = '© Copyright discountslove.com. All rights reserved.';
				$from_email = $post_data['email'];
				$to_email = 'contactus@discountslove.com,muhammad.sarosh@technado.co';
				$msgadmin1b = '<p>Full Name: '.$post_data['full_name'].'<br/>Email: '.$post_data['email'].'<br/>Subject: '.$post_data['subject'].'<br/>Message: '.$post_data['message'].'</p>';
				$msguser = '<p><b style="color: #777777;">Dear '.$post_data['full_name'].'</b>,<br/>Thank u for contacting us.<br/>we will contact u soon.<br/></p>';
				$htmlmessage = '<!doctype html>
				<html xmlns="http://www.w3.org/1999/xhtml">
				<head>
				<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
				<meta name="viewport" content="initial-scale=1.0" />
				<meta name="format-detection" content="telephone=no" />
				<title></title>
				<style type="text/css">
				body {
				width: 100%;
				margin: 0;
				padding: 0;
				-webkit-font-smoothing: antialiased;
				}
				@media only screen and (max-width: 600px) {
				table[class="table-row"] {
				float: none !important;
				width: 98% !important;
				padding-left: 20px !important;
				padding-right: 20px !important;
				}
				table[class="table-row-fixed"] {
				float: none !important;
				width: 98% !important;
				}
				table[class="table-col"], table[class="table-col-border"] {
				float: none !important;
				width: 100% !important;
				padding-left: 0 !important;
				padding-right: 0 !important;
				table-layout: fixed;
				}
				td[class="table-col-td"] {
				width: 100% !important;
				}
				table[class="table-col-border"] + table[class="table-col-border"] {
				padding-top: 12px;
				margin-top: 12px;
				border-top: 1px solid #E8E8E8;
				}
				table[class="table-col"] + table[class="table-col"] {
				margin-top: 15px;
				}
				td[class="table-row-td"] {
				padding-left: 0 !important;
				padding-right: 0 !important;
				}
				table[class="navbar-row"] , td[class="navbar-row-td"] {
				width: 100% !important;
				}
				img {
				max-width: 100% !important;
				display: inline !important;
				}
				img[class="pull-right"] {
				float: right;
				margin-left: 11px;
				max-width: 125px !important;
				padding-bottom: 0 !important;
				}
				img[class="pull-left"] {
				float: left;
				margin-right: 11px;
				max-width: 125px !important;
				padding-bottom: 0 !important;
				}
				table[class="table-space"], table[class="header-row"] {
				float: none !important;
				width: 98% !important;
				}
				td[class="header-row-td"] {
				width: 100% !important;
				}
				}
				@media only screen and (max-width: 480px) {
				table[class="table-row"] {
				padding-left: 16px !important;
				padding-right: 16px !important;
				}
				}
				@media only screen and (max-width: 320px) {
				table[class="table-row"] {
				padding-left: 12px !important;
				padding-right: 12px !important;
				}
				}
				@media only screen and (max-width: 458px) {
				td[class="table-td-wrap"] {
				width: 100% !important;
				}
				}
				</style>
				</head>
				<body style="font-family: Arial, sans-serif; font-size:13px; color: #444444; min-height: 200px;" bgcolor="#E4E6E9" leftmargin="0" topmargin="0" marginheight="0" marginwidth="0">
				<table width="100%" height="100%" bgcolor="#E4E6E9" cellspacing="0" cellpadding="0" border="0">
				<tr><td width="100%" align="center" valign="top" bgcolor="#E4E6E9" style="background-color:#E4E6E9; min-height: 200px;">
				<table><tr><td class="table-td-wrap" align="center" width="458"><table class="table-space" height="18" style="height: 18px; font-size: 0px; line-height: 0; width: 450px; background-color: #e4e6e9;" width="450" bgcolor="#E4E6E9" cellspacing="0" cellpadding="0" border="0"><tbody><tr><td class="table-space-td" valign="middle" height="18" style="height: 18px; width: 450px; background-color: #e4e6e9;" width="450" bgcolor="#E4E6E9" align="left">&nbsp;</td></tr></tbody></table>
				<table class="table-space" height="8" style="height: 8px; font-size: 0px; line-height: 0; width: 450px; background-color: #ffffff;" width="450" bgcolor="#FFFFFF" cellspacing="0" cellpadding="0" border="0"><tbody><tr><td class="table-space-td" valign="middle" height="8" style="height: 8px; width: 450px; background-color: #ffffff;" width="450" bgcolor="#FFFFFF" align="left">&nbsp;</td></tr></tbody></table>
				<table class="table-row" width="450" bgcolor="#FFFFFF" style="table-layout: fixed; background-color: #ffffff;" cellspacing="0" cellpadding="0" border="0"><tbody><tr><td class="table-row-td" style="font-family: Arial, sans-serif; line-height: 19px; color: #444444; font-size: 13px; font-weight: normal; padding-left: 36px; padding-right: 36px;" valign="top" align="left">
				<table class="table-col" align="left" width="378" cellspacing="0" cellpadding="0" border="0" style="table-layout: fixed;"><tbody><tr><td class="table-col-td" width="378" style="font-family: Arial, sans-serif; line-height: 19px; color: #444444; font-size: 13px; font-weight: normal; width: 378px;" valign="top" align="left">
				<table class="header-row" width="378" cellspacing="0" cellpadding="0" border="0" style="table-layout: fixed;"><tbody><tr><td class="header-row-td" width="378" style="font-family: Arial, sans-serif; font-weight: normal; line-height: 19px; color: #478fca; margin: 0px; font-size: 18px; padding-bottom: 10px; padding-top: 15px;" valign="top" align="left">Contact Details '.$system_name.'</td></tr></tbody></table>
				<div style="font-family: Arial, sans-serif; line-height: 20px; color: #444444; font-size: 13px;">
				<b style="color: #777777;">Dear Admin'.',<br/>User contact detail..!</b>
				'.$msgadmin1b.'
				Thanks.
				</div>
				</td></tr></tbody></table>
				</td></tr></tbody></table>
				<table class="table-space" height="12" style="height: 12px; font-size: 0px; line-height: 0; width: 450px; background-color: #ffffff;" width="450" bgcolor="#FFFFFF" cellspacing="0" cellpadding="0" border="0"><tbody><tr><td class="table-space-td" valign="middle" height="12" style="height: 12px; width: 450px; background-color: #ffffff;" width="450" bgcolor="#FFFFFF" align="left">&nbsp;</td></tr></tbody></table>
				<table class="table-space" height="12" style="height: 12px; font-size: 0px; line-height: 0; width: 450px; background-color: #ffffff;" width="450" bgcolor="#FFFFFF" cellspacing="0" cellpadding="0" border="0"><tbody><tr><td class="table-space-td" valign="middle" height="12" style="height: 12px; width: 450px; padding-left: 16px; padding-right: 16px; background-color: #ffffff;" width="450" bgcolor="#FFFFFF" align="center">&nbsp;<table bgcolor="#E8E8E8" height="0" width="100%" cellspacing="0" cellpadding="0" border="0"><tbody><tr><td bgcolor="#E8E8E8" height="1" width="100%" style="height: 1px; font-size:0;" valign="top" align="left">&nbsp;</td></tr></tbody></table></td></tr></tbody></table>
				<table class="table-space" height="16" style="height: 16px; font-size: 0px; line-height: 0; width: 450px; background-color: #ffffff;" width="450" bgcolor="#FFFFFF" cellspacing="0" cellpadding="0" border="0"><tbody><tr><td class="table-space-td" valign="middle" height="16" style="height: 16px; width: 450px; background-color: #ffffff;" width="450" bgcolor="#FFFFFF" align="left">&nbsp;</td></tr></tbody></table>
				<table class="table-space" height="6" style="height: 6px; font-size: 0px; line-height: 0; width: 450px; background-color: #ffffff;" width="450" bgcolor="#FFFFFF" cellspacing="0" cellpadding="0" border="0"><tbody><tr><td class="table-space-td" valign="middle" height="6" style="height: 6px; width: 450px; background-color: #ffffff;" width="450" bgcolor="#FFFFFF" align="left">&nbsp;</td></tr></tbody></table>
				<table class="table-row-fixed" width="450" bgcolor="#FFFFFF" style="table-layout: fixed; background-color: #ffffff;" cellspacing="0" cellpadding="0" border="0"><tbody><tr><td class="table-row-fixed-td" style="font-family: Arial, sans-serif; line-height: 19px; color: #444444; font-size: 13px; font-weight: normal; padding-left: 1px; padding-right: 1px;" valign="top" align="left">
				<table class="table-col" align="left" width="448" cellspacing="0" cellpadding="0" border="0" style="table-layout: fixed;"><tbody><tr><td class="table-col-td" width="448" style="font-family: Arial, sans-serif; line-height: 19px; color: #444444; font-size: 13px; font-weight: normal;" valign="top" align="left">
				<table width="100%" cellspacing="0" cellpadding="0" border="0" style="table-layout: fixed;"><tbody><tr><td width="100%" align="center" bgcolor="#f5f5f5" style="font-family: Arial, sans-serif; line-height: 24px; color: #bbbbbb; font-size: 13px; font-weight: normal; text-align: center; padding: 9px; border-width: 1px 0px 0px; border-style: solid; border-color: #e3e3e3; background-color: #f5f5f5;" valign="top">
				<a href="#" style="color: #428bca; text-decoration: none; background-color: transparent;">'.$site_footer.'</a>
				</td></tr></tbody></table>
				</td></tr></tbody></table>
				</td></tr></tbody></table>
				<table class="table-space" height="1" style="height: 1px; font-size: 0px; line-height: 0; width: 450px; background-color: #ffffff;" width="450" bgcolor="#FFFFFF" cellspacing="0" cellpadding="0" border="0"><tbody><tr><td class="table-space-td" valign="middle" height="1" style="height: 1px; width: 450px; background-color: #ffffff;" width="450" bgcolor="#FFFFFF" align="left">&nbsp;</td></tr></tbody></table>
				<table class="table-space" height="36" style="height: 36px; font-size: 0px; line-height: 0; width: 450px; background-color: #e4e6e9;" width="450" bgcolor="#E4E6E9" cellspacing="0" cellpadding="0" border="0"><tbody><tr><td class="table-space-td" valign="middle" height="36" style="height: 36px; width: 450px; background-color: #e4e6e9;" width="450" bgcolor="#E4E6E9" align="left">&nbsp;</td></tr></tbody></table></td></tr></table>
				</td></tr>
				</table>
				</body>
				</html>';
				//User Email
				$htmlmessageuser = '<!doctype html>
				<html xmlns="http://www.w3.org/1999/xhtml">
				<head>
				<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
				<meta name="viewport" content="initial-scale=1.0" />
				<meta name="format-detection" content="telephone=no" />
				<title></title>
				<style type="text/css">
				body {
				width: 100%;
				margin: 0;
				padding: 0;
				-webkit-font-smoothing: antialiased;
				}
				@media only screen and (max-width: 600px) {
				table[class="table-row"] {
				float: none !important;
				width: 98% !important;
				padding-left: 20px !important;
				padding-right: 20px !important;
				}
				table[class="table-row-fixed"] {
				float: none !important;
				width: 98% !important;
				}
				table[class="table-col"], table[class="table-col-border"] {
				float: none !important;
				width: 100% !important;
				padding-left: 0 !important;
				padding-right: 0 !important;
				table-layout: fixed;
				}
				td[class="table-col-td"] {
				width: 100% !important;
				}
				table[class="table-col-border"] + table[class="table-col-border"] {
				padding-top: 12px;
				margin-top: 12px;
				border-top: 1px solid #E8E8E8;
				}
				table[class="table-col"] + table[class="table-col"] {
				margin-top: 15px;
				}
				td[class="table-row-td"] {
				padding-left: 0 !important;
				padding-right: 0 !important;
				}
				table[class="navbar-row"] , td[class="navbar-row-td"] {
				width: 100% !important;
				}
				img {
				max-width: 100% !important;
				display: inline !important;
				}
				img[class="pull-right"] {
				float: right;
				margin-left: 11px;
				max-width: 125px !important;
				padding-bottom: 0 !important;
				}
				img[class="pull-left"] {
				float: left;
				margin-right: 11px;
				max-width: 125px !important;
				padding-bottom: 0 !important;
				}
				table[class="table-space"], table[class="header-row"] {
				float: none !important;
				width: 98% !important;
				}
				td[class="header-row-td"] {
				width: 100% !important;
				}
				}
				@media only screen and (max-width: 480px) {
				table[class="table-row"] {
				padding-left: 16px !important;
				padding-right: 16px !important;
				}
				}
				@media only screen and (max-width: 320px) {
				table[class="table-row"] {
				padding-left: 12px !important;
				padding-right: 12px !important;
				}
				}
				@media only screen and (max-width: 458px) {
				td[class="table-td-wrap"] {
				width: 100% !important;
				}
				}
				</style>
				</head>
				<body style="font-family: Arial, sans-serif; font-size:13px; color: #444444; min-height: 200px;" bgcolor="#E4E6E9" leftmargin="0" topmargin="0" marginheight="0" marginwidth="0">
				<table width="100%" height="100%" bgcolor="#E4E6E9" cellspacing="0" cellpadding="0" border="0">
				<tr><td width="100%" align="center" valign="top" bgcolor="#E4E6E9" style="background-color:#E4E6E9; min-height: 200px;">
				<table><tr><td class="table-td-wrap" align="center" width="458"><table class="table-space" height="18" style="height: 18px; font-size: 0px; line-height: 0; width: 450px; background-color: #e4e6e9;" width="450" bgcolor="#E4E6E9" cellspacing="0" cellpadding="0" border="0"><tbody><tr><td class="table-space-td" valign="middle" height="18" style="height: 18px; width: 450px; background-color: #e4e6e9;" width="450" bgcolor="#E4E6E9" align="left">&nbsp;</td></tr></tbody></table>
				<table class="table-space" height="8" style="height: 8px; font-size: 0px; line-height: 0; width: 450px; background-color: #ffffff;" width="450" bgcolor="#FFFFFF" cellspacing="0" cellpadding="0" border="0"><tbody><tr><td class="table-space-td" valign="middle" height="8" style="height: 8px; width: 450px; background-color: #ffffff;" width="450" bgcolor="#FFFFFF" align="left">&nbsp;</td></tr></tbody></table>
				<table class="table-row" width="450" bgcolor="#FFFFFF" style="table-layout: fixed; background-color: #ffffff;" cellspacing="0" cellpadding="0" border="0"><tbody><tr><td class="table-row-td" style="font-family: Arial, sans-serif; line-height: 19px; color: #444444; font-size: 13px; font-weight: normal; padding-left: 36px; padding-right: 36px;" valign="top" align="left">
				<table class="table-col" align="left" width="378" cellspacing="0" cellpadding="0" border="0" style="table-layout: fixed;"><tbody><tr><td class="table-col-td" width="378" style="font-family: Arial, sans-serif; line-height: 19px; color: #444444; font-size: 13px; font-weight: normal; width: 378px;" valign="top" align="left">
				<table class="header-row" width="378" cellspacing="0" cellpadding="0" border="0" style="table-layout: fixed;"><tbody><tr><td class="header-row-td" width="378" style="font-family: Arial, sans-serif; font-weight: normal; line-height: 19px; color: #478fca; margin: 0px; font-size: 18px; padding-bottom: 10px; padding-top: 15px;" valign="top" align="left">Thank you for contact '.$system_name.'</td></tr></tbody></table>
				<div style="font-family: Arial, sans-serif; line-height: 20px; color: #444444; font-size: 13px;">
				'.$msguser.'
				Thanks.
				</div>
				</td></tr></tbody></table>
				</td></tr></tbody></table>
				<table class="table-space" height="12" style="height: 12px; font-size: 0px; line-height: 0; width: 450px; background-color: #ffffff;" width="450" bgcolor="#FFFFFF" cellspacing="0" cellpadding="0" border="0"><tbody><tr><td class="table-space-td" valign="middle" height="12" style="height: 12px; width: 450px; background-color: #ffffff;" width="450" bgcolor="#FFFFFF" align="left">&nbsp;</td></tr></tbody></table>
				<table class="table-space" height="12" style="height: 12px; font-size: 0px; line-height: 0; width: 450px; background-color: #ffffff;" width="450" bgcolor="#FFFFFF" cellspacing="0" cellpadding="0" border="0"><tbody><tr><td class="table-space-td" valign="middle" height="12" style="height: 12px; width: 450px; padding-left: 16px; padding-right: 16px; background-color: #ffffff;" width="450" bgcolor="#FFFFFF" align="center">&nbsp;<table bgcolor="#E8E8E8" height="0" width="100%" cellspacing="0" cellpadding="0" border="0"><tbody><tr><td bgcolor="#E8E8E8" height="1" width="100%" style="height: 1px; font-size:0;" valign="top" align="left">&nbsp;</td></tr></tbody></table></td></tr></tbody></table>
				<table class="table-space" height="16" style="height: 16px; font-size: 0px; line-height: 0; width: 450px; background-color: #ffffff;" width="450" bgcolor="#FFFFFF" cellspacing="0" cellpadding="0" border="0"><tbody><tr><td class="table-space-td" valign="middle" height="16" style="height: 16px; width: 450px; background-color: #ffffff;" width="450" bgcolor="#FFFFFF" align="left">&nbsp;</td></tr></tbody></table>
				<table class="table-space" height="6" style="height: 6px; font-size: 0px; line-height: 0; width: 450px; background-color: #ffffff;" width="450" bgcolor="#FFFFFF" cellspacing="0" cellpadding="0" border="0"><tbody><tr><td class="table-space-td" valign="middle" height="6" style="height: 6px; width: 450px; background-color: #ffffff;" width="450" bgcolor="#FFFFFF" align="left">&nbsp;</td></tr></tbody></table>
				<table class="table-row-fixed" width="450" bgcolor="#FFFFFF" style="table-layout: fixed; background-color: #ffffff;" cellspacing="0" cellpadding="0" border="0"><tbody><tr><td class="table-row-fixed-td" style="font-family: Arial, sans-serif; line-height: 19px; color: #444444; font-size: 13px; font-weight: normal; padding-left: 1px; padding-right: 1px;" valign="top" align="left">
				<table class="table-col" align="left" width="448" cellspacing="0" cellpadding="0" border="0" style="table-layout: fixed;"><tbody><tr><td class="table-col-td" width="448" style="font-family: Arial, sans-serif; line-height: 19px; color: #444444; font-size: 13px; font-weight: normal;" valign="top" align="left">
				<table width="100%" cellspacing="0" cellpadding="0" border="0" style="table-layout: fixed;"><tbody><tr><td width="100%" align="center" bgcolor="#f5f5f5" style="font-family: Arial, sans-serif; line-height: 24px; color: #bbbbbb; font-size: 13px; font-weight: normal; text-align: center; padding: 9px; border-width: 1px 0px 0px; border-style: solid; border-color: #e3e3e3; background-color: #f5f5f5;" valign="top">
				<a href="#" style="color: #428bca; text-decoration: none; background-color: transparent;">'.$site_footer.'</a>
				</td></tr></tbody></table>
				</td></tr></tbody></table>
				</td></tr></tbody></table>
				<table class="table-space" height="1" style="height: 1px; font-size: 0px; line-height: 0; width: 450px; background-color: #ffffff;" width="450" bgcolor="#FFFFFF" cellspacing="0" cellpadding="0" border="0"><tbody><tr><td class="table-space-td" valign="middle" height="1" style="height: 1px; width: 450px; background-color: #ffffff;" width="450" bgcolor="#FFFFFF" align="left">&nbsp;</td></tr></tbody></table>
				<table class="table-space" height="36" style="height: 36px; font-size: 0px; line-height: 0; width: 450px; background-color: #e4e6e9;" width="450" bgcolor="#E4E6E9" cellspacing="0" cellpadding="0" border="0"><tbody><tr><td class="table-space-td" valign="middle" height="36" style="height: 36px; width: 450px; background-color: #e4e6e9;" width="450" bgcolor="#E4E6E9" align="left">&nbsp;</td></tr></tbody></table></td></tr></table>
				</td></tr>
				</table>
				</body>
				</html>';
				//Admin Email
				$config['charset'] = 'utf-8';
                $config['wordwrap'] = TRUE;
                $config['mailtype'] = 'html';
                $this->email->initialize($config);
                $this->email->from($from_email, $system_name);
                $this->email->to($to_email);
                $this->email->subject('Contact Details '.$system_name);
                $this->email->message($htmlmessage);
                $this->email->send();
				//User Email htmlmessageuser
				$config1['charset'] = 'utf-8';
                $config1['wordwrap'] = TRUE;
                $config1['mailtype'] = 'html';
                $this->email->initialize($config1);
                $this->email->from("contactus@discountslove.com", $system_name);
                $this->email->to($from_email);
                $this->email->subject('Contact Details '.$system_name);
                $this->email->message($htmlmessageuser);
                $this->email->send();
				echo "1";
			}
			else
			{
				echo "0";
			}
		}
		//subscribe / unsubscribe Email Start
		//subscribe submit
		public function subscribe_submit()
		{
			$this->load->helper('string');
			$random_code = random_string('alnum',18);
			$post_data = $this->input->post();
			$get_email = $this->Mdl_frontend->get_relation_pax_email('gg_subscribe','email','email',$post_data['join']);
			//print_r($get_email);
			//exit;
			if(!empty($get_email))
			{
				$data = array(           
				//'email' => $post_data['join'],         
				'ip_address' => $this->input->ip_address(),
				'is_subscribe' => 1,
				'updated' => date('Y-m-d H:i:s'),
				);
				$this->db->where('email',$post_data['join']);
				$upd = $this->db->update('gg_subscribe', $data);
				//echo "1";
				if($upd)
				{
					echo "2";				
				}
				else
				{
					echo "0";
				}
			}
			else
			{
				$data = array(           
				'email' => $post_data['join'],         
				//'random_code' => $random_code,         
				'ip_address' => $this->input->ip_address(),
				'is_subscribe' => 1,
				);
				$ins1 = $this->db->insert('gg_subscribe', $data);
				//echo "1";
				if($ins1)
				{
					echo "1";				
				}
				else
				{
					echo "0";
				}
			}
		}
		//UnSubcribe Email
		public function unsubscribe($key)
		{
			$this->db->where('random_code',$key);
			$user_email = $this->db->get('gg_subscribe')->result();
			if (count($user_email) > 0)
			{
				$this->data['random_code'] = $key;
				$this->data['subscribe_id'] = $user_email[0]->id;
				$this->data['subscribe_email'] = $user_email[0]->email;
				$this->data['is_subscribe'] = $user_email[0]->is_subscribe;
				$this->load->view('unsubscribe',$this->data);
			}
			else
			{
				redirect(base_url().'_404_page.html','refresh');
			}
		}
		//Reset Password Submit
		public function unsubscribe_submit()
		{
			$post_data = $this->input->post();
			/*  print_r($post_data);
			exit; */
			$data = array(           
			'random_code' => '',         
			'ip_address' => $this->input->ip_address(),
			'is_subscribe' =>0,
			'updated' => date('Y-m-d H:i:s'),
			);
			$this->db->where('id',$post_data['subscribe_id']);
			$db_command = $this->db->update('gg_subscribe', $data);
			if(!empty($db_command))
			{
				$this->session->set_flashdata('saved', 'your have successfully unsubscribe email address');
				redirect(base_url(),'refresh');
			}
			else
			{
				$this->session->set_flashdata('error', 'your have not successfully unsubscribe email address');
				redirect(base_url()."unsubscribe/".$post_data['subscribe_key'],'refresh');
			}
		}
		//unsubscribe / unsubscribe Email END
		//privacy_policy Page
		public function privacy_policy()
		{
			$page_data = $this->Mdl_frontend->_get_pages_list('privacy_policy');
			//For privacy_policy
			if(!empty($page_data))
			{
				$this->data['privacy_policy_title'] = $page_data[0]->title;
				$this->data['privacy_policy_desc'] = $page_data[0]->long_description;
				$this->data['is_privacy_policy'] = 1;
			}
			$this->load->view('privacy_policy',$this->data);
		}
		//terms_and_condition Page
		public function terms_and_condition()
		{
			$page_data = $this->Mdl_frontend->_get_pages_list('terms_and_condition');
			//For terms_and_condition
			if(!empty($page_data))
			{
				$this->data['terms_and_condition_title'] = $page_data[0]->title;
				$this->data['terms_and_condition_desc'] = $page_data[0]->long_description;
				$this->data['is_terms_and_condition'] = 1;
			}
			$this->load->view('terms_and_condition',$this->data);
		}
		//cookies Page
		public function cookies()
		{
			$page_data = $this->Mdl_frontend->_get_pages_list('cookies');
			//For cookies
			if(!empty($page_data))
			{
				$this->data['cookies_title'] = $page_data[0]->title;
				$this->data['cookies_desc'] = $page_data[0]->long_description;
				$this->data['is_cookies'] = 1;
			}
			$this->load->view('cookies',$this->data);
		}
		//sitemap Page
		public function sitemap()
		{
			$mystores = array();
			//Show All Categories Wise Store In 0-9
			foreach (range('0', '9') as $mychar) 
			{
				$m_category_store2 = $this->Mdl_frontend->_get_all_stores_list($mychar);
				if(!empty($m_category_store2))
				{
					$mystores[$mychar] = $m_category_store2;
				}
			}
			$this->data['result_mystores']  = $mystores;
			//Right Side Bar Similar Categories
			$morder = array('cate_id'=>'desc');
			$getRec = $this->Mdl_frontend->_get_similar_category_list('8',$morder);
			$this->data['result_count_cat']  = count($getRec);
			$this->data['result_set_cat']  = $getRec;
			$store_array = array();
			foreach($getRec as $res1)
			{
				$morder22 = array('store_priority'=>'desc');
				$m_category_store11 = $this->Mdl_frontend->_get_category_store_list($res1->cate_id,40,'no',$morder22);
				$store_array[$res1->cate_id] = $m_category_store11;
			}
			$this->data['result_mystores1']  = $store_array;
			//Right Side Bar Banner
			$this->data['is_right_side_banner1'] = $this->Mdl_frontend->_get_pages_list('right_side_banner');
			$this->load->view('sitemap',$this->data);
		}
		//allstores Page
		public function allstores()
		{
			$mystores = array();
			$mystores_az = array();
			//Show All Categories Wise Store In 0-9
			foreach (range('0', '9') as $mychar) 
			{
				$m_category_store2 = $this->Mdl_frontend->_get_all_stores_list($mychar);
				if(!empty($m_category_store2))
				{
					$mystores[$mychar] = $m_category_store2;
				}
			}
			$this->data['result_mystores']  = $mystores;
			//Show All Categories Wise Store In A-Z
			foreach (range('A', 'Z') as $mychar1) 
			{
				$m_category_store21 = $this->Mdl_frontend->_get_all_stores_list($mychar1);
				if(!empty($m_category_store21))
				{
					$mystores_az[$mychar1] = $m_category_store21;
				}
			}
			$this->data['result_mystores_az']  = $mystores_az;
			//Right Side Bar Similar Categories
			$morder = array('cate_id'=>'desc');
			$getRec = $this->Mdl_frontend->_get_similar_category_list('8',$morder);
			$this->data['result_count_cat']  = count($getRec);
			$this->data['result_set_cat']  = $getRec;
			$store_array = array();
			foreach($getRec as $res1)
			{
				$morder22 = array('store_priority'=>'desc');
				$m_category_store11 = $this->Mdl_frontend->_get_category_store_list($res1->cate_id,40,'no',$morder22);
				$store_array[$res1->cate_id] = $m_category_store11;
			}
			$this->data['result_mystores1']  = $store_array;
			//Right Side Bar Banner
			$this->data['is_right_side_banner1'] = $this->Mdl_frontend->_get_pages_list('right_side_banner');
			$this->load->view('all_stores',$this->data);
		}
		//single sitemap Page
		public function single_sitemap()
		{
			$sitemap_slug = $this->uri->segment(2);
			if(!empty($sitemap_slug))
			{
				//echo $sitemap_slug."<br/>";
				$slug = str_replace("voucher-codes-", "", $sitemap_slug);
				//Right Side Bar Similar Categories
				$morder = array('cate_id'=>'desc');
				$getRec = $this->Mdl_frontend->_get_similar_category_list('8',$morder);
				$this->data['result_count_cat']  = count($getRec);
				$this->data['result_set_cat']  = $getRec;
				$this->data['my_slug']  = $slug;
				$store_array = array();
			foreach($getRec as $res1)
			{
				$morder22 = array('store_priority'=>'desc');
				$m_category_store11 = $this->Mdl_frontend->_get_category_store_list($res1->cate_id,40,'no',$morder22);
				$store_array[$res1->cate_id] = $m_category_store11;
			}
			$this->data['result_mystores1']  = $store_array;
				$m_category_store1 = $this->Mdl_frontend->_get_all_stores_list($slug);
				$this->data['result_count_store']  = count($m_category_store1);
				$this->data['result_set_store']  = $m_category_store1;
				//Right Side Bar Banner
				$this->data['is_right_side_banner1'] = $this->Mdl_frontend->_get_pages_list('right_side_banner');
				$mystores = array();
				//Show All Categories Wise Store In 0-9
				foreach (range('0', '9') as $mychar) 
				{
					$m_category_store2 = $this->Mdl_frontend->_get_all_stores_list($mychar);
					if(!empty($m_category_store2))
					{
						$mystores[$mychar] = $m_category_store2;
					}
				}
				//ALL STORES 0-9
				$this->data['result_mystores']  = $mystores;		
				$this->load->view('single_sitemap',$this->data);
			}
			else
			{
				redirect(base_url().'_404_page.html','refresh');
			} 
		}
		//events Page
		public function events()
		{
			$page_data = $this->Mdl_frontend->_get_pages_list('right_side_banner');
			//For right_side_banner
			if(!empty($page_data))
			{
				$this->data['right_side_banner_title'] = $page_data[0]->title;
				$this->data['right_side_banner_desc'] = $page_data[0]->long_description;
				$this->data['right_side_banner_image'] = $page_data[0]->pages_image;
				$this->data['is_right_side_banner'] = 1;
			}
			//Categories
			$morder = array('cate_id'=>'desc');
			$getRec = $this->Mdl_frontend->_get_similar_category_list('12',$morder);
			$this->data['result_count_cat']  = count($getRec);
			$this->data['result_set_cat']  = $getRec;
			$store_array = array();
			foreach($getRec as $res1)
			{
				$morder22 = array('store_priority'=>'desc');
				$m_category_store11 = $this->Mdl_frontend->_get_category_store_list($res1->cate_id,40,'no',$morder22);
				$store_array[$res1->cate_id] = $m_category_store11;
			}
			$this->data['result_mystores1']  = $store_array;
			//All Event List
			$morder1 = array('event_id'=>'desc');
			$getRec1 = $this->Mdl_frontend->_get_event_list('',$morder1);
			$this->data['result_count_event']  = count($getRec1);
			$this->data['result_set_event']  = $getRec1;
			$this->load->view('events',$this->data);
		}
		//single_event
		public function single_event()
		{
			$slug = $this->uri->segment(2);
			if(!empty($slug))
			{
				//Single Category
				$where_sys = array(
				'event_slug' => $slug,
				'is_enable' => '1',
				);
				$getRec = $this->Mdl_frontend->check_already_exists_multiple('event_list','seo_title,seo_description,event_id,event_slug,event_keyword,event_banner,event_long_desc,event_desc,event_title',$where_sys,4);
				//print_r($getRec);
				if(empty($slug) || $getRec[1]['count'] == 0)
				{
					redirect(base_url().'_404_page.html','refresh');
				}
				else
				{
					//$event_keywords = $getRec[2]['Query_result'][0]->event_keyword;
					$mysearch = "";
					//Check Keywords Exists
					if(!empty($getRec[2]['Query_result'][0]->event_keyword))
					{
						$event_keyword = explode(",",strtolower($getRec[2]['Query_result'][0]->event_keyword));
						//print_r($event_keyword);
						//$event_keyword_final = implode(" ",$event_keyword);
						/* $key_count = count($event_keyword);
							$ei = 1;
							foreach($event_keyword as $ev)
							{
							$mysearch .= " gg_coupons.coupon_title LIKE '%$ev%'";
							if($ei == $key_count)
							{
							}
							else
							{
							$mysearch .= " or";
							}
							$ei++;
						} */
					}
					else
					{	
						//$ev_slug = strtolower($getRec[2]['Query_result'][0]->event_slug);
						//$mysearch .= " gg_coupons.coupon_title LIKE '%$ev_slug%'";
					}
					//echo $mysearch;
					$getCoupon = $this->Mdl_frontend->event_search_stores_offers($event_keyword);					
					//GET STORES IDs
					if(!empty($getCoupon))
					{					
						$store_ids = '';
						$store_array = array();
						for($i=0; $i<count($getCoupon);$i++){
							$store_array[] = $getCoupon[$i]->store_id; 
						}
						$final_dd = array_unique($store_array);			
						$store_ids = implode(',',$final_dd);			
						$getEventStores = $this->Mdl_frontend->_get_single_event_store_list($store_ids,'8');    
						$this->data['result_count_fstore']  = count($getEventStores);
						$this->data['result_set_fstore']  = $getEventStores;
					}
					//Similar Events
					$morder1 = array('event_id'=>'desc');
					$getRec2 = $this->Mdl_frontend->_get_similar_event_list('12',$morder1,$getRec[2]['Query_result'][0]->event_id);
					$this->data['result_count_similar_event']  = count($getRec2);
					$this->data['result_set_similar_event']  = $getRec2;					
					$this->data['result_count_event']  = $getRec[1]['count'];
					$this->data['result_set_event']  = $getRec[2]['Query_result'];
					$this->data['result_count_coupon']  = count($getCoupon);
					$this->data['result_set_coupon']  = $getCoupon;
					$this->data['is_right_side_banner1'] = $this->Mdl_frontend->_get_pages_list('right_side_banner');
					$this->load->view('single_event',$this->data);
				}	
			}
			else
			{
				redirect(base_url().'_404_page.html','refresh');
			}
		}
		//categories Page
		public function categories()
		{
			$getRec = $this->Mdl_frontend->_get_parent_category_list();
			$store_array = array();
			foreach($getRec as $res)
			{
				$morder = array('store_priority'=>'desc');
				$m_category_store = $this->Mdl_frontend->_get_category_store_list($res->cate_id,40,'yes',$morder);
				$store_array[$res->cate_id] = $m_category_store;
			}
			$this->data['result_mystores']  = $store_array;
			$this->data['result_count']  = count($getRec);
			$this->data['result_set']  = $getRec;
			$this->load->view('categories',$this->data);
		}
		//single_store
		public function single_store()
		{
			//echo $this->thousandsCurrencyFormat('9550000');
			$slug = $this->uri->segment(2);
			if(!empty($slug))
			{
				$where_sys = array(
				'slug' => $slug,
				'is_active' => 'enable',
				);
				$getRec = $this->Mdl_frontend->check_already_exists_multiple('gg_stores','store_name,store_id,parent_cate_id,slug,store_logo,tracking_url,store_summary,store_desc',$where_sys,4);
				//print_r($getRec);
				if(empty($slug) || $getRec[1]['count'] == 0)
				{
					redirect(base_url().'_404_page.html','refresh');
				}
				else
				{
					//Stores Coupons
					$morder11 = array('gg_coupons.coupon_priority'=>'desc');
					$m_store_coupon = $this->Mdl_frontend->_get_single_store_coupons_list($getRec[2]['Query_result'][0]->store_id,$morder11);
					//Total Views Count
					$m_total_views = $this->Mdl_frontend->_get_total_views_coupons_list($getRec[2]['Query_result'][0]->store_id);
					//print_r($m_total_views[0]->is_views);
					//Expired Stores Coupons
					$morder11 = array('gg_coupons.coupon_expiry'=>'desc');
					$m_store_coupon_exp = $this->Mdl_frontend->_get_single_store_expire_coupons_list($getRec[2]['Query_result'][0]->store_id,$morder11);
					//Similar Category
					$morder = array('cate_id'=>'desc');
					$getRec1 = $this->Mdl_frontend->_get_similar_category_list('8',$morder);
					$this->data['result_count_cat']  = count($getRec1);
					$this->data['result_set_cat']  = $getRec1;
					
					
					//print_r($getRec1);
				//	exit;
				
			$store_array = array();
			foreach($getRec1 as $res1)
			{
				$morder22 = array('store_priority'=>'desc');
				$m_category_store11 = $this->Mdl_frontend->_get_category_store_list($res1->cate_id,40,'no',$morder22);
				$store_array[$res1->cate_id] = $m_category_store11;
			}
			$this->data['result_mystores1']  = $store_array;
			
			
					
					
					//Similar Stores
					$morder = array('store_priority'=>'desc');
					$getRec2 = $this->Mdl_frontend->_get_similar_stores_list('16',$morder,$getRec[2]['Query_result'][0]->parent_cate_id,$getRec[2]['Query_result'][0]->store_id);
					$this->data['result_count_similar_store']  = count($getRec2);
					$this->data['result_set_similar_store']  = $getRec2;
					$this->data['result_count_store']  = $getRec[1]['count'];
					$this->data['result_set_store']  = $getRec[2]['Query_result'];
					$this->data['result_count_coupon']  = count($m_store_coupon);
					$this->data['result_set_coupon']  = $m_store_coupon;
					$last_updated = strtotime(@$m_store_coupon[0]->created);
					for($i=0; $i<count($m_store_coupon); $i++){
						if(strtotime($m_store_coupon[$i]->created) > $last_updated)
						{
							$last_updated = strtotime($m_store_coupon[$i]->created);
						}
					}
					$this->data['last_updated'] = date('d-F-Y',$last_updated);
					if(!empty($m_store_coupon))
					{
				    	$this->data['total_views']  = $this->Mdl_frontend->thousandsCurrencyFormat($m_total_views[0]->is_views);	    
					}
					else
					{
					    $this->data['total_views'] = 0;
					}
					$this->data['result_count_coupon_exp']  = count($m_store_coupon_exp);
					$this->data['result_set_coupon_exp']  = $m_store_coupon_exp;
					//Get Store Category						
					$where_sys = array(
					'cate_id' => $getRec[2]['Query_result'][0]->parent_cate_id,
					'is_active' => '1',
					);
					$getRecCat = $this->Mdl_frontend->check_already_exists_multiple('gg_categories','category,cate_slug',$where_sys,4);
					$this->data['result_store_category'] = $getRecCat[2]['Query_result'];
					//GET STATIC OFFERS---
					$this->data['result_set_static_offers']  = $this->Mdl_frontend->_get_static_coupons_list('999999999');
					$this->data['result_count_static_offers']  = count($this->data['result_set_static_offers']);
					
					//Similar Vouchers
					$morder11 = array('gg_coupons.coupon_priority'=>'desc');
					$m_category_coupon = $this->Mdl_frontend->_get_single_coupons_by_category_list($getRec[2]['Query_result'][0]->parent_cate_id,$morder11,2);
					$this->data['m_category_coupon']  = $m_category_coupon;
					
					
					
					$this->load->view('single_store',$this->data);
				}	
			}
			else
			{
				redirect(base_url().'_404_page.html','refresh');
			}
		}
		//single_category
		public function single_category()
		{
			$slug = $this->uri->segment(2);
			if(!empty($slug))
			{
				//Single Category
				$where_sys = array(
				'cate_slug' => $slug,
				'is_active' => '1',
				);
				$getRec = $this->Mdl_frontend->check_already_exists_multiple('gg_categories','cate_id,category,cate_slug,category_long_desc,category_desc',$where_sys,4);
				//print_r($getRec);
				if(empty($slug) || $getRec[1]['count'] == 0)
				{
					redirect(base_url().'_404_page.html','refresh');
				}
				else
				{
					//Stores Coupons
					/* $morder11 = array('gg_coupons.coupon_priority'=>'desc');
						$m_store_coupon = $this->Mdl_frontend->_get_single_store_coupons_list($getRec[2]['Query_result'][0]->store_id,$morder11);
					*/
					//Similar Category
					$morder = array('cate_id'=>'desc');
					$getRec1 = $this->Mdl_frontend->_get_similar_category_list('8',$morder);
					$this->data['result_count_cat']  = count($getRec1);
					$this->data['result_set_cat']  = $getRec1;
					$store_array = array();
			foreach($getRec1 as $res1)
			{
				$morder22 = array('store_priority'=>'desc');
				$m_category_store11 = $this->Mdl_frontend->_get_category_store_list($res1->cate_id,40,'no',$morder22);
				$store_array[$res1->cate_id] = $m_category_store11;
			}
			$this->data['result_mystores1']  = $store_array;
					//Similar Tags
					$morder = array('tags_name'=>'asc');
					$getRec12 = $this->Mdl_frontend->_get_similar_category_tags_list('',$morder,$getRec[2]['Query_result'][0]->cate_id);
					$this->data['result_count_tags']  = count($getRec12);
					$this->data['result_set_tags']  = $getRec12;
					//Similar Stores
					$morder = array('store_priority'=>'desc');
					$getRec2 = $this->Mdl_frontend->_get_similar_stores_list('24',$morder,$getRec[2]['Query_result'][0]->cate_id,"");
					$this->data['result_count_similar_store']  = count($getRec2);
					$this->data['result_set_similar_store']  = $getRec2;
					$this->data['result_count_category']  = $getRec[1]['count'];
					$this->data['result_set_category']  = $getRec[2]['Query_result'];
					//GEt Categories Wise Offers List
					$store_array = array();
					$where_vcat = array( 'is_active' => 'enable','parent_cate_id' => $getRec[2]['Query_result'][0]->cate_id);
					$result_vcat = $this->Mdl_frontend->check_already_exists_multiple('gg_stores','store_id,store_name,slug,store_logo',$where_vcat,4);
					if($result_vcat[1]['count'] > 0)
					{
						$mycat = 0;
						foreach($result_vcat[2]['Query_result'] as $mycat_store)
						{
							if($mycat > 19)
							{
								break;
							}
							$mycat++;
							$morder11 = array('gg_coupons.coupon_priority'=>'desc');
							$result_set_coupon = $this->Mdl_frontend->_get_store_coupons_list($mycat_store->store_id,1,$morder11,"");
							//Show Coupons Data
							$store_array[$mycat_store->store_id] = $result_set_coupon;
						}
					}
					//** Related Categories Stores Pagination Start **//
					$this->load->library('pagination');
					$total_rows = $this->Mdl_frontend->total_categories_stores($getRec[2]['Query_result'][0]->cate_id);
					$config['total_rows'] = $total_rows;
					$config['base_url'] = base_url()."discounts/".$slug."/page";
					$config['per_page'] = 40;
					$config['first_url'] = 1;
					//$config['uri_segment'] = '4';
					$config['use_page_numbers'] = TRUE;
					$config['full_tag_open'] = '<div class="pagination">';
					$config['full_tag_close'] = '</div>';
					$config['first_link'] = '« First';
					$config['first_tag_open'] = '';
					$config['first_tag_close'] = '';
					$config['last_link'] = 'Last »';
					$config['last_tag_open'] = '';
					$config['last_tag_close'] = '';
					$config['next_link'] = 'Next';
					$config['next_tag_open'] = '';
					$config['next_tag_close'] = '';
					$config['prev_link'] = 'Previous';
					$config['prev_tag_open'] = '';
					$config['prev_tag_close'] = '';
					$config['cur_tag_open'] = '<p>';
					$config['cur_tag_close'] = '</p>';
					$config['num_tag_open'] = '';
					$config['num_tag_close'] = '';
					//	$config['query_string_segment'] = 'offset';
					//$config['page_query_string'] = TRUE;
					/* if(!empty($total_rows))
					{ */
					/* } */
					$this->pagination->initialize($config);
					$page = ($this->uri->segment(4)) ? ($this->uri->segment(4) - 1) : 0;
					$query = $this->Mdl_frontend->get_total_categories_stores($getRec[2]['Query_result'][0]->cate_id,$config["per_page"], ($config["per_page"] * $page));
					$this->data['result_mystores_category'] = null;
					if($query)
					{
						$this->data['result_mystores_category'] =  $query;
					}
					//$config['links'] = $this->pagination->create_links();
					//** Related Categories Stores Pagination End **// 	
					$this->data['result_mystores']  = $result_vcat[2]['Query_result'];
					//For Pagination URL
					if(!empty($this->uri->segment(3)) && !empty($this->uri->segment(4)))
					{
						$this->data['my_url']  = base_url()."discounts/".strtolower($slug)."/".$this->uri->segment(3)."/".$this->uri->segment(4);
						$this->data['my_title']  = $this->uri->segment(4);
					}
					else
					{
						$this->data['my_url']  = base_url()."discounts/".strtolower($slug);
					}
					$this->data['result_mystores_offers']  = $store_array;
					$this->load->view('single_category',$this->data);
				}
			}
			else
			{
				redirect(base_url().'_404_page.html','refresh');
			}
		}
		//Pagination Stores List Single Category Page
		function ajax_category_stores_list($page)
		{
			$conditions = array();
			$page = $this->input->post('page');
			if(!$page){
				$offset = 0;
				}else{
				$offset = $page;
			}
			$post = $this->input->post();
			$cat_id = @$post['cat_id'];
			if(!empty($cat_id))
			{
				$conditions['search']['cat_id'] = $cat_id;
			}
			if($this->Mdl_frontend->getRowsStores($conditions) == 0)
			{
				$totalRec = 0;
			}
			else
			{
				$totalRec = count($this->Mdl_frontend->getRowsStores($conditions));
			}
			$config['target']      = '#ajax_search_stores';
			$config['base_url']    = base_url().'pagination/category-stores-list';
			$config['total_rows']  = $totalRec;
			$config['per_page']    = $this->perPageStore;
			$config['link_func']   = 'searchFilterStores';
			$this->ajax_pagination->initialize($config);
			//print_r($config);
			//exit;
			$conditions['start'] = $offset;
			$conditions['limit'] = $this->perPageStore;
			$this->data['result_set_store'] = $this->Mdl_frontend->getRowsStores($conditions);
			$this->load->view('ajax_category_stores_list',$this->data);
		}
		//special_page_restaurant
		public function special_page_restaurant()
		{
			$final_slug = "restaurant";			
			//$final_slug = str_replace("-discount-codes", "", $slug);			
			if(!empty($final_slug))
			{
				$mysearch = " gg_coupons.coupon_title LIKE '%$final_slug%'";
				$mylimit = "ORDER BY gg_coupons.coupon_priority DESC LIMIT 50";
				//echo $mysearch;
				$getCoupon = $this->Mdl_frontend->_get_single_special_coupons_list($mysearch,$mylimit);
				//GET STORES IDs
				if(!empty($getCoupon))
				{					
					$store_ids = '';
					$store_array = array();
					for($i=0; $i<count($getCoupon);$i++){
						$store_array[] = $getCoupon[$i]->store_id; 
					}
					$final_dd = array_unique($store_array);			
					$store_ids = implode(',',$final_dd);			
					$getEventStores = $this->Mdl_frontend->_get_single_event_store_list($store_ids,'30');    
					//Similar Stores
					$this->data['result_count_fstore']  = count($getEventStores);
					$this->data['result_set_fstore']  = $getEventStores;
				}	
				$this->data['result_count_coupon']  = count($getCoupon);
				$this->data['result_set_coupon']  = $getCoupon;
				//Similar Category
				$morder = array('cate_id'=>'desc');
				$getRec1 = $this->Mdl_frontend->_get_similar_category_list('8',$morder);
				$this->data['result_count_cat']  = count($getRec1);
				$this->data['result_set_cat']  = $getRec1;
				$this->data['final_slug']  = $final_slug;
				$store_array = array();
			foreach($getRec1 as $res1)
			{
				$morder22 = array('store_priority'=>'desc');
				$m_category_store11 = $this->Mdl_frontend->_get_category_store_list($res1->cate_id,40,'no',$morder22);
				$store_array[$res1->cate_id] = $m_category_store11;
			}
			$this->data['result_mystores1']  = $store_array;
				//Restaurant Content
				$page_data = $this->Mdl_frontend->_get_pages_list('restaurant_page_info');
				//For restaurant_page_info
				if(!empty($page_data))
				{
					$this->data['restaurant_title'] = $page_data[0]->title;
					$this->data['restaurant_desc'] = $page_data[0]->long_description;
					$this->data['is_restaurant'] = 1;
				}
				$this->load->view('special_page_restaurant',$this->data);
			}
			else
			{
				redirect(base_url().'_404_page.html','refresh');
			}
		}
		//special_page_student
		public function special_page_student()
		{
			$final_slug = "student";			
			//$final_slug = str_replace("-discount-codes", "", $slug);			
			if(!empty($final_slug))
			{
				$mysearch = " gg_coupons.coupon_title LIKE '%$final_slug%'";
				$mylimit = "ORDER BY gg_coupons.coupon_priority DESC LIMIT 50";
				//echo $mysearch;
				$getCoupon = $this->Mdl_frontend->_get_single_special_coupons_list($mysearch,$mylimit);
				//GET STORES IDs
				if(!empty($getCoupon))
				{					
					$store_ids = '';
					$store_array = array();
					for($i=0; $i<count($getCoupon);$i++){
						$store_array[] = $getCoupon[$i]->store_id; 
					}
					$final_dd = array_unique($store_array);			
					$store_ids = implode(',',$final_dd);			
					$getEventStores = $this->Mdl_frontend->_get_single_event_store_list($store_ids,'30');    
					//Similar Stores
					$this->data['result_count_fstore']  = count($getEventStores);
					$this->data['result_set_fstore']  = $getEventStores;
				}	
				$this->data['result_count_coupon']  = count($getCoupon);
				$this->data['result_set_coupon']  = $getCoupon;
				//Similar Category
				$morder = array('cate_id'=>'desc');
				$getRec1 = $this->Mdl_frontend->_get_similar_category_list('8',$morder);
				$this->data['result_count_cat']  = count($getRec1);
				$this->data['result_set_cat']  = $getRec1;
				$this->data['final_slug']  = $final_slug;
				$store_array = array();
			foreach($getRec1 as $res1)
			{
				$morder22 = array('store_priority'=>'desc');
				$m_category_store11 = $this->Mdl_frontend->_get_category_store_list($res1->cate_id,40,'no',$morder22);
				$store_array[$res1->cate_id] = $m_category_store11;
			}
			$this->data['result_mystores1']  = $store_array;
				//Student Content
				$page_data = $this->Mdl_frontend->_get_pages_list('student_page_info');
				//For student_page_info
				if(!empty($page_data))
				{
					$this->data['student_title'] = $page_data[0]->title;
					$this->data['student_desc'] = $page_data[0]->long_description;
					$this->data['is_student'] = 1;
				}
				$this->load->view('special_page_student',$this->data);
			}
			else
			{
				redirect(base_url().'_404_page.html','refresh');
			}
		}
		//tags_page
		public function tags_page()
		{
			$slug = $this->uri->segment(1);			
			$final_slug = str_replace("-deals", "", $slug);	
			//Single Category By 
			$where_sys = array(
			'tags_slug' => $final_slug,
			'is_enable' => '1',
			);
			$getRec = $this->Mdl_frontend->check_already_exists_multiple('gg_categories_tags_list','category_id,tags_name',$where_sys,4);
			//print_r($getRec);
			if(empty($final_slug) || $getRec[1]['count'] == 0)
			{
				redirect(base_url().'_404_page.html','refresh');
			}
			else
			{
				$search_val = strtolower($getRec[2]['Query_result'][0]->tags_name);
				$mysearch = "";
				$tags_keyword = explode("-",strtolower($final_slug));
				$tags_final = implode(" ",$tags_keyword);
				//print_r($tags_final);
				/* $key_count = count($tags_keyword);
					$ei = 1;
					foreach($tags_keyword as $ev)
					{
					$mysearch .= " gg_coupons.coupon_title LIKE '%$ev%'";
					if($ei == $key_count)
					{
					}
					else
					{
					$mysearch .= " or";
					}
					$ei++;
				} */
				//$mysearch = " gg_coupons.coupon_title LIKE '%$search_val%'";
				//$mylimit = "ORDER BY gg_coupons.coupon_priority DESC LIMIT 100";
				//echo $mysearch;
				$getCoupon = $this->Mdl_frontend->get_total_search_stores_offers($tags_final,100,0);
				//GET STORES IDs
				if(!empty($getCoupon))
				{					
					$store_ids = '';
					$store_array = array();
					for($i=0; $i<count($getCoupon);$i++){
						$store_array[] = $getCoupon[$i]->store_id; 
					}
					$final_dd = array_unique($store_array);			
					$store_ids = implode(',',$final_dd);			
					$getEventStores = $this->Mdl_frontend->_get_single_event_store_list($store_ids,'30');    
					//Similar Stores
					$this->data['result_count_fstore']  = count($getEventStores);
					$this->data['result_set_fstore']  = $getEventStores;
				}	
				$this->data['result_count_coupon']  = count($getCoupon);
				$this->data['result_set_coupon']  = $getCoupon;
				//Similar Tags
				$morder1 = array('tags_name'=>'asc');
				$getRec12 = $this->Mdl_frontend->_get_similar_category_tags_list('100',$morder1,$getRec[2]['Query_result'][0]->category_id);
				$this->data['result_count_tags']  = count($getRec12);
				$this->data['result_set_tags']  = $getRec12;
				//Similar Category
				$morder2 = array('cate_id'=>'desc');
				$getRec1 = $this->Mdl_frontend->_get_similar_category_list('8',$morder2);
				$this->data['result_count_cat']  = count($getRec1);
				$this->data['result_set_cat']  = $getRec1;
				$this->data['final_slug']  = str_replace("-"," ",$final_slug);
				$this->data['final_slug_url']  = $final_slug;
				$this->data['category_id']  = $getRec[2]['Query_result'][0]->category_id;
				$store_array = array();
			foreach($getRec1 as $res1)
			{
				$morder22 = array('store_priority'=>'desc');
				$m_category_store11 = $this->Mdl_frontend->_get_category_store_list($res1->cate_id,40,'no',$morder22);
				$store_array[$res1->cate_id] = $m_category_store11;
			}
			$this->data['result_mystores1']  = $store_array;
				//Category Name & Slug.
				$where_sys1 = array(
				'cate_id' => $getRec[2]['Query_result'][0]->category_id,
				'is_active' => '1',
				);
				$getRec1 = $this->Mdl_frontend->check_already_exists_multiple('gg_categories','cate_id,category,cate_slug,category_long_desc,category_desc',$where_sys1,4);
				$this->data['result_set_category'] = $getRec1[2]['Query_result'];
				$this->load->view('tags_page',$this->data);
			}
		}
	}			