<?php
	defined('BASEPATH') OR exit('No direct script access allowed');
	
	class API extends MX_Controller {
		
		/**
			* Index Page for this controller.
			*
			* Maps to the following URL
			* 		http://example.com/index.php/welcome
			*	- or -
			* 		http://example.com/index.php/welcome/index
			*	- or -
			* Since this controller is set as the default controller in
			* config/routes.php, it's displayed at http://example.com/
			*
			* So any other public methods not prefixed with an underscore will
			* map to /index.php/welcome/<method_name>
			* @see http://codeigniter.com/user_guide/general/urls.html
		*/
		function __construct() {
			parent::__construct();
			
			// Load member model
			$this->load->model('Mdl_api');
			Modules::run('Login/_login');
		}
		public function index()
		{
			redirect(base_url().'_404_page.html','refresh');
		}
		//////////////////////////////////////////////////////////////
		/////////////////// CJ API //////////////////////////////////
		/////////////////////////////////////////////////////////////
		
		//CJ API
		public function cj_api_coupons()
		{
			$data['content']  = 'API/cj_api_coupons';
			$this->load->view('Template/template',$data);
			
		}
		
		//API TESTING
		public function cj_api_coupons_submit()
		{
			$post = $this->input->post();
			$records_per_page = $post['records_per_page'];
			$page_number1 = $post['page_number'];
			$url = "https://link-search.api.cj.com/v2/link-search?website-id=9110558&link-type=text%20link&advertiser-ids=joined&records-per-page=".$records_per_page."&page-number=".$page_number1."&promotion-type=coupon";
			
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Contect-Type:application/xml', 'Accept:application/xml','Authorization: Bearer 1c3z3yjms97kmjhsj50x9kf8mq'));
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl,CURLOPT_RETURNTRANSFER,true);
			curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
			
			// Excecuting the curl call
			$result =  curl_exec($curl);
			
			// Close the Curl resource
			curl_close($curl);
			
			$xml = simplexml_load_string($result);
			$json = json_encode($xml);
			$result= json_decode($json, true);
			
			
			$count = 0;
			if(isset($result['links']['link']) && $result['links']['link']!=array())
			{
				
				$total_matched = $result['links']['@attributes']['total-matched'];
				$records_returned = $result['links']['@attributes']['records-returned'];
				$page_number = $result['links']['@attributes']['page-number'];
				$message = '<br/>Success: Coupons Record Successfully Found.<br/>Total Rows ('.$total_matched.')<br/>Record Per Page ('.$records_returned.')<br/>Page Number ('.$page_number.')';
				$data['result']  =  $message;
				$data['records_per_page']  =  $records_per_page;
				$data['page_number']  =  $page_number1;
				$data['content']  = 'API/cj_api_coupons';
				$this->load->view('Template/template',$data);
			}
			else
			{
				
				if(!empty($result['error-message']))
				{
					$message = "Error: ".$result['error-message'];
				}
				else
				{
					$total_matched = $result['links']['@attributes']['total-matched'];
					$records_returned = $result['links']['@attributes']['records-returned'];
					$page_number = $result['links']['@attributes']['page-number'];
					$message = '<br/>Success: Coupons Record Successfully Found.<br/>Total Rows ('.$total_matched.')<br/>Record Per Page ('.$records_returned.')<br/>Page Number ('.$page_number.')';
				}
				$data['result']  =  $message;
				$data['records_per_page']  =  $records_per_page;
				$data['page_number']  =  $page_number1;
				$data['content']  = 'API/cj_api_coupons';
				$this->load->view('Template/template',$data);
			}
		}
		
		//API Download
		public function cj_api_coupons_download()
		{
			$post = $this->input->post();
			$records_per_page = $post['records_per_page'];
			$page_number1 = $post['page_number'];
			$url = "https://link-search.api.cj.com/v2/link-search?website-id=9110558&link-type=text%20link&advertiser-ids=joined&records-per-page=".$records_per_page."&page-number=".$page_number1."&promotion-type=coupon";
			
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Contect-Type:application/xml', 'Accept:application/xml','Authorization: Bearer 1c3z3yjms97kmjhsj50x9kf8mq'));
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl,CURLOPT_RETURNTRANSFER,true);
			curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
			
			// Excecuting the curl call
			$result =  curl_exec($curl);
			
			// Close the Curl resource
			curl_close($curl);
			
			$xml = simplexml_load_string($result);
			$json = json_encode($xml);
			$result= json_decode($json, true);
			//	echo "<pre>";
			
			$count = 0;
			if(isset($result['links']['link']) && $result['links']['link']!=array())
			{
				
				$total_matched = $result['links']['@attributes']['total-matched'];
				$records_returned = $result['links']['@attributes']['records-returned'];
				$page_number = $result['links']['@attributes']['page-number'];
				
				foreach ($result['links']['link'] as $k => $v) 
				{
					foreach ($v as $k1 => $v1)
					{
						$yt_vids[$k]['advertiser-id'] = $result['links']['link'][$k]['advertiser-id'];
						$yt_vids[$k]['category'] = $result['links']['link'][$k]['category'];
						$yt_vids[$k]['description'] = $result['links']['link'][$k]['description'];
						$yt_vids[$k]['link-id'] = $result['links']['link'][$k]['link-id'];
						$yt_vids[$k]['promotion-end-date'] = $result['links']['link'][$k]['promotion-end-date'];
						$yt_vids[$k]['coupon-code'] = $result['links']['link'][$k]['coupon-code'];
						$yt_vids[$k]['clickUrl'] = $result['links']['link'][$k]['clickUrl'];   
					}
				}
				
				$this->load->library('PHPExcel');
				$object = new PHPExcel();
				$object->setActiveSheetIndex(0);
				$table_columns = array("advertiser-id","category","description","link-id","promotion-end-date","coupon-code","clickUrl");
				$object->getActiveSheet()->setTitle('CJ Coupons List');
				$column = 0;
				foreach($table_columns as $field)
				{
					$object->getActiveSheet()->setCellValueByColumnAndRow($column, 1, $field);
					$column++;
				}
				for ($col = ord('A'); $col <= ord('Z'); $col++) 
				{
					//set column dimension
					$object->getActiveSheet()->getColumnDimension(chr($col))->setAutoSize(true);
					$object->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
					//change the font size
					$object->getActiveSheet()->getStyle(chr($col))->getFont()->setSize(12);
				} 
				$excel_row = 2;
				$i = 1;
				foreach ($yt_vids as $key => $val) 
				{
					$advertiser_id = $val['advertiser-id'];
					$category = $val['category'];
					$description = $val['description'];
					$link_id = $val['link-id'];
					if(!empty($val['promotion-end-date']))
					{
						$promotion_end_date = $val['promotion-end-date'];
					}
					else
					{
						$promotion_end_date = "";
					}
					if(!empty($val['coupon-code']))
					{
						$coupon_code = $val['coupon-code'];
					}
					else
					{
						$coupon_code = "";
					}
					$clickUrl = $val['clickUrl'];
					
					$object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $advertiser_id);
					$object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $category);
					$object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $description);
					$object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $link_id);
					$object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $promotion_end_date);
					$object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $coupon_code);
					$object->getActiveSheet()->setCellValueByColumnAndRow(6, $excel_row, $clickUrl);
					
					$excel_row++;
					$i++;
					
				}
				
				
				$object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel2007');
				header('Content-Type: application/vnd.ms-excel');
				header('Content-Disposition: attachment;filename="CJ_Coupons_GGD.xlsx"');
				$object_writer->save('php://output');
				redirect(base_url().'API/cj_api_coupons','refresh');
			}
			else
			{
				$this->session->set_flashdata('error', " Record has not been found...!");
				redirect(base_url().'API/cj_api_coupons','refresh');	
			}
		}
		
		//CJ API
		public function cj_api_stores()
		{
			$data['content']  = 'API/cj_api_stores';
			$this->load->view('Template/template',$data);
			
		}
		
		//API TESTING
		public function cj_api_stores_submit()
		{
			$post = $this->input->post();
			$records_per_page = $post['records_per_page'];
			$page_number1 = $post['page_number'];
			/* $url = "https://link-search.api.cj.com/v2/link-search?website-id=9110558&link-type=text%20link&advertiser-ids=joined&records-per-page=".$records_per_page."&page-number=".$page_number1."&promotion-type=coupon"; */
			$url = "https://advertiser-lookup.api.cj.com/v2/advertiser-lookup?requestor-cid=5276376&advertiser-ids=joined&records-per-page=".$records_per_page."&page-number=".$page_number1;
			
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Contect-Type:application/xml', 'Accept:application/xml','Authorization: Bearer 1c3z3yjms97kmjhsj50x9kf8mq'));
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl,CURLOPT_RETURNTRANSFER,true);
			curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
			
			// Excecuting the curl call
			$result =  curl_exec($curl);
			
			// Close the Curl resource
			curl_close($curl);
			
			$xml = simplexml_load_string($result);
			$json = json_encode($xml);
			$result= json_decode($json, true);
			
			$count = 0;
			if(isset($result['advertisers']['advertiser']) && $result['advertisers']['advertiser']!=array())
			{
				$total_matched = $result['advertisers']['@attributes']['total-matched'];
				$records_returned = $result['advertisers']['@attributes']['records-returned'];
				$page_number = $result['advertisers']['@attributes']['page-number'];
				$message = '<br/>Success: Stores Record Successfully Found.<br/>Total Rows ('.$total_matched.')<br/>Record Per Page ('.$records_returned.')<br/>Page Number ('.$page_number.')';
				$data['result']  =  $message;
				$data['records_per_page']  =  $records_per_page;
				$data['page_number']  =  $page_number1;
				$data['content']  = 'API/cj_api_stores';
				$this->load->view('Template/template',$data);
			}
			else
			{
				if(!empty($result['error-message']))
				{
					$message = "Error: ".$result['error-message'];
				}
				else
				{
					$total_matched = $result['advertisers']['@attributes']['total-matched'];
					$records_returned = $result['advertisers']['@attributes']['records-returned'];
					$page_number = $result['advertisers']['@attributes']['page-number'];
					$message = '<br/>Success: Stores Record Successfully Found.<br/>Total Rows ('.$total_matched.')<br/>Record Per Page ('.$records_returned.')<br/>Page Number ('.$page_number.')';
				}
				$data['result']  =  $message;
				$data['records_per_page']  =  $records_per_page;
				$data['page_number']  =  $page_number1;
				$data['content']  = 'API/cj_api_stores';
				$this->load->view('Template/template',$data);
			}
		}
		
		//API Download
		public function cj_api_stores_download()
		{
			$post = $this->input->post();
			$records_per_page = $post['records_per_page'];
			$page_number1 = $post['page_number'];
			$url = "https://advertiser-lookup.api.cj.com/v2/advertiser-lookup?requestor-cid=5276376&advertiser-ids=joined&records-per-page=".$records_per_page."&page-number=".$page_number1;
			
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Contect-Type:application/xml', 'Accept:application/xml','Authorization: Bearer 1c3z3yjms97kmjhsj50x9kf8mq'));
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl,CURLOPT_RETURNTRANSFER,true);
			curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
			
			// Excecuting the curl call
			$result =  curl_exec($curl);
			
			// Close the Curl resource
			curl_close($curl);
			
			$xml = simplexml_load_string($result);
			$json = json_encode($xml);
			$result= json_decode($json, true);
			$count = 0;
			if(isset($result['advertisers']['advertiser']) && $result['advertisers']['advertiser']!=array())
			{
				
				$total_matched = $result['advertisers']['@attributes']['total-matched'];
				$records_returned = $result['advertisers']['@attributes']['records-returned'];
				$page_number = $result['advertisers']['@attributes']['page-number'];
				
				foreach ($result['advertisers']['advertiser'] as $k => $v) 
				{
					foreach ($v as $k1 => $v1)
					{
						$yt_vids[$k]['advertiser-id'] = $result['advertisers']['advertiser'][$k]['advertiser-id'];
						$yt_vids[$k]['account-status'] = $result['advertisers']['advertiser'][$k]['account-status'];
						$yt_vids[$k]['advertiser-name'] = $result['advertisers']['advertiser'][$k]['advertiser-name'];
						$yt_vids[$k]['program-url'] = $result['advertisers']['advertiser'][$k]['program-url'];
						$yt_vids[$k]['relationship-status'] = $result['advertisers']['advertiser'][$k]['relationship-status'];
						if(!empty($result['advertisers']['advertiser'][$k]['primary-category']['parent']))
						{
							$yt_vids[$k]['primary-category'] = $result['advertisers']['advertiser'][$k]['primary-category']['parent'];
						}
						else
						{
							$yt_vids[$k]['primary-category'] = $result['advertisers']['advertiser'][$k]['primary-category']['child'];
						}
						
					}
				}
				/* echo "<pre>";
					print_r($yt_vids);
				exit; */
				$this->load->library('PHPExcel');
				$object = new PHPExcel();
				$object->setActiveSheetIndex(0);
				$table_columns = array("advertiser-id","account-status","advertiser-name","program-url","relationship-status","primary-category");
				$object->getActiveSheet()->setTitle('CJ Stores List');
				$column = 0;
				foreach($table_columns as $field)
				{
					$object->getActiveSheet()->setCellValueByColumnAndRow($column, 1, $field);
					$column++;
				}
				for ($col = ord('A'); $col <= ord('Z'); $col++) 
				{
					//set column dimension
					$object->getActiveSheet()->getColumnDimension(chr($col))->setAutoSize(true);
					$object->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
					//change the font size
					$object->getActiveSheet()->getStyle(chr($col))->getFont()->setSize(12);
				} 
				$excel_row = 2;
				$i = 1;
				foreach ($yt_vids as $key => $val) 
				{
					$advertiser_id = $val['advertiser-id'];
					$account_status = $val['account-status'];
					$advertiser_name = $val['advertiser-name'];
					$program_url = $val['program-url'];
					
					if(!empty($val['relationship-status']))
					{
						$relationship_status = $val['relationship-status'];
					}
					else
					{
						$relationship_status = "";
					}
					$primary_category = $val['primary-category'];
					
					$object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $advertiser_id);
					$object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $account_status);
					$object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $advertiser_name);
					$object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $program_url);
					$object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $relationship_status);
					$object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $primary_category);
					
					$excel_row++;
					$i++;
					
				}
				$object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel2007');
				header('Content-Type: application/vnd.ms-excel');
				header('Content-Disposition: attachment;filename="CJ_Stores_GGD.xlsx"');
				$object_writer->save('php://output');
				redirect(base_url().'API/cj_api_stores','refresh');
			}
			else
			{
				$this->session->set_flashdata('error', " Record has not been found...!");
				redirect(base_url().'API/cj_api_stores','refresh');	
			}
		}
		
		//////////////////////////////////////////////////////////////
		/////////////////// Link Share API///////////////////////////
		/////////////////////////////////////////////////////////////
		//LS API
		public function ls_api_coupons()
		{
			$data['content']  = 'API/ls_api_coupons';
			$this->load->view('Template/template',$data);
			
		}
		
		//API TESTING
		public function ls_api_coupons_submit()
		{
			$post = $this->input->post();
			$bearer = $post['bearer'];
			$network = $post['network'];
			$records_per_page = $post['records_per_page'];
			$page_number1 = $post['page_number'];
			$category = $post['category'];
			$promotiontype = $post['promotiontype'];
			$mid = $post['mid'];
			$url = "https://api.rakutenmarketing.com/coupon/1.0?type=text1&";
			if(!empty($network))
			{
				$url .= "network=".$network;
			}
			if(!empty($records_per_page))
			{
				$url .= "&resultsperpage=".$records_per_page;
			}
			if(!empty($page_number1))
			{
				$url .= "&pagenumber=".$page_number1;
			}
			if(!empty($category))
			{
				$url .= "&category=".$category;
			}
			if(!empty($promotiontype))
			{
				$url .= "&promotiontype=".$promotiontype;
			}
			if(!empty($mid))
			{
				$url .= "&mid=".$mid;
			}
			
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Contect-Type:application/xml', 'Accept:application/xml','Authorization: Bearer '.$bearer.''));
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl,CURLOPT_RETURNTRANSFER,true);
			curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
			
			// Excecuting the curl call
			$result1 =  curl_exec($curl);
			
			// Close the Curl resource
			curl_close($curl);
			
			$xml = simplexml_load_string($result1);
			$json = json_encode($xml);
			$result = json_decode($json, true);
			/* 	 echo "<pre>";
				print_r($result);
			exit; */
			
			$count = 0;
			if(isset($result['link']) && $result['link']!=array())
			{
				
				$total_matched = $result['TotalMatches'];
				$records_returned = $result['TotalPages'];
				$page_number = $result['PageNumberRequested'];
				$message = '<br/>Success: Coupons Record Successfully Found.<br/>Total Rows ('.$total_matched.')<br/>Record Per Page ('.$records_returned.')<br/>Page Number ('.$page_number.')';
				$data['result']  =  $message;
				$data['bearer']  =  $bearer;
				$data['network']  =  $network;
				$data['records_per_page']  =  $records_per_page;
				$data['page_number']  =  $page_number1;
				$data['category']  =  $category;
				$data['promotiontype']  =  $promotiontype;
				$data['mid']  =  $mid;
				$data['content']  = 'API/ls_api_coupons';
				$this->load->view('Template/template',$data);
			}
			else
			{
				
				if(!empty($result1))
				{
					$message = "Error: ".$result1;
				}
				else
				{
					$total_matched = $result['TotalMatches'];
					$records_returned = $result['TotalPages'];
					$page_number = $result['PageNumberRequested'];
					$message = '<br/>Success: Coupons Record Successfully Found.<br/>Total Rows ('.$total_matched.')<br/>Record Per Page ('.$records_returned.')<br/>Page Number ('.$page_number.')';
				}
				$data['result']  =  $message;
				$data['bearer']  =  $bearer;
				$data['network']  =  $network;
				$data['records_per_page']  =  $records_per_page;
				$data['page_number']  =  $page_number1;
				$data['category']  =  $category;
				$data['promotiontype']  =  $promotiontype;
				$data['mid']  =  $mid;
				$data['content']  = 'API/ls_api_coupons';
				$this->load->view('Template/template',$data);
			}
		}
		
		//API Download
		public function ls_api_coupons_download()
		{
			
			$post = $this->input->post();
			$bearer = $post['bearer'];
			$network = $post['network'];
			$records_per_page = $post['records_per_page'];
			$page_number1 = $post['page_number'];
			$category = $post['category'];
			$promotiontype = $post['promotiontype'];
			$mid = $post['mid'];
			$url = "https://api.rakutenmarketing.com/coupon/1.0?type=text1&";
			if(!empty($network))
			{
				$url .= "network=".$network;
			}
			if(!empty($records_per_page))
			{
				$url .= "&resultsperpage=".$records_per_page;
			}
			if(!empty($page_number1))
			{
				$url .= "&pagenumber=".$page_number1;
			}
			if(!empty($category))
			{
				$url .= "&category=".$category;
			}
			if(!empty($promotiontype))
			{
				$url .= "&promotiontype=".$promotiontype;
			}
			if(!empty($mid))
			{
				$url .= "&mid=".$mid;
			}
			
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Contect-Type:application/xml', 'Accept:application/xml','Authorization: Bearer '.$bearer.''));
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl,CURLOPT_RETURNTRANSFER,true);
			curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
			
			// Excecuting the curl call
			$result1 =  curl_exec($curl);
			
			// Close the Curl resource
			curl_close($curl);
			
			$xml = simplexml_load_string($result1);
			$json = json_encode($xml);
			$result = json_decode($json, true);
			/*   echo "<pre>";
				print_r($result);
			exit;   */
			
			$count = 0;
			if(isset($result['link']))
			{
				
				$total_matched = $result['TotalMatches'];
				$records_returned = $result['TotalPages'];
				$page_number = $result['PageNumberRequested'];
				
				foreach ($result['link'] as $k => $v) 
				{
					foreach ($v as $k1 => $v1)
					{
						/* if(isset($result['link'][$k]['categories']['category'][0]))
							{
							$yt_vids[$k]['categories'] = $result['link'][$k]['categories']['category'][0];
							}
							else
							{
							$yt_vids[$k]['categories'] = $result['link'][$k]['categories']['category'];
							}
							if(isset($result['link'][$k]['promotiontypes']['promotiontype'][0]))
							{
							$yt_vids[$k]['promotiontypes'] = $result['link'][$k]['promotiontypes']['promotiontype'][0];
							}
							else
							{
							$yt_vids[$k]['promotiontypes'] = $result['link'][$k]['promotiontypes']['promotiontype'];
						} */
						$yt_vids[$k]['offerdescription'] = $result['link'][$k]['offerdescription'];
						$yt_vids[$k]['offerenddate'] = $result['link'][$k]['offerenddate'];
						if(isset($result['link'][$k]['couponcode']))
						{
							$yt_vids[$k]['couponcode'] = $result['link'][$k]['couponcode'];
						}
						else
						{
							$yt_vids[$k]['couponcode'] = "";
						}
						$yt_vids[$k]['clickurl'] = $result['link'][$k]['clickurl'];
						$yt_vids[$k]['advertiserid'] = $result['link'][$k]['advertiserid'];   
						$yt_vids[$k]['network'] = $result['link'][$k]['network'];   
					}
				}
				
				$this->load->library('PHPExcel');
				$object = new PHPExcel();
				$object->setActiveSheetIndex(0);
				//$table_columns = array("categories","promotiontypes","offerdescription","offerenddate","couponcode","clickurl","advertiserid","network");
				$table_columns = array("offerdescription","offerenddate","couponcode","clickurl","advertiserid","network");
				$object->getActiveSheet()->setTitle('LS Coupons List');
				$column = 0;
				foreach($table_columns as $field)
				{
					$object->getActiveSheet()->setCellValueByColumnAndRow($column, 1, $field);
					$column++;
				}
				for ($col = ord('A'); $col <= ord('Z'); $col++) 
				{
					//set column dimension
					$object->getActiveSheet()->getColumnDimension(chr($col))->setAutoSize(true);
					$object->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('I1')->getFont()->setBold(true);
					//change the font size
					$object->getActiveSheet()->getStyle(chr($col))->getFont()->setSize(12);
				} 
				$excel_row = 2;
				$i = 1;
				foreach ($yt_vids as $key => $val) 
				{
					//$categories = $val['categories'];
					//$promotiontypes = $val['promotiontypes'];
					$offerdescription = $val['offerdescription'];
					$offerenddate = $val['offerenddate'];
					if(!empty($val['couponcode']))
					{
						$couponcode = $val['couponcode'];
					}
					else
					{
						$couponcode = "";
					}
					
					$clickurl = $val['clickurl'];
					$advertiserid = $val['advertiserid'];
					$network = $val['network'];
					
					//$object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $categories);
					//$object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $promotiontypes);
					$object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $offerdescription);
					$object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $offerenddate);
					$object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $couponcode);
					$object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $clickurl);
					$object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $advertiserid);
					$object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $network);
					
					$excel_row++;
					$i++;
					
				}
				
				
				$object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel2007');
				header('Content-Type: application/vnd.ms-excel');
				header('Content-Disposition: attachment;filename="LS_Coupons_GGD.xlsx"');
				$object_writer->save('php://output');
				redirect(base_url().'API/ls_api_coupons','refresh');
			}
			else
			{
				$this->session->set_flashdata('error', " Record has not been found...!");
				redirect(base_url().'API/ls_api_coupons','refresh');	
			}
		}
		
		//ls API
		public function ls_api_stores()
		{
			$data['content']  = 'API/ls_api_stores';
			$this->load->view('Template/template',$data);
			
		}
		
		//API TESTING
		public function ls_api_stores_submit()
		{
			$post = $this->input->post();
			$bearer = $post['bearer'];
			$url = "https://api.rakutenmarketing.com/linklocator/1.0/getMerchByAppStatus/approved";
			
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Contect-Type:application/xml', 'Accept:application/xml','Authorization: Bearer '.$bearer.'','charset=utf-8'));
			/* curl_setopt($curl, CURLOPT_URL, $url);
				curl_setopt($curl,CURLOPT_RETURNTRANSFER,true);
			curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC); */
			
			
			//curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($curl, CURLOPT_URL, $url); 
			//curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
			
			$data = curl_exec($curl); // execute curl request
			
			echo "<pre>";
			print_r($data);
			exit; 
			
			
			curl_close($curl);
			
			
			$xml = simplexml_load_string($data,null, 0 ,'ns1:');
			
			//$xml= registerXPathNamespace("ns1", "http://endpoint.linkservice.linkshare.com/");
			
			
			echo "<pre>";
			print_r($xml);
			exit;
			
			
			
			
			// Excecuting the curl call
			//$result1 =  curl_exec($curl);
			
			
			
			
			
			// Close the Curl resource
			curl_close($curl);
			
			$xml = simplexml_load_string($result1);
			$json = json_encode($xml);
			$result= json_decode($json, true);
			
			
			
			$count = 0;
			if(isset($result['advertisers']['advertiser']) && $result['advertisers']['advertiser']!=array())
			{
				$total_matched = $result['advertisers']['@attributes']['total-matched'];
				$records_returned = $result['advertisers']['@attributes']['records-returned'];
				$page_number = $result['advertisers']['@attributes']['page-number'];
				$message = '<br/>Success: Stores Record Successfully Found.<br/>Total Rows ('.$total_matched.')<br/>Record Per Page ('.$records_returned.')<br/>Page Number ('.$page_number.')';
				$data['result']  =  $message;
				$data['records_per_page']  =  $records_per_page;
				$data['page_number']  =  $page_number1;
				$data['content']  = 'API/ls_api_stores';
				$this->load->view('Template/template',$data);
			}
			else
			{
				if(!empty($result['error-message']))
				{
					$message = "Error: ".$result['error-message'];
				}
				else
				{
					$total_matched = $result['advertisers']['@attributes']['total-matched'];
					$records_returned = $result['advertisers']['@attributes']['records-returned'];
					$page_number = $result['advertisers']['@attributes']['page-number'];
					$message = '<br/>Success: Stores Record Successfully Found.<br/>Total Rows ('.$total_matched.')<br/>Record Per Page ('.$records_returned.')<br/>Page Number ('.$page_number.')';
				}
				$data['result']  =  $message;
				$data['records_per_page']  =  $records_per_page;
				$data['page_number']  =  $page_number1;
				$data['content']  = 'API/ls_api_stores';
				$this->load->view('Template/template',$data);
			}
		}
		
		//API Download
		public function ls_api_stores_download()
		{
			$post = $this->input->post();
			$records_per_page = $post['records_per_page'];
			$page_number1 = $post['page_number'];
			$url = "https://advertiser-lookup.api.cj.com/v2/advertiser-lookup?requestor-cid=5276376&advertiser-ids=joined&records-per-page=".$records_per_page."&page-number=".$page_number1;
			
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Contect-Type:application/xml', 'Accept:application/xml','Authorization: Bearer 1c3z3yjms97kmjhsj50x9kf8mq'));
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl,CURLOPT_RETURNTRANSFER,true);
			curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
			
			// Excecuting the curl call
			$result =  curl_exec($curl);
			
			// Close the Curl resource
			curl_close($curl);
			
			$xml = simplexml_load_string($result);
			$json = json_encode($xml);
			$result= json_decode($json, true);
			$count = 0;
			if(isset($result['advertisers']['advertiser']) && $result['advertisers']['advertiser']!=array())
			{
				
				$total_matched = $result['advertisers']['@attributes']['total-matched'];
				$records_returned = $result['advertisers']['@attributes']['records-returned'];
				$page_number = $result['advertisers']['@attributes']['page-number'];
				
				foreach ($result['advertisers']['advertiser'] as $k => $v) 
				{
					foreach ($v as $k1 => $v1)
					{
						$yt_vids[$k]['advertiser-id'] = $result['advertisers']['advertiser'][$k]['advertiser-id'];
						$yt_vids[$k]['account-status'] = $result['advertisers']['advertiser'][$k]['account-status'];
						$yt_vids[$k]['advertiser-name'] = $result['advertisers']['advertiser'][$k]['advertiser-name'];
						$yt_vids[$k]['program-url'] = $result['advertisers']['advertiser'][$k]['program-url'];
						$yt_vids[$k]['relationship-status'] = $result['advertisers']['advertiser'][$k]['relationship-status'];
						if(!empty($result['advertisers']['advertiser'][$k]['primary-category']['parent']))
						{
							$yt_vids[$k]['primary-category'] = $result['advertisers']['advertiser'][$k]['primary-category']['parent'];
						}
						else
						{
							$yt_vids[$k]['primary-category'] = $result['advertisers']['advertiser'][$k]['primary-category']['child'];
						}
						
					}
				}
				/* echo "<pre>";
					print_r($yt_vids);
				exit; */
				$this->load->library('PHPExcel');
				$object = new PHPExcel();
				$object->setActiveSheetIndex(0);
				$table_columns = array("advertiser-id","account-status","advertiser-name","program-url","relationship-status","primary-category");
				$object->getActiveSheet()->setTitle('LS Stores List');
				$column = 0;
				foreach($table_columns as $field)
				{
					$object->getActiveSheet()->setCellValueByColumnAndRow($column, 1, $field);
					$column++;
				}
				for ($col = ord('A'); $col <= ord('Z'); $col++) 
				{
					//set column dimension
					$object->getActiveSheet()->getColumnDimension(chr($col))->setAutoSize(true);
					$object->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
					//change the font size
					$object->getActiveSheet()->getStyle(chr($col))->getFont()->setSize(12);
				} 
				$excel_row = 2;
				$i = 1;
				foreach ($yt_vids as $key => $val) 
				{
					$advertiser_id = $val['advertiser-id'];
					$account_status = $val['account-status'];
					$advertiser_name = $val['advertiser-name'];
					$program_url = $val['program-url'];
					
					if(!empty($val['relationship-status']))
					{
						$relationship_status = $val['relationship-status'];
					}
					else
					{
						$relationship_status = "";
					}
					$primary_category = $val['primary-category'];
					
					$object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $advertiser_id);
					$object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $account_status);
					$object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $advertiser_name);
					$object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $program_url);
					$object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $relationship_status);
					$object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $primary_category);
					
					$excel_row++;
					$i++;
					
				}
				$object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel2007');
				header('Content-Type: application/vnd.ms-excel');
				header('Content-Disposition: attachment;filename="LS_Stores_GGD.xlsx"');
				$object_writer->save('php://output');
				redirect(base_url().'API/ls_api_stores','refresh');
			}
			else
			{
				$this->session->set_flashdata('error', " Record has not been found...!");
				redirect(base_url().'API/ls_api_stores','refresh');	
			}
		}
		
		
		//////////////////////////////////////////////////////////////
		/////////////////// FO API //////////////////////////////////
		/////////////////////////////////////////////////////////////
		
		//FO API
		public function fo_api_coupons()
		{
			$data['content']  = 'API/fo_api_coupons';
			$this->load->view('Template/template',$data);
			
		}
		
		//API TESTING
		public function fo_api_coupons_submit()
		{
			$post = $this->input->post();
			$records_per_page = $post['records_per_page'];
			$page_number1 = $post['page_number'];
			$url = "https://api.flexoffers.com/links/text?pageSize=".$records_per_page."&page=".$page_number1;
			
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Contect-Type:application/json', 'Accept:application/json','apiKey: eb356095-2dca-494d-805d-0f79b6e01eec'));
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl,CURLOPT_RETURNTRANSFER,true);
			curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
			
			// Excecuting the curl call
			$result1 =  curl_exec($curl);
			
			// Close the Curl resource
			curl_close($curl);
			
			//$xml = simplexml_load_string($result);
			//$json = json_encode($result);
			$result= json_decode($result1, true);
			
			
			$count = 0;
			if(isset($result['results']) && $result['results']!=array())
			{
				
				$total_matched = $result['totalCount'];
				$records_returned = $result['pageSize'];
				$page_number = $result['pageNumber'];
				$message = '<br/>Success: Coupons Record Successfully Found.<br/>Total Rows ('.$total_matched.')<br/>Record Per Page ('.$records_returned.')<br/>Page Number ('.$page_number.')';
				$data['result']  =  $message;
				$data['records_per_page']  =  $records_per_page;
				$data['page_number']  =  $page_number1;
				$data['content']  = 'API/fo_api_coupons';
				$this->load->view('Template/template',$data);
			}
			else
			{
				
				if(!empty($result['message']))
				{
					$message = "Error: ".$result['message'];
				}
				else
				{
					$total_matched = $result['TotalCount'];
					$records_returned = $result['PageSize'];
					$page_number = $result['PageNumber'];
					$message = '<br/>Success: Coupons Record Successfully Found.<br/>Total Rows ('.$total_matched.')<br/>Record Per Page ('.$records_returned.')<br/>Page Number ('.$page_number.')';
				}
				$data['result']  =  $message;
				$data['records_per_page']  =  $records_per_page;
				$data['page_number']  =  $page_number1;
				$data['content']  = 'API/fo_api_coupons';
				$this->load->view('Template/template',$data);
			}
		}
		
		//API Download
		public function fo_api_coupons_download()
		{
			$post = $this->input->post();
			$records_per_page = $post['records_per_page'];
			$page_number1 = $post['page_number'];
			$url = "https://api.flexoffers.com/links/text?pageSize=".$records_per_page."&page=".$page_number1;
			
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Contect-Type:application/json', 'Accept:application/json','apiKey: eb356095-2dca-494d-805d-0f79b6e01eec'));
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl,CURLOPT_RETURNTRANSFER,true);
			curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
			
			// Excecuting the curl call
			$result1 =  curl_exec($curl);
			
			// Close the Curl resource
			curl_close($curl);
			
			//$xml = simplexml_load_string($result);
			//$json = json_encode($result);
			$result= json_decode($result1, true);
			
			$count = 0;
			if(isset($result['results']) && $result['results']!=array())
			{
				
				$total_matched = $result['totalCount'];
				$records_returned = $result['pageSize'];
				$page_number = $result['pageNumber'];
				
				/* foreach ($result['results'] as $k => $v) 
					{
					
					$yt_vids[$k]['productId'] = $result['results'][$k]['advertiser-id'];
					$yt_vids[$k]['category'] = $result['results'][$k]['category'];
					$yt_vids[$k]['description'] = $result['results'][$k]['description'];
					$yt_vids[$k]['link-id'] = $result['results'][$k]['link-id'];
					$yt_vids[$k]['promotion-end-date'] = $result['results'][$k]['promotion-end-date'];
					$yt_vids[$k]['coupon-code'] = $result['results'][$k]['coupon-code'];
					$yt_vids[$k]['clickUrl'] = $result['results'][$k]['clickUrl'];   
					
				} */
				
				$this->load->library('PHPExcel');
				$object = new PHPExcel();
				$object->setActiveSheetIndex(0);
				$table_columns = array("productId","contentType","linkText","advertiserId","linkUrl","expireDate","couponCode");
				$object->getActiveSheet()->setTitle('FO Coupons List');
				$column = 0;
				foreach($table_columns as $field)
				{
					$object->getActiveSheet()->setCellValueByColumnAndRow($column, 1, $field);
					$column++;
				}
				for ($col = ord('A'); $col <= ord('Z'); $col++) 
				{
					//set column dimension
					$object->getActiveSheet()->getColumnDimension(chr($col))->setAutoSize(true);
					$object->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
					//change the font size
					$object->getActiveSheet()->getStyle(chr($col))->getFont()->setSize(12);
				} 
				$excel_row = 2;
				$i = 1;
				
				foreach ($result['results'] as $key => $val) 
				{
					$productId = $val['productId'];
					$contentType = $val['contentType'];
					$linkText = $val['linkText'];
					$advertiserId = $val['advertiserId'];
					if(!empty($val['linkUrl']))
					{
						$linkUrl = $val['linkUrl'];
					}
					else
					{
						$linkUrl = "";
					}
					if(!empty($val['couponCode']))
					{
						$couponCode = $val['couponCode'];
					}
					else
					{
						$couponCode = "";
					}
					$expireDate = $val['expireDate'];
					
					$object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $productId);
					$object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $contentType);
					$object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $linkText);
					$object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $advertiserId);
					$object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $linkUrl);
					$object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $expireDate);
					$object->getActiveSheet()->setCellValueByColumnAndRow(6, $excel_row, $couponCode);
					
					$excel_row++;
					$i++;
					
				}
				
				
				$object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel2007');
				header('Content-Type: application/vnd.ms-excel');
				header('Content-Disposition: attachment;filename="FO_Coupons_GGD.xlsx"');
				$object_writer->save('php://output');
				redirect(base_url().'API/fo_api_coupons','refresh');
			}
			else
			{
				$this->session->set_flashdata('error', " Record has not been found...!");
				redirect(base_url().'API/fo_api_coupons','refresh');	
			}
		}
		
		//fo API
		public function fo_api_stores()
		{
			$data['content']  = 'API/fo_api_stores';
			$this->load->view('Template/template',$data);
			
		}
		
		//API TESTING
		public function fo_api_stores_submit()
		{
			$post = $this->input->post();
			$records_per_page = $post['records_per_page'];
			$page_number1 = $post['page_number'];
			$url = "https:///api.flexoffers.com/advertisers?pageSize=".$records_per_page."&page=".$page_number1;;
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Contect-Type:application/json', 'Accept:application/json','apiKey: eb356095-2dca-494d-805d-0f79b6e01eec'));
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl,CURLOPT_RETURNTRANSFER,true);
			curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
			
			// Excecuting the curl call
			$result1 =  curl_exec($curl);
			/* echo "<pre>";
				print_r($result1);
			exit;  */
			// Close the Curl resource
			curl_close($curl);
			
			//$xml = simplexml_load_string($result);
			//$json = json_encode($result);
			$result= json_decode($result1, true);
			
			$count = 0;
			$count = 0;
			if(isset($result['results']) && $result['results']!=array())
			{
				
				$total_matched = $result['totalCount'];
				$records_returned = $result['pageSize'];
				$page_number = $result['pageNumber'];
				$message = '<br/>Success: Stores Record Successfully Found.<br/>Total Rows ('.$total_matched.')<br/>Record Per Page ('.$records_returned.')<br/>Page Number ('.$page_number.')';
				$data['result']  =  $message;
				$data['records_per_page']  =  $records_per_page;
				$data['page_number']  =  $page_number1;
				$data['content']  = 'API/fo_api_stores';
				$this->load->view('Template/template',$data);
			}
			else
			{
				
				if(!empty($result['message']))
				{
					$message = "Error: ".$result['message'];
				}
				else
				{
					$total_matched = $result['TotalCount'];
					$records_returned = $result['PageSize'];
					$page_number = $result['PageNumber'];
					$message = '<br/>Success: Stores Record Successfully Found.<br/>Total Rows ('.$total_matched.')<br/>Record Per Page ('.$records_returned.')<br/>Page Number ('.$page_number.')';
				}
				$data['result']  =  $message;
				$data['records_per_page']  =  $records_per_page;
				$data['page_number']  =  $page_number1;
				$data['content']  = 'API/fo_api_stores';
				$this->load->view('Template/template',$data);
			}
		}
		
		//API TESTING
		public function fo_api_stores_download()
		{
			$post = $this->input->post();
			$records_per_page = $post['records_per_page'];
			$page_number1 = $post['page_number'];
			$url = "https:///api.flexoffers.com/advertisers?pageSize=".$records_per_page."&page=".$page_number1;;
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Contect-Type:application/json', 'Accept:application/json','apiKey: eb356095-2dca-494d-805d-0f79b6e01eec'));
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl,CURLOPT_RETURNTRANSFER,true);
			curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
			
			// Excecuting the curl call
			$result1 =  curl_exec($curl);
			/* echo "<pre>";
				print_r($result1);
			exit;  */
			// Close the Curl resource
			curl_close($curl);
			
			//$xml = simplexml_load_string($result);
			//$json = json_encode($result);
			$result= json_decode($result1, true);
			
			$count = 0;
			if(isset($result['results']) && $result['results']!=array())
			{
				$this->load->library('PHPExcel');
				$object = new PHPExcel();
				$object->setActiveSheetIndex(0);
				$table_columns = array("id","name","domainUrl","categoryIds","applicationStatus","country");
				$object->getActiveSheet()->setTitle('FO Stores List');
				$column = 0;
				foreach($table_columns as $field)
				{
					$object->getActiveSheet()->setCellValueByColumnAndRow($column, 1, $field);
					$column++;
				}
				for ($col = ord('A'); $col <= ord('Z'); $col++) 
				{
					//set column dimension
					$object->getActiveSheet()->getColumnDimension(chr($col))->setAutoSize(true);
					$object->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
					//change the font size
					$object->getActiveSheet()->getStyle(chr($col))->getFont()->setSize(12);
				} 
				$excel_row = 2;
				$i = 1;
				
				foreach ($result['results'] as $key => $val) 
				{
					$id = $val['id'];
					$name = $val['name'];
					$domainUrl = $val['domainUrl'];
					$categoryIds = $val['categoryIds'];
					if(!empty($val['applicationStatus']))
					{
						$applicationStatus = $val['applicationStatus'];
					}
					else
					{
						$applicationStatus = "";
					}
					if(!empty($val['country']))
					{
						$country = $val['country'];
					}
					else
					{
						$country = "";
					}
					
					$object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $id);
					$object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $name);
					$object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $domainUrl);
					$object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $categoryIds);
					$object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $applicationStatus);
					$object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $country);
					
					$excel_row++;
					$i++;
					
				}
				
				
				$object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel2007');
				header('Content-Type: application/vnd.ms-excel');
				header('Content-Disposition: attachment;filename="FO_Stores_GGD.xlsx"');
				$object_writer->save('php://output');
				redirect(base_url().'API/fo_api_stores','refresh');
			}
			else
			{
				$this->session->set_flashdata('error', " Record has not been found...!");
				redirect(base_url().'API/fo_api_stores','refresh');	
			}
		}
		
		
		//////////////////////////////////////////////////////////////
		/////////////////// SS API //////////////////////////////////
		/////////////////////////////////////////////////////////////
		
		//ss API
		public function ss_api_coupons()
		{
			$data['content']  = 'API/ss_api_coupons';
			$this->load->view('Template/template',$data);
			
		}
		
		//API TESTING
		public function ss_api_coupons_submit()
		{
			$post = $this->input->post();
			$records_per_page = $post['records_per_page'];
			$page_number1 = $post['page_number'];
			$url = "https://link-search.api.cj.com/v2/link-search?website-id=9110558&link-type=text%20link&advertiser-ids=joined&records-per-page=".$records_per_page."&page-number=".$page_number1."&promotion-type=coupon";
			
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Contect-Type:application/xml', 'Accept:application/xml','Authorization: Bearer 1c3z3yjms97kmjhsj50x9kf8mq'));
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl,CURLOPT_RETURNTRANSFER,true);
			curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
			
			// Excecuting the curl call
			$result =  curl_exec($curl);
			
			// Close the Curl resource
			curl_close($curl);
			
			$xml = simplexml_load_string($result);
			$json = json_encode($xml);
			$result= json_decode($json, true);
			
			
			$count = 0;
			if(isset($result['links']['link']) && $result['links']['link']!=array())
			{
				
				$total_matched = $result['links']['@attributes']['total-matched'];
				$records_returned = $result['links']['@attributes']['records-returned'];
				$page_number = $result['links']['@attributes']['page-number'];
				$message = '<br/>Success: Coupons Record Successfully Found.<br/>Total Rows ('.$total_matched.')<br/>Record Per Page ('.$records_returned.')<br/>Page Number ('.$page_number.')';
				$data['result']  =  $message;
				$data['records_per_page']  =  $records_per_page;
				$data['page_number']  =  $page_number1;
				$data['content']  = 'API/cj_api_coupons';
				$this->load->view('Template/template',$data);
			}
			else
			{
				
				if(!empty($result['error-message']))
				{
					$message = "Error: ".$result['error-message'];
				}
				else
				{
					$total_matched = $result['links']['@attributes']['total-matched'];
					$records_returned = $result['links']['@attributes']['records-returned'];
					$page_number = $result['links']['@attributes']['page-number'];
					$message = '<br/>Success: Coupons Record Successfully Found.<br/>Total Rows ('.$total_matched.')<br/>Record Per Page ('.$records_returned.')<br/>Page Number ('.$page_number.')';
				}
				$data['result']  =  $message;
				$data['records_per_page']  =  $records_per_page;
				$data['page_number']  =  $page_number1;
				$data['content']  = 'API/ss_api_coupons';
				$this->load->view('Template/template',$data);
			}
		}
		
		//API Download
		public function ss_api_coupons_download()
		{
			$post = $this->input->post();
			$records_per_page = $post['records_per_page'];
			$page_number1 = $post['page_number'];
			$url = "https://link-search.api.cj.com/v2/link-search?website-id=9110558&link-type=text%20link&advertiser-ids=joined&records-per-page=".$records_per_page."&page-number=".$page_number1."&promotion-type=coupon";
			
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Contect-Type:application/xml', 'Accept:application/xml','Authorization: Bearer 1c3z3yjms97kmjhsj50x9kf8mq'));
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl,CURLOPT_RETURNTRANSFER,true);
			curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
			
			// Excecuting the curl call
			$result =  curl_exec($curl);
			
			// Close the Curl resource
			curl_close($curl);
			
			$xml = simplexml_load_string($result);
			$json = json_encode($xml);
			$result= json_decode($json, true);
			//	echo "<pre>";
			
			$count = 0;
			if(isset($result['links']['link']) && $result['links']['link']!=array())
			{
				
				$total_matched = $result['links']['@attributes']['total-matched'];
				$records_returned = $result['links']['@attributes']['records-returned'];
				$page_number = $result['links']['@attributes']['page-number'];
				
				foreach ($result['links']['link'] as $k => $v) 
				{
					foreach ($v as $k1 => $v1)
					{
						$yt_vids[$k]['advertiser-id'] = $result['links']['link'][$k]['advertiser-id'];
						$yt_vids[$k]['category'] = $result['links']['link'][$k]['category'];
						$yt_vids[$k]['description'] = $result['links']['link'][$k]['description'];
						$yt_vids[$k]['link-id'] = $result['links']['link'][$k]['link-id'];
						$yt_vids[$k]['promotion-end-date'] = $result['links']['link'][$k]['promotion-end-date'];
						$yt_vids[$k]['coupon-code'] = $result['links']['link'][$k]['coupon-code'];
						$yt_vids[$k]['clickUrl'] = $result['links']['link'][$k]['clickUrl'];   
					}
				}
				
				$this->load->library('PHPExcel');
				$object = new PHPExcel();
				$object->setActiveSheetIndex(0);
				$table_columns = array("advertiser-id","category","description","link-id","promotion-end-date","coupon-code","clickUrl");
				$object->getActiveSheet()->setTitle('CJ Coupons List');
				$column = 0;
				foreach($table_columns as $field)
				{
					$object->getActiveSheet()->setCellValueByColumnAndRow($column, 1, $field);
					$column++;
				}
				for ($col = ord('A'); $col <= ord('Z'); $col++) 
				{
					//set column dimension
					$object->getActiveSheet()->getColumnDimension(chr($col))->setAutoSize(true);
					$object->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
					//change the font size
					$object->getActiveSheet()->getStyle(chr($col))->getFont()->setSize(12);
				} 
				$excel_row = 2;
				$i = 1;
				foreach ($yt_vids as $key => $val) 
				{
					$advertiser_id = $val['advertiser-id'];
					$category = $val['category'];
					$description = $val['description'];
					$link_id = $val['link-id'];
					if(!empty($val['promotion-end-date']))
					{
						$promotion_end_date = $val['promotion-end-date'];
					}
					else
					{
						$promotion_end_date = "";
					}
					if(!empty($val['coupon-code']))
					{
						$coupon_code = $val['coupon-code'];
					}
					else
					{
						$coupon_code = "";
					}
					$clickUrl = $val['clickUrl'];
					
					$object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $advertiser_id);
					$object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $category);
					$object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $description);
					$object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $link_id);
					$object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $promotion_end_date);
					$object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $coupon_code);
					$object->getActiveSheet()->setCellValueByColumnAndRow(6, $excel_row, $clickUrl);
					
					$excel_row++;
					$i++;
					
				}
				
				
				$object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel2007');
				header('Content-Type: application/vnd.ms-excel');
				header('Content-Disposition: attachment;filename="SS_Coupons_GGD.xlsx"');
				$object_writer->save('php://output');
				redirect(base_url().'API/ss_api_coupons','refresh');
			}
			else
			{
				$this->session->set_flashdata('error', " Record has not been found...!");
				redirect(base_url().'API/ss_api_coupons','refresh');	
			}
		}
		
		//ss API
		public function ss_api_stores()
		{
			$data['content']  = 'API/ss_api_stores';
			$this->load->view('Template/template',$data);
			
		}
		
		//API TESTING
		public function ss_api_stores_submit()
		{
			$post = $this->input->post();
			$records_per_page = $post['records_per_page'];
			$page_number1 = $post['page_number'];
			/* $url = "https://link-search.api.cj.com/v2/link-search?website-id=9110558&link-type=text%20link&advertiser-ids=joined&records-per-page=".$records_per_page."&page-number=".$page_number1."&promotion-type=coupon"; */
			$url = "https://advertiser-lookup.api.cj.com/v2/advertiser-lookup?requestor-cid=5276376&advertiser-ids=joined&records-per-page=".$records_per_page."&page-number=".$page_number1;
			
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Contect-Type:application/xml', 'Accept:application/xml','Authorization: Bearer 1c3z3yjms97kmjhsj50x9kf8mq'));
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl,CURLOPT_RETURNTRANSFER,true);
			curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
			
			// Excecuting the curl call
			$result =  curl_exec($curl);
			
			// Close the Curl resource
			curl_close($curl);
			
			$xml = simplexml_load_string($result);
			$json = json_encode($xml);
			$result= json_decode($json, true);
			
			$count = 0;
			if(isset($result['advertisers']['advertiser']) && $result['advertisers']['advertiser']!=array())
			{
				$total_matched = $result['advertisers']['@attributes']['total-matched'];
				$records_returned = $result['advertisers']['@attributes']['records-returned'];
				$page_number = $result['advertisers']['@attributes']['page-number'];
				$message = '<br/>Success: Stores Record Successfully Found.<br/>Total Rows ('.$total_matched.')<br/>Record Per Page ('.$records_returned.')<br/>Page Number ('.$page_number.')';
				$data['result']  =  $message;
				$data['records_per_page']  =  $records_per_page;
				$data['page_number']  =  $page_number1;
				$data['content']  = 'API/ss_api_stores';
				$this->load->view('Template/template',$data);
			}
			else
			{
				if(!empty($result['error-message']))
				{
					$message = "Error: ".$result['error-message'];
				}
				else
				{
					$total_matched = $result['advertisers']['@attributes']['total-matched'];
					$records_returned = $result['advertisers']['@attributes']['records-returned'];
					$page_number = $result['advertisers']['@attributes']['page-number'];
					$message = '<br/>Success: Stores Record Successfully Found.<br/>Total Rows ('.$total_matched.')<br/>Record Per Page ('.$records_returned.')<br/>Page Number ('.$page_number.')';
				}
				$data['result']  =  $message;
				$data['records_per_page']  =  $records_per_page;
				$data['page_number']  =  $page_number1;
				$data['content']  = 'API/ss_api_stores';
				$this->load->view('Template/template',$data);
			}
		}
		
		//API Download
		public function ss_api_stores_download()
		{
			$post = $this->input->post();
			$records_per_page = $post['records_per_page'];
			$page_number1 = $post['page_number'];
			$url = "https://advertiser-lookup.api.cj.com/v2/advertiser-lookup?requestor-cid=5276376&advertiser-ids=joined&records-per-page=".$records_per_page."&page-number=".$page_number1;
			
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Contect-Type:application/xml', 'Accept:application/xml','Authorization: Bearer 1c3z3yjms97kmjhsj50x9kf8mq'));
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl,CURLOPT_RETURNTRANSFER,true);
			curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
			
			// Excecuting the curl call
			$result =  curl_exec($curl);
			
			// Close the Curl resource
			curl_close($curl);
			
			$xml = simplexml_load_string($result);
			$json = json_encode($xml);
			$result= json_decode($json, true);
			$count = 0;
			if(isset($result['advertisers']['advertiser']) && $result['advertisers']['advertiser']!=array())
			{
				
				$total_matched = $result['advertisers']['@attributes']['total-matched'];
				$records_returned = $result['advertisers']['@attributes']['records-returned'];
				$page_number = $result['advertisers']['@attributes']['page-number'];
				
				foreach ($result['advertisers']['advertiser'] as $k => $v) 
				{
					foreach ($v as $k1 => $v1)
					{
						$yt_vids[$k]['advertiser-id'] = $result['advertisers']['advertiser'][$k]['advertiser-id'];
						$yt_vids[$k]['account-status'] = $result['advertisers']['advertiser'][$k]['account-status'];
						$yt_vids[$k]['advertiser-name'] = $result['advertisers']['advertiser'][$k]['advertiser-name'];
						$yt_vids[$k]['program-url'] = $result['advertisers']['advertiser'][$k]['program-url'];
						$yt_vids[$k]['relationship-status'] = $result['advertisers']['advertiser'][$k]['relationship-status'];
						if(!empty($result['advertisers']['advertiser'][$k]['primary-category']['parent']))
						{
							$yt_vids[$k]['primary-category'] = $result['advertisers']['advertiser'][$k]['primary-category']['parent'];
						}
						else
						{
							$yt_vids[$k]['primary-category'] = $result['advertisers']['advertiser'][$k]['primary-category']['child'];
						}
						
					}
				}
				/* echo "<pre>";
					print_r($yt_vids);
				exit; */
				$this->load->library('PHPExcel');
				$object = new PHPExcel();
				$object->setActiveSheetIndex(0);
				$table_columns = array("advertiser-id","account-status","advertiser-name","program-url","relationship-status","primary-category");
				$object->getActiveSheet()->setTitle('CJ Stores List');
				$column = 0;
				foreach($table_columns as $field)
				{
					$object->getActiveSheet()->setCellValueByColumnAndRow($column, 1, $field);
					$column++;
				}
				for ($col = ord('A'); $col <= ord('Z'); $col++) 
				{
					//set column dimension
					$object->getActiveSheet()->getColumnDimension(chr($col))->setAutoSize(true);
					$object->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
					//change the font size
					$object->getActiveSheet()->getStyle(chr($col))->getFont()->setSize(12);
				} 
				$excel_row = 2;
				$i = 1;
				foreach ($yt_vids as $key => $val) 
				{
					$advertiser_id = $val['advertiser-id'];
					$account_status = $val['account-status'];
					$advertiser_name = $val['advertiser-name'];
					$program_url = $val['program-url'];
					
					if(!empty($val['relationship-status']))
					{
						$relationship_status = $val['relationship-status'];
					}
					else
					{
						$relationship_status = "";
					}
					$primary_category = $val['primary-category'];
					
					$object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $advertiser_id);
					$object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $account_status);
					$object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $advertiser_name);
					$object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $program_url);
					$object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $relationship_status);
					$object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $primary_category);
					
					$excel_row++;
					$i++;
					
				}
				$object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel2007');
				header('Content-Type: application/vnd.ms-excel');
				header('Content-Disposition: attachment;filename="SS_Stores_GGD.xlsx"');
				$object_writer->save('php://output');
				redirect(base_url().'API/cj_api_stores','refresh');
			}
			else
			{
				$this->session->set_flashdata('error', " Record has not been found...!");
				redirect(base_url().'API/ss_api_stores','refresh');	
			}
		}
		
		//////////////////////////////////////////////////////////////
		/////////////////// AF API //////////////////////////////////
		/////////////////////////////////////////////////////////////
		
		//AF API
		public function af_api_coupons()
		{
			$data['content']  = 'API/af_api_coupons';
			$this->load->view('Template/template',$data);
			
		}
		//AF SUBMIT
		public function af_api_coupons_submit()
		{
			$url = "https://api.affiliatefuture.com/PublisherService.svc/getAllVouchers?key=AF0E411087&passcode=3EB33B9B00";
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Contect-Type:application/xml', 'Accept:application/xml',''));
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl,CURLOPT_RETURNTRANSFER,true);
			curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
			
			// Excecuting the curl call
			$result =  curl_exec($curl);
			
			// Close the Curl resource
			curl_close($curl);
			
			$xml = simplexml_load_string($result);
			$json = json_encode($xml);
			$result = json_decode($json, true);
			
			/* echo "<pre>";
				print_r($result);
			exit; */
			
			$count = 0;
			if(isset($result['Vouchers']['Voucher']) && $result['Vouchers']['Voucher']!=array())
			{
				
				foreach ($result['Vouchers']['Voucher'] as $k => $v) 
				{
					foreach ($v as $k1 => $v1)
					{
						if($result['Vouchers']['Voucher'][$k]['Joined'] == "No")
						{
							continue;
						}
						$yt_vids[$k]['CategoryName'] = $result['Vouchers']['Voucher'][$k]['CategoryName'];
						$yt_vids[$k]['EndDate'] = $result['Vouchers']['Voucher'][$k]['EndDate'];
						if(!empty($result['Vouchers']['Voucher'][$k]['ImageURL']))
						{
							$yt_vids[$k]['ImageURL'] = $result['Vouchers']['Voucher'][$k]['ImageURL'];
						}
						else
						{
							$yt_vids[$k]['ImageURL'] = "";
						}
						
						$yt_vids[$k]['Joined'] = $result['Vouchers']['Voucher'][$k]['Joined'];
						if(!empty($result['Vouchers']['Voucher'][$k]['LandingPage']))
						{
							$yt_vids[$k]['LandingPage'] = $result['Vouchers']['Voucher'][$k]['LandingPage'];
						}
						else
						{
							$yt_vids[$k]['LandingPage'] = "";
						}
						$yt_vids[$k]['MerchantSiteID'] = $result['Vouchers']['Voucher'][$k]['MerchantSiteID'];
						$yt_vids[$k]['MerchantSiteName'] = $result['Vouchers']['Voucher'][$k]['MerchantSiteName'];
						$yt_vids[$k]['ProgrammeID'] = $result['Vouchers']['Voucher'][$k]['ProgrammeID'];
						$yt_vids[$k]['StartDate'] = $result['Vouchers']['Voucher'][$k]['StartDate'];
						if(!empty($result['Vouchers']['Voucher'][$k]['TermsAndCondition']))
						{
							$yt_vids[$k]['TermsAndCondition'] = $result['Vouchers']['Voucher'][$k]['TermsAndCondition'];
						}
						else
						{
							$yt_vids[$k]['TermsAndCondition'] = "";
						}
						if(!empty($result['Vouchers']['Voucher'][$k]['Tracking_URL']))
						{
							$yt_vids[$k]['Tracking_URL'] = $result['Vouchers']['Voucher'][$k]['Tracking_URL'];
						}
						else
						{
							$yt_vids[$k]['Tracking_URL'] = "";
						}
						$yt_vids[$k]['VoucherCode'] = $result['Vouchers']['Voucher'][$k]['VoucherCode'];
						$yt_vids[$k]['VoucherDescription'] = $result['Vouchers']['Voucher'][$k]['VoucherDescription'];
						$yt_vids[$k]['VoucherID'] = $result['Vouchers']['Voucher'][$k]['VoucherID'];
						
						
					}
				}
				/* echo "<pre>";
					print_r($yt_vids);
				exit;  */
				
				
				
				$this->load->library('PHPExcel');
				$object = new PHPExcel();
				$object->setActiveSheetIndex(0);
				$table_columns = array("CategoryName","EndDate","ImageURL","Joined","LandingPage","MerchantSiteID","MerchantSiteName","ProgrammeID","StartDate","TermsAndCondition","Tracking_URL","VoucherCode","VoucherDescription","VoucherID");
				$object->getActiveSheet()->setTitle('AF Coupons List');
				$column = 0;
				foreach($table_columns as $field)
				{
					$object->getActiveSheet()->setCellValueByColumnAndRow($column, 1, $field);
					$column++;
				}
				for ($col = ord('A'); $col <= ord('Z'); $col++) 
				{
					//set column dimension
					$object->getActiveSheet()->getColumnDimension(chr($col))->setAutoSize(true);
					$object->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('H1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('I1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('J1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('K1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('L1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('M1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('N1')->getFont()->setBold(true);
					//change the font size
					$object->getActiveSheet()->getStyle(chr($col))->getFont()->setSize(12);
				} 
				$excel_row = 2;
				$i = 1;
				
				foreach ($yt_vids as $key => $val) 
				{
					$CategoryName = $val['CategoryName'];
					$EndDate = $val['EndDate'];
					$ImageURL = $val['ImageURL'];
					$Joined = $val['Joined'];
					$LandingPage = $val['LandingPage'];
					$MerchantSiteID = $val['MerchantSiteID'];
					$MerchantSiteName = $val['MerchantSiteName'];
					$ProgrammeID = $val['ProgrammeID'];
					$StartDate = $val['StartDate'];
					$TermsAndCondition = $val['TermsAndCondition'];
					$Tracking_URL = $val['Tracking_URL'];
					$VoucherCode = $val['VoucherCode'];
					$VoucherDescription = $val['VoucherDescription'];
					$VoucherID = $val['VoucherID'];
					
					
					$object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $CategoryName);
					$object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $EndDate);
					$object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $ImageURL);
					$object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $Joined);
					$object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $LandingPage);
					$object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $MerchantSiteID);
					$object->getActiveSheet()->setCellValueByColumnAndRow(6, $excel_row, $MerchantSiteName);
					$object->getActiveSheet()->setCellValueByColumnAndRow(7, $excel_row, $ProgrammeID);
					$object->getActiveSheet()->setCellValueByColumnAndRow(8, $excel_row, $StartDate);
					$object->getActiveSheet()->setCellValueByColumnAndRow(9, $excel_row, $TermsAndCondition);
					$object->getActiveSheet()->setCellValueByColumnAndRow(10, $excel_row, $Tracking_URL);
					$object->getActiveSheet()->setCellValueByColumnAndRow(11, $excel_row, $VoucherCode);
					$object->getActiveSheet()->setCellValueByColumnAndRow(12, $excel_row, $VoucherDescription);
					$object->getActiveSheet()->setCellValueByColumnAndRow(13, $excel_row, $VoucherID);
					
					$excel_row++;
					$i++;
					
				}
				
				
				$object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel2007');
				header('Content-Type: application/vnd.ms-excel');
				header('Content-Disposition: attachment;filename="AF_Coupons_GGD.xlsx"');
				$object_writer->save('php://output');
				redirect(base_url().'API/af_api_coupons','refresh');
			}
			else
			{
				$this->session->set_flashdata('error', " Record has not been found...!");
				redirect(base_url().'API/af_api_coupons','refresh');	
			}
		}
		
		//AF API
		public function af_api_stores()
		{
			$data['content']  = 'API/af_api_stores';
			$this->load->view('Template/template',$data);
			
		}
		/* public function cdata_filter($matches) 
			{
			$converted = htmlspecialchars($matches[1]);
			$trimmed = trim($converted);
			return $trimmed;
		} */
		//AF SUBMIT
		public function af_api_stores_submit()
		{
			$url = "https://api.affiliatefuture.com/PublisherService.svc/GetAFMerchantList?key=AF0E411087&passcode=3EB33B9B00&merchantsJoined=ALL&newMerchants=NO";
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Contect-Type:application/xml', 'Accept:application/xml',''));
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl,CURLOPT_RETURNTRANSFER,true);
			curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
			
			// Excecuting the curl call
			$result1 =  curl_exec($curl);
			
			// Close the Curl resource
			curl_close($curl);
			
			//$string = preg_replace_callback('/<!\[CDATA\[(.*)\]\]>/', 'cdata_filter', $result);
			$xml = simplexml_load_string($result1, null, LIBXML_NOCDATA);
			$json = json_encode($xml);
			$result = json_decode($json, true);
			
			/* echo "<pre>w";
				print_r($result1);
			exit; */
			
			$count = 0;
			if(isset($result['Merchant']) && $result['Merchant']!=array())
			{
				
				foreach ($result['Merchant'] as $k => $v) 
				{
					foreach ($v as $k1 => $v1)
					{
						if(!empty($result['Merchant'][$k]['MerchantName']))
						{
							$yt_vids[$k]['MerchantName'] = $result['Merchant'][$k]['MerchantName'];
						}
						else
						{
							$yt_vids[$k]['MerchantName'] = "";
						}
						if(!empty($result['Merchant'][$k]['MerchantSiteId']))
						{
							$yt_vids[$k]['MerchantSiteId'] = $result['Merchant'][$k]['MerchantSiteId'];
						}
						else
						{
							$yt_vids[$k]['MerchantSiteId'] = "";
						}
						if(!empty($result['Merchant'][$k]['SiteAddress']))
						{
							$yt_vids[$k]['SiteAddress'] = $result['Merchant'][$k]['SiteAddress'];
						}
						else
						{
							$yt_vids[$k]['SiteAddress'] = "";
						}
						if(!empty($result['Merchant'][$k]['SiteDescription']))
						{
							$yt_vids[$k]['SiteDescription'] = $result['Merchant'][$k]['SiteDescription'];
						}
						else
						{
							$yt_vids[$k]['SiteDescription'] = "";
						}
						if(!empty($result['Merchant'][$k]['logo']))
						{
							$yt_vids[$k]['logo'] = $result['Merchant'][$k]['logo'];
						}
						else
						{
							$yt_vids[$k]['logo'] = "";
						}
						if(!empty($result['Merchant'][$k]['Categories']['categoryName']))
						{
							$yt_vids[$k]['Categories'] = $result['Merchant'][$k]['Categories']['categoryName'];
						}
						else
						{
							$yt_vids[$k]['Categories'] = "";
						}
						
					}
				}
				/*  echo "<pre>";
					print_r($yt_vids);
				exit;   */
				
				
				
				$this->load->library('PHPExcel');
				$object = new PHPExcel();
				$object->setActiveSheetIndex(0);
				$table_columns = array("MerchantName","MerchantSiteId","SiteAddress","SiteDescription","logo","Categories");
				$object->getActiveSheet()->setTitle('AF Stores List');
				$column = 0;
				foreach($table_columns as $field)
				{
					$object->getActiveSheet()->setCellValueByColumnAndRow($column, 1, $field);
					$column++;
				}
				for ($col = ord('A'); $col <= ord('Z'); $col++) 
				{
					//set column dimension
					$object->getActiveSheet()->getColumnDimension(chr($col))->setAutoSize(true);
					$object->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
					//change the font size
					$object->getActiveSheet()->getStyle(chr($col))->getFont()->setSize(12);
				} 
				$excel_row = 2;
				$i = 1;
				
				foreach ($yt_vids as $key => $val) 
				{
					$MerchantName = $val['MerchantName'];
					$MerchantSiteId = $val['MerchantSiteId'];
					$SiteAddress = $val['SiteAddress'];
					$SiteDescription = $val['SiteDescription'];
					$logo = $val['logo'];
					$Categories = $val['Categories'];
					
					
					$object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $MerchantName);
					$object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $MerchantSiteId);
					$object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $SiteAddress);
					$object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $SiteDescription);
					$object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $logo);
					$object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $Categories);
					$excel_row++;
					$i++;
					
				}
				
				
				$object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel2007');
				header('Content-Type: application/vnd.ms-excel');
				header('Content-Disposition: attachment;filename="AF_Stores_GGD.xlsx"');
				$object_writer->save('php://output');
				redirect(base_url().'API/af_api_stores','refresh');
			}
			else
			{
				$this->session->set_flashdata('error', " Record has not been found...!");
				redirect(base_url().'API/af_api_stores','refresh');	
			}
		}
		
		
		//////////////////////////////////////////////////////////////
		/////////////////// WG API //////////////////////////////////
		/////////////////////////////////////////////////////////////
		//WG API
		public function wg_api_coupons()
		{
			$data['content']  = 'API/wg_api_coupons';
			$this->load->view('Template/template',$data);
			
		}
		
		//wg API
		public function wg_api_stores()
		{
			$data['content']  = 'API/wg_api_stores';
			$this->load->view('Template/template',$data);
			
		}
		
		//////////////////////////////////////////////////////////////
		/////////////////// Por API //////////////////////////////////
		/////////////////////////////////////////////////////////////
		//Por API
		public function por_api_coupons()
		{
			$data['content']  = 'API/por_api_coupons';
			$this->load->view('Template/template',$data);
			
		}
		
		
		//POR SUBMIT
		public function por_api_coupons_submit()
		{
			$url = "http://vouchers.paidonresults.net/api?affiliate_id=48834&securitycode=eFAendFy&export=xml&fields=MerchantName,MerchantURL,AffiliateURL,VoucherCode,VoucherDescription,StartDate,ExpiryDate,MerchantID,VoucherID&inc_upcoming=1&inc_all_merchants=1&date=DD/MM/YYYY";
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Contect-Type:application/xml', 'Accept:application/xml',''));
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl,CURLOPT_RETURNTRANSFER,true);
			curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
			
			// Excecuting the curl call
			$result =  curl_exec($curl);
			
			// Close the Curl resource
			curl_close($curl);
			
			$xml = simplexml_load_string($result);
			$json = json_encode($xml);
			$result = json_decode($json, true);
			
			/* echo "<pre>";
				print_r($result);
			exit; */ 
			
			$count = 0;
			if(isset($result['voucher']) && $result['voucher']!=array())
			{
				
				foreach ($result['voucher'] as $k => $v) 
				{
					foreach ($v as $k1 => $v1)
					{
						$yt_vids[$k]['MerchantName'] = $result['voucher'][$k]['MerchantName'];
						$yt_vids[$k]['MerchantURL'] = $result['voucher'][$k]['MerchantURL'];	
						$yt_vids[$k]['AffiliateURL'] = $result['voucher'][$k]['AffiliateURL'];
						$yt_vids[$k]['VoucherCode'] = $result['voucher'][$k]['VoucherCode'];
						$yt_vids[$k]['VoucherDescription'] = $result['voucher'][$k]['VoucherDescription'];
						$yt_vids[$k]['StartDate'] = $result['voucher'][$k]['StartDate'];
						if(!empty($result['voucher'][$k]['ExpiryDate']))
						{
							$yt_vids[$k]['ExpiryDate'] = $result['voucher'][$k]['ExpiryDate'];
						}
						else
						{
							$yt_vids[$k]['ExpiryDate'] = "";
						}
						$yt_vids[$k]['MerchantID'] = $result['voucher'][$k]['MerchantID'];
						$yt_vids[$k]['VoucherID'] = $result['voucher'][$k]['VoucherID'];
					}
				}
				/*  echo "<pre>";
					print_r($yt_vids);
				exit;  */
				
				
				
				$this->load->library('PHPExcel');
				$object = new PHPExcel();
				$object->setActiveSheetIndex(0);
				$table_columns = array("MerchantName","MerchantURL","AffiliateURL","VoucherCode","VoucherDescription","StartDate","ExpiryDate","MerchantID","VoucherID");
				$object->getActiveSheet()->setTitle('PoR Coupons List');
				$column = 0;
				foreach($table_columns as $field)
				{
					$object->getActiveSheet()->setCellValueByColumnAndRow($column, 1, $field);
					$column++;
				}
				for ($col = ord('A'); $col <= ord('Z'); $col++) 
				{
					//set column dimension
					$object->getActiveSheet()->getColumnDimension(chr($col))->setAutoSize(true);
					$object->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('H1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('I1')->getFont()->setBold(true);
					//change the font size
					$object->getActiveSheet()->getStyle(chr($col))->getFont()->setSize(12);
				} 
				$excel_row = 2;
				$i = 1;
				
				foreach ($yt_vids as $key => $val) 
				{
					$MerchantName = $val['MerchantName'];
					$MerchantURL = $val['MerchantURL'];
					$AffiliateURL = $val['AffiliateURL'];
					$VoucherCode = $val['VoucherCode'];
					$VoucherDescription = $val['VoucherDescription'];
					$StartDate = $val['StartDate'];
					$ExpiryDate = $val['ExpiryDate'];
					$MerchantID = $val['MerchantID'];
					$VoucherID = $val['VoucherID'];
					
					
					$object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $MerchantName);
					$object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $MerchantURL);
					$object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $AffiliateURL);
					$object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $VoucherCode);
					$object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $VoucherDescription);
					$object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $StartDate);
					$object->getActiveSheet()->setCellValueByColumnAndRow(6, $excel_row, $ExpiryDate);
					$object->getActiveSheet()->setCellValueByColumnAndRow(7, $excel_row, $MerchantID);
					$object->getActiveSheet()->setCellValueByColumnAndRow(8, $excel_row, $VoucherID);
					
					$excel_row++;
					$i++;
					
				}
				
				
				$object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel2007');
				header('Content-Type: application/vnd.ms-excel');
				header('Content-Disposition: attachment;filename="PoR_Coupons_GGD.xlsx"');
				$object_writer->save('php://output');
				redirect(base_url().'API/por_api_coupons','refresh');
			}
			else
			{
				$this->session->set_flashdata('error', " Record has not been found...!");
				redirect(base_url().'API/por_api_coupons','refresh');	
			}
		}
		
		//por API
		public function por_api_stores()
		{
			$data['content']  = 'API/por_api_stores';
			$this->load->view('Template/template',$data);
			
		}
		//PoR SUBMIT
		public function por_api_stores_submit()
		{
			$url = "https://affiliate.paidonresults.com/api/merchant-directory?apikey=ZIJTSQDINTFQXSZMRQYJ&Format=XML&AffiliateID=48834&MerchantCategories=ALL&Fields=MerchantID,MerchantName,MerchantURL,MerchantStatus,MerchantCategory,AffiliateStatus,AffiliateURL&JoinedMerchants=YES&MerchantsNotJoined=NO";
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Contect-Type:application/xml', 'Accept:application/xml',''));
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl,CURLOPT_RETURNTRANSFER,true);
			curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
			
			// Excecuting the curl call
			$result1 =  curl_exec($curl);
			/* echo "<pre>";
				print_r($result1);
			exit; */
			// Close the Curl resource
			curl_close($curl);
			
			$xml = simplexml_load_string($result1);
			$json = json_encode($xml);
			$result = json_decode($json, true);
			
			/* echo "<pre>";
				print_r($result);
			exit; */
			
			$count = 0;
			if(isset($result['Merchants']) && $result['Merchants']!=array())
			{
				
				foreach ($result['Merchants'] as $k => $v) 
				{
					foreach ($v as $k1 => $v1)
					{
						if($result['Merchants'][$k]['MerchantStatus'] != "LIVE")
						{
							continue;
						}
						
						
						if(!empty($result['Merchants'][$k]['MerchantID']))
						{
							$yt_vids[$k]['MerchantID'] = $result['Merchants'][$k]['MerchantID'];
						}
						else
						{
							$yt_vids[$k]['MerchantID'] = "";
						}
						if(!empty($result['Merchants'][$k]['MerchantName']))
						{
							$yt_vids[$k]['MerchantName'] = $result['Merchants'][$k]['MerchantName'];
						}
						else
						{
							$yt_vids[$k]['MerchantName'] = "";
						}
						if(!empty($result['Merchants'][$k]['MerchantURL']))
						{
							$yt_vids[$k]['MerchantURL'] = $result['Merchants'][$k]['MerchantURL'];
						}
						else
						{
							$yt_vids[$k]['MerchantURL'] = "";
						}
						if(!empty($result['Merchants'][$k]['MerchantStatus']))
						{
							$yt_vids[$k]['MerchantStatus'] = $result['Merchants'][$k]['MerchantStatus'];
						}
						else
						{
							$yt_vids[$k]['MerchantStatus'] = "";
						}
						if(!empty($result['Merchants'][$k]['MerchantCategory']))
						{
							$yt_vids[$k]['MerchantCategory'] = $result['Merchants'][$k]['MerchantCategory'];
						}
						else
						{
							$yt_vids[$k]['MerchantCategory'] = "";
						}
						if(!empty($result['Merchants'][$k]['AffiliateStatus']))
						{
							$yt_vids[$k]['AffiliateStatus'] = $result['Merchants'][$k]['AffiliateStatus'];
						}
						else
						{
							$yt_vids[$k]['AffiliateStatus'] = "";
						}
						
						if(!empty($result['Merchants'][$k]['AffiliateURL']))
						{
							$yt_vids[$k]['AffiliateURL'] = $result['Merchants'][$k]['AffiliateURL'];
						}
						else
						{
							$yt_vids[$k]['AffiliateURL'] = "";
						}
						
					}
				}
				/*  echo "<pre>";
					print_r($yt_vids);
				exit;   */
				
				
				
				$this->load->library('PHPExcel');
				$object = new PHPExcel();
				$object->setActiveSheetIndex(0);
				$table_columns = array("MerchantID","MerchantName","MerchantURL","MerchantStatus","MerchantCategory","AffiliateStatus","AffiliateURL");
				$object->getActiveSheet()->setTitle('Por Stores List');
				$column = 0;
				foreach($table_columns as $field)
				{
					$object->getActiveSheet()->setCellValueByColumnAndRow($column, 1, $field);
					$column++;
				}
				for ($col = ord('A'); $col <= ord('Z'); $col++) 
				{
					//set column dimension
					$object->getActiveSheet()->getColumnDimension(chr($col))->setAutoSize(true);
					$object->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
					//change the font size
					$object->getActiveSheet()->getStyle(chr($col))->getFont()->setSize(12);
				} 
				$excel_row = 2;
				$i = 1;
				
				foreach ($yt_vids as $key => $val) 
				{
					$MerchantID = $val['MerchantID'];
					$MerchantName = $val['MerchantName'];
					$MerchantURL = $val['MerchantURL'];
					$MerchantStatus = $val['MerchantStatus'];
					$MerchantCategory = $val['MerchantCategory'];
					$AffiliateStatus = $val['AffiliateStatus'];
					$AffiliateURL = $val['AffiliateURL'];
					
					
					$object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $MerchantID);
					$object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $MerchantName);
					$object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $MerchantURL);
					$object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $MerchantStatus);
					$object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $MerchantCategory);
					$object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $AffiliateStatus);
					$object->getActiveSheet()->setCellValueByColumnAndRow(6, $excel_row, $AffiliateURL);
					$excel_row++;
					$i++;
					
				}
				
				
				$object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel2007');
				header('Content-Type: application/vnd.ms-excel');
				header('Content-Disposition: attachment;filename="PoR_Stores_GGD.xlsx"');
				$object_writer->save('php://output');
				redirect(base_url().'API/por_api_stores','refresh');
			}
			else
			{
				$this->session->set_flashdata('error', " Record has not been found...!");
				redirect(base_url().'API/por_api_stores','refresh');	
			}
		}
		//////////////////////////////////////////////////////////////
		/////////////////// CF API //////////////////////////////////
		/////////////////////////////////////////////////////////////
		//cf API
		public function cf_api_coupons()
		{
			$data['content']  = 'API/cf_api_coupons';
			$this->load->view('Template/template',$data);
			
		}
		
		
		//cf SUBMIT
		public function cf_api_coupons_submit()
		{
			$url = "https://api.commissionfactory.com/V1/Affiliate/Coupons?apiKey=deda48af3ee1489183827cfd2ae7f0e4";
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Contect-Type:application/xml', 'Accept:application/xml',''));
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl,CURLOPT_RETURNTRANSFER,true);
			curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
			
			// Excecuting the curl call
			$result =  curl_exec($curl);
			
			// Close the Curl resource
			curl_close($curl);
			
			$xml = simplexml_load_string($result);
			$json = json_encode($xml);
			$result = json_decode($json, true);
			
			/*  echo "<pre>";
				print_r($result);
				exit; 
			*/
			$count = 0;
			if(isset($result['Coupon']) && $result['Coupon']!=array())
			{
				
				foreach ($result['Coupon'] as $k => $v) 
				{
					foreach ($v as $k1 => $v1)
					{
						$yt_vids[$k]['Code'] = $result['Coupon'][$k]['Code'];
						$yt_vids[$k]['Description'] = $result['Coupon'][$k]['Description'];	
						if(!empty($result['Coupon'][$k]['EndDate']))
						{
							$yt_vids[$k]['EndDate'] = $result['Coupon'][$k]['EndDate'];
						}
						else
						{
							$yt_vids[$k]['EndDate'] = "";
						}
						$yt_vids[$k]['Id'] = $result['Coupon'][$k]['Id'];
						$yt_vids[$k]['MerchantId'] = $result['Coupon'][$k]['MerchantId'];
						$yt_vids[$k]['MerchantName'] = $result['Coupon'][$k]['MerchantName'];
						$yt_vids[$k]['StartDate'] = $result['Coupon'][$k]['StartDate'];
						if(!empty($result['Coupon'][$k]['TermsAndConditions']))
						{
							$yt_vids[$k]['TermsAndConditions'] = $result['Coupon'][$k]['TermsAndConditions'];
						}
						else
						{
							$yt_vids[$k]['TermsAndConditions'] = "";
						}
						$yt_vids[$k]['TrackingUrl'] = $result['Coupon'][$k]['TrackingUrl'];
					}
				}
				/*  echo "<pre>";
					print_r($yt_vids);
				exit;  */
				
				
				
				$this->load->library('PHPExcel');
				$object = new PHPExcel();
				$object->setActiveSheetIndex(0);
				$table_columns = array("Code","Description","EndDate","Id","MerchantId","MerchantName","StartDate","TermsAndConditions","TrackingUrl");
				$object->getActiveSheet()->setTitle('CF Coupons List');
				$column = 0;
				foreach($table_columns as $field)
				{
					$object->getActiveSheet()->setCellValueByColumnAndRow($column, 1, $field);
					$column++;
				}
				for ($col = ord('A'); $col <= ord('Z'); $col++) 
				{
					//set column dimension
					$object->getActiveSheet()->getColumnDimension(chr($col))->setAutoSize(true);
					$object->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('H1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('I1')->getFont()->setBold(true);
					//change the font size
					$object->getActiveSheet()->getStyle(chr($col))->getFont()->setSize(12);
				} 
				$excel_row = 2;
				$i = 1;
				
				foreach ($yt_vids as $key => $val) 
				{
					$Code = $val['Code'];
					$Description = $val['Description'];
					$EndDate = $val['EndDate'];
					$Id = $val['Id'];
					$MerchantId = $val['MerchantId'];
					$MerchantName = $val['MerchantName'];
					$StartDate = $val['StartDate'];
					$TermsAndConditions = $val['TermsAndConditions'];
					$TrackingUrl = $val['TrackingUrl'];
					
					
					$object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $Code);
					$object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $Description);
					$object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $EndDate);
					$object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $Id);
					$object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $MerchantId);
					$object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $MerchantName);
					$object->getActiveSheet()->setCellValueByColumnAndRow(6, $excel_row, $StartDate);
					$object->getActiveSheet()->setCellValueByColumnAndRow(7, $excel_row, $TermsAndConditions);
					$object->getActiveSheet()->setCellValueByColumnAndRow(8, $excel_row, $TrackingUrl);
					
					$excel_row++;
					$i++;
					
				}
				
				
				$object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel2007');
				header('Content-Type: application/vnd.ms-excel');
				header('Content-Disposition: attachment;filename="CF_Coupons_GGD.xlsx"');
				$object_writer->save('php://output');
				redirect(base_url().'API/cf_api_coupons','refresh');
			}
			else
			{
				$this->session->set_flashdata('error', " Record has not been found...!");
				redirect(base_url().'API/cf_api_coupons','refresh');	
			}
		}
		
		//cf API
		public function cf_api_stores()
		{
			$data['content']  = 'API/cf_api_stores';
			$this->load->view('Template/template',$data);
			
		}
		//CF SUBMIT
		public function cf_api_stores_submit()
		{
			$url = "https://api.commissionfactory.com/V1/Affiliate/Merchants?apiKey=deda48af3ee1489183827cfd2ae7f0e4&status=Joined";
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Contect-Type:application/xml', 'Accept:application/xml',''));
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl,CURLOPT_RETURNTRANSFER,true);
			curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
			
			// Excecuting the curl call
			$result1 =  curl_exec($curl);
			
			// Close the Curl resource
			curl_close($curl);
			
			$xml = simplexml_load_string($result1);
			$json = json_encode($xml);
			$result = json_decode($json, true);
			
			/* echo "<pre>";
				print_r($result);
			exit;  */
			
			$count = 0;
			if(isset($result['Merchant']) && $result['Merchant']!=array())
			{
				
				foreach ($result['Merchant'] as $k => $v) 
				{
					foreach ($v as $k1 => $v1)
					{
						if(!empty($result['Merchant'][$k]['Category']))
						{
							$yt_vids[$k]['Category'] = $result['Merchant'][$k]['Category'];
						}
						else
						{
							$yt_vids[$k]['Category'] = "";
						}
						if(!empty($result['Merchant'][$k]['Id']))
						{
							$yt_vids[$k]['Id'] = $result['Merchant'][$k]['Id'];
						}
						else
						{
							$yt_vids[$k]['Id'] = "";
						}
						if(!empty($result['Merchant'][$k]['Name']))
						{
							$yt_vids[$k]['Name'] = $result['Merchant'][$k]['Name'];
						}
						else
						{
							$yt_vids[$k]['Name'] = "";
						}
						if(!empty($result['Merchant'][$k]['Status']))
						{
							$yt_vids[$k]['Status'] = $result['Merchant'][$k]['Status'];
						}
						else
						{
							$yt_vids[$k]['Status'] = "";
						}
						if(!empty($result['Merchant'][$k]['TargetMarket']))
						{
							$yt_vids[$k]['TargetMarket'] = $result['Merchant'][$k]['TargetMarket'];
						}
						else
						{
							$yt_vids[$k]['TargetMarket'] = "";
						}
						if(!empty($result['Merchant'][$k]['TargetUrl']))
						{
							$yt_vids[$k]['TargetUrl'] = $result['Merchant'][$k]['TargetUrl'];
						}
						else
						{
							$yt_vids[$k]['TargetUrl'] = "";
						}
						
						if(!empty($result['Merchant'][$k]['TrackingUrl']))
						{
							$yt_vids[$k]['TrackingUrl'] = $result['Merchant'][$k]['TrackingUrl'];
						}
						else
						{
							$yt_vids[$k]['TrackingUrl'] = "";
						}
						
					}
				}
				/*  echo "<pre>";
					print_r($yt_vids);
				exit;   */
				
				
				
				$this->load->library('PHPExcel');
				$object = new PHPExcel();
				$object->setActiveSheetIndex(0);
				$table_columns = array("Category","Id","Name","Status","TargetMarket","TargetUrl","TrackingUrl");
				$object->getActiveSheet()->setTitle('CF Stores List');
				$column = 0;
				foreach($table_columns as $field)
				{
					$object->getActiveSheet()->setCellValueByColumnAndRow($column, 1, $field);
					$column++;
				}
				for ($col = ord('A'); $col <= ord('Z'); $col++) 
				{
					//set column dimension
					$object->getActiveSheet()->getColumnDimension(chr($col))->setAutoSize(true);
					$object->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
					//change the font size
					$object->getActiveSheet()->getStyle(chr($col))->getFont()->setSize(12);
				} 
				$excel_row = 2;
				$i = 1;
				
				foreach ($yt_vids as $key => $val) 
				{
					$Category = $val['Category'];
					$Id = $val['Id'];
					$Name = $val['Name'];
					$Status = $val['Status'];
					$TargetMarket = $val['TargetMarket'];
					$TargetUrl = $val['TargetUrl'];
					$TrackingUrl = $val['TrackingUrl'];
					
					
					$object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $Category);
					$object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $Id);
					$object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $Name);
					$object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $Status);
					$object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $TargetMarket);
					$object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $TargetUrl);
					$object->getActiveSheet()->setCellValueByColumnAndRow(6, $excel_row, $TrackingUrl);
					$excel_row++;
					$i++;
					
				}
				
				
				$object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel2007');
				header('Content-Type: application/vnd.ms-excel');
				header('Content-Disposition: attachment;filename="CF_Stores_GGD.xlsx"');
				$object_writer->save('php://output');
				redirect(base_url().'API/cf_api_stores','refresh');
			}
			else
			{
				$this->session->set_flashdata('error', " Record has not been found...!");
				redirect(base_url().'API/cf_api_stores','refresh');	
			}
		}
		//////////////////////////////////////////////////////////////
		/////////////////// TT API //////////////////////////////////
		/////////////////////////////////////////////////////////////
		//tt API
		public function tt_api_coupons()
		{
			$data['content']  = 'API/tt_api_coupons';
			$this->load->view('Template/template',$data);
			
		}
		
		
		//tt SUBMIT
		public function tt_api_coupons_submit()
		{
			
			$client = new SoapClient('http://ws.tradetracker.com/soap/affiliate?wsdl', array('compression' => SOAP_COMPRESSION_ACCEPT | SOAP_COMPRESSION_GZIP));
			$client->authenticate(174956, '3cd6b5d08f4c06546539d26bf590969c654c0d76');
			
			$affiliateSiteID = 311604;
			$materialOutputType = 'html';
			
			$options = array(
			//'reference' => 'my-test-ref',
			// 'limit' => 10,
			);
			
			$array = $client->getMaterialIncentiveVoucherItems($affiliateSiteID, $materialOutputType, $options);
			$result = json_decode(json_encode($array), true);
			/* echo "<pre>";
				print_r($result);
			exit; */
			
			$count = 0;
			if($client->getMaterialIncentiveVoucherItems($affiliateSiteID, $materialOutputType, $options))
			{
				
				foreach ($result as $k => $v) 
				{
					foreach ($v as $k1 => $v1)
					{
						$yt_vids[$k]['ID'] = htmlspecialchars($result[$k]['ID']);
						if(!empty($result[$k]['campaign']['ID']))
						{
							$yt_vids[$k]['campaignID'] = htmlspecialchars($result[$k]['campaign']['ID']);
						}
						else
						{
							$yt_vids[$k]['campaignID'] = "";
						}
						if(!empty($result[$k]['campaign']['name']))
						{
							$yt_vids[$k]['campaignName'] = htmlspecialchars($result[$k]['campaign']['name']);
						}
						else
						{
							$yt_vids[$k]['campaignName'] = "";
						} 
						if(!empty($result[$k]['campaign']['URL']))
						{
							$yt_vids[$k]['campaignURL'] = htmlspecialchars($result[$k]['campaign']['URL']);
						}
						else
						{
							$yt_vids[$k]['campaignURL'] = "";
						} 
						if(!empty($result[$k]['campaign']['info']))
						{
							$yt_vids[$k]['campaignInfo'] = htmlspecialchars($result[$k]['campaign']['info']);
						}
						else
						{
							$yt_vids[$k]['campaignInfo'] = "";
						} 
						
						if(!empty($result[$k]['name']))
						{
							$yt_vids[$k]['name'] = htmlspecialchars($result[$k]['name']);
						}
						else
						{
							$yt_vids[$k]['name'] = "";
						}
						if(!empty($result[$k]['description']))
						{
							$yt_vids[$k]['description'] = htmlspecialchars($result[$k]['description']);
						}
						else
						{
							$yt_vids[$k]['description'] = "";
						}
						if(!empty($result[$k]['conditions']))
						{
							$yt_vids[$k]['conditions'] = htmlspecialchars($result[$k]['conditions']);
						}
						else
						{
							$yt_vids[$k]['conditions'] = "";
						}
						if(!empty($result[$k]['validFromDate']))
						{
							$yt_vids[$k]['validFromDate'] = htmlspecialchars($result[$k]['validFromDate']);
						}
						else
						{
							$yt_vids[$k]['validFromDate'] = "";
						}
						if(!empty($result[$k]['validToDate']))
						{
							$yt_vids[$k]['validToDate'] = htmlspecialchars($result[$k]['validToDate']);
						}
						else
						{
							$yt_vids[$k]['validToDate'] = "";
						}
						if(!empty($result[$k]['voucherCode']))
						{
							$yt_vids[$k]['voucherCode'] = htmlspecialchars($result[$k]['voucherCode']);
						}
						else
						{
							$yt_vids[$k]['voucherCode'] = "";
						}
						if(!empty($result[$k]['discountFixed']))
						{
							$yt_vids[$k]['discountFixed'] = htmlspecialchars($result[$k]['discountFixed']);
						}
						else
						{
							$yt_vids[$k]['discountFixed'] = "";
						}
						if(!empty($result[$k]['discountVariable']))
						{
							$yt_vids[$k]['discountVariable'] = htmlspecialchars($result[$k]['discountVariable']);
						}
						else
						{
							$yt_vids[$k]['discountVariable'] = "";
						}
						if(!empty($result[$k]['code']))
						{
							$yt_vids[$k]['code'] = strip_tags($result[$k]['code']);
						}
						else
						{
							$yt_vids[$k]['code'] = "";
						}
					}
				}
				/*  echo "<pre>";
					print_r($yt_vids);
				exit;  */ 
				
				
				
				$this->load->library('PHPExcel');
				$object = new PHPExcel();
				$object->setActiveSheetIndex(0);
				$table_columns = array("ID","campaignID","campaignName","campaignURL","campaignInfo","name","description","conditions","validFromDate","validToDate","voucherCode","discountFixed","discountVariable","code");
				$object->getActiveSheet()->setTitle('TT Coupons List');
				$column = 0;
				foreach($table_columns as $field)
				{
					$object->getActiveSheet()->setCellValueByColumnAndRow($column, 1, $field);
					$column++;
				}
				for ($col = ord('A'); $col <= ord('Z'); $col++) 
				{
					//set column dimension
					$object->getActiveSheet()->getColumnDimension(chr($col))->setAutoSize(true);
					$object->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('H1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('I1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('J1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('K1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('L1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('M1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('N1')->getFont()->setBold(true);
					//change the font size
					$object->getActiveSheet()->getStyle(chr($col))->getFont()->setSize(12);
				} 
				$excel_row = 2;
				$i = 1;
				
				foreach ($yt_vids as $key => $val) 
				{
					$ID = $val['ID'];
					$campaignID = $val['campaignID'];
					$campaignName = $val['campaignName'];
					$campaignURL = $val['campaignURL'];
					$campaignInfo = $val['campaignInfo'];
					$name = $val['name'];
					$description = $val['description'];
					$conditions = $val['conditions'];
					$validFromDate = $val['validFromDate'];
					$validToDate = $val['validToDate'];
					$voucherCode = $val['voucherCode'];
					$discountFixed = $val['discountFixed'];
					$discountVariable = $val['discountVariable'];
					$code = $val['code'];
					
					
					$object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $ID);
					$object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $campaignID);
					$object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $campaignName);
					$object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $campaignURL);
					$object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $campaignInfo);
					$object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $name);
					$object->getActiveSheet()->setCellValueByColumnAndRow(6, $excel_row, $description);
					$object->getActiveSheet()->setCellValueByColumnAndRow(7, $excel_row, $conditions);
					$object->getActiveSheet()->setCellValueByColumnAndRow(8, $excel_row, $validFromDate);
					$object->getActiveSheet()->setCellValueByColumnAndRow(9, $excel_row, $validToDate);
					$object->getActiveSheet()->setCellValueByColumnAndRow(10, $excel_row, $voucherCode);
					$object->getActiveSheet()->setCellValueByColumnAndRow(11, $excel_row, $discountFixed);
					$object->getActiveSheet()->setCellValueByColumnAndRow(12, $excel_row, $discountVariable);
					$object->getActiveSheet()->setCellValueByColumnAndRow(13, $excel_row, $code);
					
					$excel_row++;
					$i++;
					
				}
				
				
				$object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel2007');
				header('Content-Type: application/vnd.ms-excel');
				header('Content-Disposition: attachment;filename="TT_Coupons_GGD.xlsx"');
				$object_writer->save('php://output');
				redirect(base_url().'API/tt_api_coupons','refresh');
			}
			else
			{
				$this->session->set_flashdata('error', " Record has not been found...!");
				redirect(base_url().'API/tt_api_coupons','refresh');	
			}
		}
		
		//tt API
		public function tt_api_stores()
		{
			$data['content']  = 'API/tt_api_stores';
			$this->load->view('Template/template',$data);
			
		}
		//tt SUBMIT
		public function tt_api_stores_submit()
		{
			$client = new SoapClient('http://ws.tradetracker.com/soap/affiliate?wsdl', array('compression' => SOAP_COMPRESSION_ACCEPT | SOAP_COMPRESSION_GZIP));
			$client->authenticate(174956, '3cd6b5d08f4c06546539d26bf590969c654c0d76');
			
			$affiliateSiteID = 311604;
			
			$options = array (
			//'query' => 'snow',
			'assignmentStatus' => 'accepted',
			);
			
			
			
			$array = $client->getCampaigns($affiliateSiteID, $options);
			$result = json_decode(json_encode($array), true);
			
			
			$count = 0;
			if($client->getCampaigns($affiliateSiteID, $options))
			{
				
				foreach ($result as $k => $v) 
				{
					foreach ($v as $k1 => $v1)
					{
						$yt_vids[$k]['ID'] = htmlspecialchars($result[$k]['ID']);
						$yt_vids[$k]['name'] = htmlspecialchars($result[$k]['name']);
						$yt_vids[$k]['URL'] = htmlspecialchars($result[$k]['URL']);
						if(!empty($result[$k]['info']['category']['name']))
						{
							$yt_vids[$k]['category'] = htmlspecialchars($result[$k]['info']['category']['name']);
						}
						else
						{
							$yt_vids[$k]['category'] = "";
						}
						if(!empty($result[$k]['info']['campaignDescription']))
						{
							$yt_vids[$k]['campaignDescription'] = htmlspecialchars($result[$k]['info']['campaignDescription']);
						}
						else
						{
							$yt_vids[$k]['campaignDescription'] = "";
						}
						if(!empty($result[$k]['info']['targetGroup']))
						{
							$yt_vids[$k]['targetGroup'] = htmlspecialchars($result[$k]['info']['targetGroup']);
						}
						else
						{
							$yt_vids[$k]['targetGroup'] = "";
						}
						if(!empty($result[$k]['info']['trackingURL']))
						{
							$yt_vids[$k]['trackingURL'] = htmlspecialchars($result[$k]['info']['trackingURL']);
						}
						else
						{
							$yt_vids[$k]['trackingURL'] = "";
						}
						if(!empty($result[$k]['info']['assignmentStatus']))
						{
							$yt_vids[$k]['assignmentStatus'] = htmlspecialchars($result[$k]['info']['assignmentStatus']);
						}
						else
						{
							$yt_vids[$k]['assignmentStatus'] = "";
						}
						
						
					}
				}
				/*  echo "<pre>";
					print_r($yt_vids);
				exit; */   
				
				
				
				$this->load->library('PHPExcel');
				$object = new PHPExcel();
				$object->setActiveSheetIndex(0);
				$table_columns = array("ID","name","URL","category","campaignDescription","targetGroup","trackingURL","assignmentStatus");
				$object->getActiveSheet()->setTitle('TT Stores List');
				$column = 0;
				foreach($table_columns as $field)
				{
					$object->getActiveSheet()->setCellValueByColumnAndRow($column, 1, $field);
					$column++;
				}
				for ($col = ord('A'); $col <= ord('Z'); $col++) 
				{
					//set column dimension
					$object->getActiveSheet()->getColumnDimension(chr($col))->setAutoSize(true);
					$object->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('H1')->getFont()->setBold(true);
					//change the font size
					$object->getActiveSheet()->getStyle(chr($col))->getFont()->setSize(12);
				} 
				$excel_row = 2;
				$i = 1;
				
				foreach ($yt_vids as $key => $val) 
				{
					$ID = $val['ID'];
					$name = $val['name'];
					$URL = $val['URL'];
					$category = $val['category'];
					$campaignDescription = $val['campaignDescription'];
					$targetGroup = $val['targetGroup'];
					$trackingURL = $val['trackingURL'];
					$assignmentStatus = $val['assignmentStatus'];
					
					
					$object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $ID);
					$object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $name);
					$object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $URL);
					$object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $category);
					$object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $campaignDescription);
					$object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $targetGroup);
					$object->getActiveSheet()->setCellValueByColumnAndRow(6, $excel_row, $trackingURL);
					$object->getActiveSheet()->setCellValueByColumnAndRow(7, $excel_row, $assignmentStatus);
					$excel_row++;
					$i++;
					
				}
				
				
				$object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel2007');
				header('Content-Type: application/vnd.ms-excel');
				header('Content-Disposition: attachment;filename="TT_Stores_GGD.xlsx"');
				$object_writer->save('php://output');
				redirect(base_url().'API/tt_api_stores','refresh');
			}
			else
			{
				$this->session->set_flashdata('error', " Record has not been found...!");
				redirect(base_url().'API/tt_api_stores','refresh');	
			}
		}
		//////////////////////////////////////////////////////////////
		/////////////////// PJ API //////////////////////////////////
		/////////////////////////////////////////////////////////////
		//pj API
		public function pj_api_coupons()
		{
			$data['content']  = 'API/pj_api_coupons';
			$this->load->view('Template/template',$data);
			
		}
		
		
		//pj SUBMIT
		public function pj_api_coupons_submit()
		{
			$post = $this->input->post();
			$records_per_page = $post['records_per_page'];
			$page_number1 = $post['page_number'];
			
			$url = "https://api.pepperjamnetwork.com/20120402/publisher/creative/coupon?apiKey=f35bc60abbc3115093423c3f6dc3161fc5efd8a27d0b11b9b82daf9406db5df2&format=xml&status=active&page=".$page_number1;
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Contect-Type:application/xml', 'Accept:application/xml',''));
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl,CURLOPT_RETURNTRANSFER,true);
			curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
			
			$result1 =  curl_exec($curl);
			
			// Close the Curl resource
			curl_close($curl);
			
			$xml = simplexml_load_string($result1, null, LIBXML_NOCDATA);
			$json = json_encode($xml);
			$result = json_decode($json, true);
			
			/*  echo "<pre>";
				print_r($result);
			exit;  */  
			
			
			$count = 0;
			if(isset($result['data']) && $result['data']!=array())
			{
				
				$total_matched = $result['meta']['pagination']['total_results'];
				$records_returned = $records_per_page;
				$page_number = $page_number1;
				$total_pages = $result['meta']['pagination']['total_pages'];
				$message = '<br/>Success: Coupons Record Successfully Found.<br/>Total Rows ('.$total_matched.')<br/>Total Pages ('.$total_pages.')<br/>Record Per Page ('.$records_returned.')<br/>Page Number ('.$page_number.')';
				$data['result']  =  $message;
				$data['records_per_page']  =  $records_per_page;
				$data['page_number']  =  $page_number1;
				$data['content']  = 'API/pj_api_coupons';
				$this->load->view('Template/template',$data);
			}
			else
			{
				
				$message = "Error: Record Not Found..!";
				$data['result']  =  $message;
				$data['records_per_page']  =  $records_per_page;
				$data['page_number']  =  $page_number1;
				$data['content']  = 'API/pj_api_coupons';
				$this->load->view('Template/template',$data);
			}
		}
		public function pj_api_coupons_download()
		{
			$post = $this->input->post();
			$records_per_page = $post['records_per_page'];
			$page_number1 = $post['page_number'];
			
			$url = "https://api.pepperjamnetwork.com/20120402/publisher/creative/coupon?apiKey=f35bc60abbc3115093423c3f6dc3161fc5efd8a27d0b11b9b82daf9406db5df2&format=xml&status=active&page=".$page_number1;
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Contect-Type:application/xml', 'Accept:application/xml',''));
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl,CURLOPT_RETURNTRANSFER,true);
			curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
			
			$result1 =  curl_exec($curl);
			
			// Close the Curl resource
			curl_close($curl);
			
			$xml = simplexml_load_string($result1, null, LIBXML_NOCDATA);
			$json = json_encode($xml);
			$result = json_decode($json, true);
			
			/* echo "<pre>";
				print_r($result);
			exit;  */
			
			
			$count = 0;
			if(isset($result['data']) && $result['data']!=array())
			{
				
				foreach ($result['data'] as $k => $v) 
				{
					foreach ($v as $k1 => $v1)
					{
						
						if(!empty($result['data'][$k]['id']))
						{
							$yt_vids[$k]['id'] = $result['data'][$k]['id'];
						}
						else
						{
							$yt_vids[$k]['id'] = "";
						}
						if(!empty($result['data'][$k]['name']))
						{
							$yt_vids[$k]['name'] = $result['data'][$k]['name'];
						}
						else
						{
							$yt_vids[$k]['name'] = "";
						}
						if(!empty($result['data'][$k]['code']))
						{
							$yt_vids[$k]['code'] = $result['data'][$k]['code'];
						}
						else
						{
							$yt_vids[$k]['code'] = "";
						}
						if(!empty($result['data'][$k]['description']))
						{
							$yt_vids[$k]['description'] = $result['data'][$k]['description'];
						}
						else
						{
							$yt_vids[$k]['description'] = "";
						}
						if(!empty($result['data'][$k]['start_date']))
						{
							$yt_vids[$k]['start_date'] = $result['data'][$k]['start_date'];
						}
						else
						{
							$yt_vids[$k]['start_date'] = "";
						}
						if(!empty($result['data'][$k]['end_date']))
						{
							$yt_vids[$k]['end_date'] = $result['data'][$k]['end_date'];
						}
						else
						{
							$yt_vids[$k]['end_date'] = "";
						}
						if(!empty($result['data'][$k]['status']))
						{
							$yt_vids[$k]['status'] = $result['data'][$k]['status'];
						}
						else
						{
							$yt_vids[$k]['status'] = "";
						}
						if(!empty($result['data'][$k]['exclusive']))
						{
							$yt_vids[$k]['exclusive'] = $result['data'][$k]['exclusive'];
						}
						else
						{
							$yt_vids[$k]['exclusive'] = "";
						}
						if(!empty($result['data'][$k]['coupon']))
						{
							$yt_vids[$k]['coupon'] = $result['data'][$k]['coupon'];
						}
						else
						{
							$yt_vids[$k]['coupon'] = "";
						}
						if(!empty($result['data'][$k]['program_id']))
						{
							$yt_vids[$k]['program_id'] = $result['data'][$k]['program_id'];
						}
						else
						{
							$yt_vids[$k]['program_id'] = "";
						}
						if(!empty($result['data'][$k]['program_name']))
						{
							$yt_vids[$k]['program_name'] = $result['data'][$k]['program_name'];
						}
						else
						{
							$yt_vids[$k]['program_name'] = "";
						}
						if(!empty($result['data'][$k]['category_name']))
						{
							$yt_vids[$k]['category_name'] = $result['data'][$k]['category_name'];
						}
						else
						{
							$yt_vids[$k]['category_name'] = "";
						}
						
					}
				}
				/* echo "<pre>";
					print_r($yt_vids);
				exit;  */ 
				
				
				
				$this->load->library('PHPExcel');
				$object = new PHPExcel();
				$object->setActiveSheetIndex(0);
				$table_columns = array("id","name","code","description","start_date","end_date","status","exclusive","coupon","program_id","program_name","category_name");
				$object->getActiveSheet()->setTitle('PJ Coupons List');
				$column = 0;
				foreach($table_columns as $field)
				{
					$object->getActiveSheet()->setCellValueByColumnAndRow($column, 1, $field);
					$column++;
				}
				for ($col = ord('A'); $col <= ord('Z'); $col++) 
				{
					//set column dimension
					$object->getActiveSheet()->getColumnDimension(chr($col))->setAutoSize(true);
					$object->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('H1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('I1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('J1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('K1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('L1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('M1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('N1')->getFont()->setBold(true);
					//change the font size
					$object->getActiveSheet()->getStyle(chr($col))->getFont()->setSize(12);
				} 
				$excel_row = 2;
				$i = 1;
				
				foreach ($yt_vids as $key => $val) 
				{
					$id = $val['id'];
					$name = $val['name'];
					$code = $val['code'];
					$description = $val['description'];
					$start_date = $val['start_date'];
					$end_date = $val['end_date'];
					$status = $val['status'];
					$exclusive = $val['exclusive'];
					$coupon = $val['coupon'];
					$program_id = $val['program_id'];
					$program_name = $val['program_name'];
					$category_name = $val['category_name'];
					
					
					$object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $id);
					$object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $name);
					$object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $code);
					$object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $description);
					$object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $start_date);
					$object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $end_date);
					$object->getActiveSheet()->setCellValueByColumnAndRow(6, $excel_row, $status);
					$object->getActiveSheet()->setCellValueByColumnAndRow(7, $excel_row, $exclusive);
					$object->getActiveSheet()->setCellValueByColumnAndRow(8, $excel_row, $coupon);
					$object->getActiveSheet()->setCellValueByColumnAndRow(9, $excel_row, $program_id);
					$object->getActiveSheet()->setCellValueByColumnAndRow(10, $excel_row, $program_name);
					$object->getActiveSheet()->setCellValueByColumnAndRow(11, $excel_row, $category_name);
					
					$excel_row++;
					$i++;
					
				}
				
				
				$object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel2007');
				header('Content-Type: application/vnd.ms-excel');
				header('Content-Disposition: attachment;filename="PJ_Coupons_GGD.xlsx"');
				$object_writer->save('php://output');
				redirect(base_url().'API/pj_api_coupons','refresh');
			}
			else
			{
				$this->session->set_flashdata('error', " Record has not been found...!");
				redirect(base_url().'API/pj_api_coupons','refresh');	
			}
		}
		
		//pj API
		public function pj_api_stores()
		{
			$data['content']  = 'API/pj_api_stores';
			$this->load->view('Template/template',$data);
			
		}
		//pj SUBMIT
		public function pj_api_stores_submit()
		{
			$url = "https://api.pepperjamnetwork.com/20120402/publisher/creative/text?apiKey=f35bc60abbc3115093423c3f6dc3161fc5efd8a27d0b11b9b82daf9406db5df2&format=xml&status=active";
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Contect-Type:application/xml', 'Accept:application/xml',''));
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl,CURLOPT_RETURNTRANSFER,true);
			curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
			
			// Excecuting the curl call
			$result1 =  curl_exec($curl);
			
			// Close the Curl resource
			curl_close($curl);
			
			$xml = simplexml_load_string($result1, null, LIBXML_NOCDATA);
			$json = json_encode($xml);
			$result = json_decode($json, true);
			
			echo "<pre>";
			print_r($result);
			exit;  
			
			$count = 0;
			if(isset($result['data']) && $result['data']!=array())
			{
				
				foreach ($result['data'] as $k => $v) 
				{
					foreach ($v as $k1 => $v1)
					{
						if(!empty($result['data'][$k]['id']))
						{
							$yt_vids[$k]['id'] = $result['data'][$k]['id'];
						}
						else
						{
							$yt_vids[$k]['id'] = "";
						}
						if(!empty($result['data'][$k]['name']))
						{
							$yt_vids[$k]['name'] = $result['data'][$k]['name'];
						}
						else
						{
							$yt_vids[$k]['name'] = "";
						}
						if(!empty($result['data'][$k]['category'][0]['name']))
						{
							$yt_vids[$k]['category'] = $result['data'][$k]['category'][0]['name'];
						}
						else
						{
							$yt_vids[$k]['category'] = "";
						}
						if(!empty($result['data'][$k]['website']))
						{
							$yt_vids[$k]['website'] = $result['data'][$k]['website'];
						}
						else
						{
							$yt_vids[$k]['website'] = "";
						}
						if(!empty($result['data'][$k]['status']))
						{
							$yt_vids[$k]['status'] = $result['data'][$k]['status'];
						}
						else
						{
							$yt_vids[$k]['status'] = "";
						}
						
					}
				}
				/* echo "<pre>";
					print_r($yt_vids);
				exit;    */
				
				
				
				$this->load->library('PHPExcel');
				$object = new PHPExcel();
				$object->setActiveSheetIndex(0);
				$table_columns = array("id","name","category","website","status");
				$object->getActiveSheet()->setTitle('PJ Stores List');
				$column = 0;
				foreach($table_columns as $field)
				{
					$object->getActiveSheet()->setCellValueByColumnAndRow($column, 1, $field);
					$column++;
				}
				for ($col = ord('A'); $col <= ord('Z'); $col++) 
				{
					//set column dimension
					$object->getActiveSheet()->getColumnDimension(chr($col))->setAutoSize(true);
					$object->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
					//change the font size
					$object->getActiveSheet()->getStyle(chr($col))->getFont()->setSize(12);
				} 
				$excel_row = 2;
				$i = 1;
				
				foreach ($yt_vids as $key => $val) 
				{
					$id = $val['id'];
					$name = $val['name'];
					$category = $val['category'];
					$website = $val['website'];
					$status = $val['status'];
					//$AffiliateStatus = $val['AffiliateStatus'];
					//$AffiliateURL = $val['AffiliateURL'];
					
					
					$object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $id);
					$object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $name);
					$object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $category);
					$object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $website);
					$object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $status);
					//$object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $AffiliateStatus);
					//$object->getActiveSheet()->setCellValueByColumnAndRow(6, $excel_row, $AffiliateURL);
					$excel_row++;
					$i++;
					
				}
				
				
				$object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel2007');
				header('Content-Type: application/vnd.ms-excel');
				header('Content-Disposition: attachment;filename="PJ_Stores_GGD.xlsx"');
				$object_writer->save('php://output');
				redirect(base_url().'API/pj_api_stores','refresh');
			}
			else
			{
				$this->session->set_flashdata('error', " Record has not been found...!");
				redirect(base_url().'API/pj_api_stores','refresh');	
			}
		}
		
		//////////////////////////////////////////////////////////////
		/////////////////// TD API //////////////////////////////////
		/////////////////////////////////////////////////////////////
		//td  API
		public function td_api_coupons()
		{
			$data['content']  = 'API/td_api_coupons';
			$this->load->view('Template/template',$data);
			
		}
		
		//
		public function td_api_coupons_submit()
		{
			$post = $this->input->post();
			/* $records_per_page = $post['records_per_page'];
			$page_number1 = $post['page_number']; */
			
			$url = "https://api.tradedoubler.com/1.0/vouchers.xml?token=06968432A4F8FA6B40660B7C3556690FC16B97D1";
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Contect-Type:application/xml', 'Accept:application/xml',''));
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl,CURLOPT_RETURNTRANSFER,true);
			curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
			
			$result1 =  curl_exec($curl);
			
			// Close the Curl resource
			curl_close($curl);
			
			$xml = simplexml_load_string($result1);
			$json = json_encode($xml);
			$result = json_decode($json, true);
			
			/*   echo "<pre>";
				print_r($result);
			exit;  */ 
			
			
			$count = 0;
			if(isset($result['voucher']) && $result['voucher']!=array())
			{
				
				foreach ($result['voucher'] as $k => $v) 
				{
					foreach ($v as $k1 => $v1)
					{
						
						if(!empty($result['voucher'][$k]['id']))
						{
							$yt_vids[$k]['id'] = $result['voucher'][$k]['id'];
						}
						else
						{
							$yt_vids[$k]['id'] = "";
						}
						if(!empty($result['voucher'][$k]['programId']))
						{
							$yt_vids[$k]['programId'] = $result['voucher'][$k]['programId'];
						}
						else
						{
							$yt_vids[$k]['programId'] = "";
						}
						if(!empty($result['voucher'][$k]['programName']))
						{
							$yt_vids[$k]['programName'] = $result['voucher'][$k]['programName'];
						}
						else
						{
							$yt_vids[$k]['programName'] = "";
						}
						if(!empty($result['voucher'][$k]['code']))
						{
							$yt_vids[$k]['code'] = $result['voucher'][$k]['code'];
						}
						else
						{
							$yt_vids[$k]['code'] = "";
						}
						if(!empty($result['voucher'][$k]['startDate']))
						{
							$timestamp=substr($result['voucher'][$k]['startDate'],0,10);
							$stop_date = gmdate("d-m-Y", $timestamp);
							$final_date = date('d-m-Y', strtotime($stop_date.'+1 day'));
							$yt_vids[$k]['startDate'] = $final_date;
						}
						else
						{
							$yt_vids[$k]['startDate'] = "";
						}
						if(!empty($result['voucher'][$k]['endDate']))
						{
							$timestamp1=substr($result['voucher'][$k]['endDate'],0,10);
							$stop_date1 = gmdate("d-m-Y", $timestamp1);
							$final_date1 = date('d-m-Y', strtotime($stop_date1.'+1 day'));
							$yt_vids[$k]['endDate'] = $final_date1;
						}
						else
						{
							$yt_vids[$k]['endDate'] = "";
						}
						if(!empty($result['voucher'][$k]['title']))
						{
							$yt_vids[$k]['title'] = $result['voucher'][$k]['title'];
						}
						else
						{
							$yt_vids[$k]['title'] = "";
						}
						if(!empty($result['voucher'][$k]['shortDescription']))
						{
							$yt_vids[$k]['shortDescription'] = $result['voucher'][$k]['shortDescription'];
						}
						else
						{
							$yt_vids[$k]['shortDescription'] = "";
						}
						if(!empty($result['voucher'][$k]['description']))
						{
							$yt_vids[$k]['description'] = $result['voucher'][$k]['description'];
						}
						else
						{
							$yt_vids[$k]['description'] = "";
						}
						if(!empty($result['voucher'][$k]['defaultTrackUri']))
						{
							$yt_vids[$k]['defaultTrackUri'] = $result['voucher'][$k]['defaultTrackUri'];
						}
						else
						{
							$yt_vids[$k]['defaultTrackUri'] = "";
						}
						if(!empty($result['voucher'][$k]['discountAmount']))
						{
							$yt_vids[$k]['discountAmount'] = $result['voucher'][$k]['discountAmount'];
						}
						else
						{
							$yt_vids[$k]['discountAmount'] = "";
						}
						if(!empty($result['voucher'][$k]['isPercentage']))
						{
							$yt_vids[$k]['isPercentage'] = $result['voucher'][$k]['isPercentage'];
						}
						else
						{
							$yt_vids[$k]['isPercentage'] = "";
						}
						if(!empty($result['voucher'][$k]['currencyId']))
						{
							$yt_vids[$k]['currencyId'] = $result['voucher'][$k]['currencyId'];
						}
						else
						{
							$yt_vids[$k]['currencyId'] = "";
						}
						
					}
				}
				/*  echo "<pre>";
					print_r($yt_vids);
				exit; */  
				
				
				
				$this->load->library('PHPExcel');
				$object = new PHPExcel();
				$object->setActiveSheetIndex(0);
				$table_columns = array("id","programId","programName","code","startDate","endDate","title","shortDescription","description","defaultTrackUri","discountAmount","isPercentage","currencyId");
				$object->getActiveSheet()->setTitle('TD Coupons List');
				$column = 0;
				foreach($table_columns as $field)
				{
					$object->getActiveSheet()->setCellValueByColumnAndRow($column, 1, $field);
					$column++;
				}
				for ($col = ord('A'); $col <= ord('Z'); $col++) 
				{
					//set column dimension
					$object->getActiveSheet()->getColumnDimension(chr($col))->setAutoSize(true);
					$object->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('H1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('I1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('J1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('K1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('L1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('M1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('N1')->getFont()->setBold(true);
					//change the font size
					$object->getActiveSheet()->getStyle(chr($col))->getFont()->setSize(12);
				} 
				$excel_row = 2;
				$i = 1;
				
				foreach ($yt_vids as $key => $val) 
				{
					$id = $val['id'];
					$programId = $val['programId'];
					$programName = $val['programName'];
					$code = $val['code'];
					$startDate = $val['startDate'];
					$endDate = $val['endDate'];
					$title = $val['title'];
					$shortDescription = $val['shortDescription'];
					$description = $val['description'];
					$defaultTrackUri = $val['defaultTrackUri'];
					$discountAmount = $val['discountAmount'];
					$isPercentage = $val['isPercentage'];
					$currencyId = $val['currencyId'];
					
					
					$object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $id);
					$object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $programId);
					$object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $programName);
					$object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $code);
					$object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $startDate);
					$object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $endDate);
					$object->getActiveSheet()->setCellValueByColumnAndRow(6, $excel_row, $title);
					$object->getActiveSheet()->setCellValueByColumnAndRow(7, $excel_row, $shortDescription);
					$object->getActiveSheet()->setCellValueByColumnAndRow(8, $excel_row, $description);
					$object->getActiveSheet()->setCellValueByColumnAndRow(9, $excel_row, $defaultTrackUri);
					$object->getActiveSheet()->setCellValueByColumnAndRow(10, $excel_row, $discountAmount);
					$object->getActiveSheet()->setCellValueByColumnAndRow(11, $excel_row, $isPercentage);
					$object->getActiveSheet()->setCellValueByColumnAndRow(12, $excel_row, $currencyId);
					
					$excel_row++;
					$i++;
					
				}
				
				
				$object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel2007');
				header('Content-Type: application/vnd.ms-excel');
				header('Content-Disposition: attachment;filename="TD_Coupons_GGD.xlsx"');
				$object_writer->save('php://output');
				redirect(base_url().'API/pj_api_coupons','refresh');
			}
			else
			{
				$this->session->set_flashdata('error', " Record has not been found...!");
				redirect(base_url().'API/td_api_coupons','refresh');	
			}
		}
		
		
		
		//td API
		public function td_api_stores()
		{
			$data['content']  = 'API/td_api_stores';
			$this->load->view('Template/template',$data);
			
		}
		//
		public function td_api_stores_submit()
		{
			$post = $this->input->post();
			/* $records_per_page = $post['records_per_page'];
			$page_number1 = $post['page_number']; */
			
			$url = "http://api.tradedoubler.com/1.0/products.json?token=95BA9D5DAE28FC7A856FEABC5F0DEE6EDB417C6C";
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Contect-Type:application/xml', 'Accept:application/xml',''));
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl,CURLOPT_RETURNTRANSFER,true);
			curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
			
			$result1 =  curl_exec($curl);
			/*  echo "<pre>";
				print_r($result1);
			exit;  */ 
			// Close the Curl resource
			curl_close($curl);
			
			//$xml = simplexml_load_string($result1);
			$json = json_encode($result1);
			$result = json_decode($json, true);
			
			echo "<pre>";
			print_r($result);
			exit;  
			
			
			$count = 0;
			if(isset($result['voucher']) && $result['voucher']!=array())
			{
				
				foreach ($result['voucher'] as $k => $v) 
				{
					foreach ($v as $k1 => $v1)
					{
						
						if(!empty($result['voucher'][$k]['id']))
						{
							$yt_vids[$k]['id'] = $result['voucher'][$k]['id'];
						}
						else
						{
							$yt_vids[$k]['id'] = "";
						}
						if(!empty($result['voucher'][$k]['programId']))
						{
							$yt_vids[$k]['programId'] = $result['voucher'][$k]['programId'];
						}
						else
						{
							$yt_vids[$k]['programId'] = "";
						}
						if(!empty($result['voucher'][$k]['programName']))
						{
							$yt_vids[$k]['programName'] = $result['voucher'][$k]['programName'];
						}
						else
						{
							$yt_vids[$k]['programName'] = "";
						}
						if(!empty($result['voucher'][$k]['code']))
						{
							$yt_vids[$k]['code'] = $result['voucher'][$k]['code'];
						}
						else
						{
							$yt_vids[$k]['code'] = "";
						}
						if(!empty($result['voucher'][$k]['startDate']))
						{
							$timestamp=substr($result['voucher'][$k]['startDate'],0,10);
							$stop_date = gmdate("d-m-Y", $timestamp);
							$final_date = date('d-m-Y', strtotime($stop_date.'+1 day'));
							$yt_vids[$k]['startDate'] = $final_date;
						}
						else
						{
							$yt_vids[$k]['startDate'] = "";
						}
						if(!empty($result['voucher'][$k]['endDate']))
						{
							$timestamp1=substr($result['voucher'][$k]['endDate'],0,10);
							$stop_date1 = gmdate("d-m-Y", $timestamp1);
							$final_date1 = date('d-m-Y', strtotime($stop_date1.'+1 day'));
							$yt_vids[$k]['endDate'] = $final_date1;
						}
						else
						{
							$yt_vids[$k]['endDate'] = "";
						}
						if(!empty($result['voucher'][$k]['title']))
						{
							$yt_vids[$k]['title'] = $result['voucher'][$k]['title'];
						}
						else
						{
							$yt_vids[$k]['title'] = "";
						}
						if(!empty($result['voucher'][$k]['shortDescription']))
						{
							$yt_vids[$k]['shortDescription'] = $result['voucher'][$k]['shortDescription'];
						}
						else
						{
							$yt_vids[$k]['shortDescription'] = "";
						}
						if(!empty($result['voucher'][$k]['description']))
						{
							$yt_vids[$k]['description'] = $result['voucher'][$k]['description'];
						}
						else
						{
							$yt_vids[$k]['description'] = "";
						}
						if(!empty($result['voucher'][$k]['defaultTrackUri']))
						{
							$yt_vids[$k]['defaultTrackUri'] = $result['voucher'][$k]['defaultTrackUri'];
						}
						else
						{
							$yt_vids[$k]['defaultTrackUri'] = "";
						}
						if(!empty($result['voucher'][$k]['discountAmount']))
						{
							$yt_vids[$k]['discountAmount'] = $result['voucher'][$k]['discountAmount'];
						}
						else
						{
							$yt_vids[$k]['discountAmount'] = "";
						}
						if(!empty($result['voucher'][$k]['isPercentage']))
						{
							$yt_vids[$k]['isPercentage'] = $result['voucher'][$k]['isPercentage'];
						}
						else
						{
							$yt_vids[$k]['isPercentage'] = "";
						}
						if(!empty($result['voucher'][$k]['currencyId']))
						{
							$yt_vids[$k]['currencyId'] = $result['voucher'][$k]['currencyId'];
						}
						else
						{
							$yt_vids[$k]['currencyId'] = "";
						}
						
					}
				}
				/*  echo "<pre>";
					print_r($yt_vids);
				exit; */  
				
				
				
				$this->load->library('PHPExcel');
				$object = new PHPExcel();
				$object->setActiveSheetIndex(0);
				$table_columns = array("id","programId","programName","code","startDate","endDate","title","shortDescription","description","defaultTrackUri","discountAmount","isPercentage","currencyId");
				$object->getActiveSheet()->setTitle('TD Coupons List');
				$column = 0;
				foreach($table_columns as $field)
				{
					$object->getActiveSheet()->setCellValueByColumnAndRow($column, 1, $field);
					$column++;
				}
				for ($col = ord('A'); $col <= ord('Z'); $col++) 
				{
					//set column dimension
					$object->getActiveSheet()->getColumnDimension(chr($col))->setAutoSize(true);
					$object->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('B1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('C1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('D1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('E1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('F1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('G1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('H1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('I1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('J1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('K1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('L1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('M1')->getFont()->setBold(true);
					$object->getActiveSheet()->getStyle('N1')->getFont()->setBold(true);
					//change the font size
					$object->getActiveSheet()->getStyle(chr($col))->getFont()->setSize(12);
				} 
				$excel_row = 2;
				$i = 1;
				
				foreach ($yt_vids as $key => $val) 
				{
					$id = $val['id'];
					$programId = $val['programId'];
					$programName = $val['programName'];
					$code = $val['code'];
					$startDate = $val['startDate'];
					$endDate = $val['endDate'];
					$title = $val['title'];
					$shortDescription = $val['shortDescription'];
					$description = $val['description'];
					$defaultTrackUri = $val['defaultTrackUri'];
					$discountAmount = $val['discountAmount'];
					$isPercentage = $val['isPercentage'];
					$currencyId = $val['currencyId'];
					
					
					$object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $id);
					$object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $programId);
					$object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $programName);
					$object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $code);
					$object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $startDate);
					$object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $endDate);
					$object->getActiveSheet()->setCellValueByColumnAndRow(6, $excel_row, $title);
					$object->getActiveSheet()->setCellValueByColumnAndRow(7, $excel_row, $shortDescription);
					$object->getActiveSheet()->setCellValueByColumnAndRow(8, $excel_row, $description);
					$object->getActiveSheet()->setCellValueByColumnAndRow(9, $excel_row, $defaultTrackUri);
					$object->getActiveSheet()->setCellValueByColumnAndRow(10, $excel_row, $discountAmount);
					$object->getActiveSheet()->setCellValueByColumnAndRow(11, $excel_row, $isPercentage);
					$object->getActiveSheet()->setCellValueByColumnAndRow(12, $excel_row, $currencyId);
					
					$excel_row++;
					$i++;
					
				}
				
				
				$object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel2007');
				header('Content-Type: application/vnd.ms-excel');
				header('Content-Disposition: attachment;filename="TD_Coupons_GGD.xlsx"');
				$object_writer->save('php://output');
				redirect(base_url().'API/pj_api_coupons','refresh');
			}
			else
			{
				$this->session->set_flashdata('error', " Record has not been found...!");
				redirect(base_url().'API/td_api_coupons','refresh');	
			}
		}
		
		
		
		//////////////////////////////////////////////////////////////
		/////////////////// AD API //////////////////////////////////
		/////////////////////////////////////////////////////////////
		//ad  API
		public function ad_api_coupons()
		{
			$data['content']  = 'API/ad_api_coupons';
			$this->load->view('Template/template',$data);
			
		}
		//ad SUBMIT
		public function ad_api_coupons_submit()
		{
			$post = $this->input->post();
			$records_per_page = $post['records_per_page'];
			$page_number1 = $post['page_number'];
			
			$url = "https://api.admitad.com/advcampaigns/";
			$curl = curl_init();
			/* curl_setopt($curl, CURLOPT_HTTPHEADER, array('Contect-Type:application/xml', 'Accept:application/xml','Authorization: Bearer '.$bearer.'')); */
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Contect-Type:application/xml', 'Accept:application/xml','Authorization: Bearer raIkqJC6i6hKanTciNEgM6aV6AWU09'));
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl,CURLOPT_RETURNTRANSFER,true);
			curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
			
			$result1 =  curl_exec($curl);
			
			// Close the Curl resource
			curl_close($curl);
			
			/* $xml = simplexml_load_string($result1);
				$json = json_encode($xml);
			$result = json_decode($json, true); */
			
		    echo "<pre>";
			print_r($result1);
			//print_r($result);
			exit;  
			
			
			$count = 0;
			if(isset($result['data']) && $result['data']!=array())
			{
				
				$total_matched = $result['meta']['pagination']['total_results'];
				$records_returned = $records_per_page;
				$page_number = $page_number1;
				$total_pages = $result['meta']['pagination']['total_pages'];
				$message = '<br/>Success: Coupons Record Successfully Found.<br/>Total Rows ('.$total_matched.')<br/>Total Pages ('.$total_pages.')<br/>Record Per Page ('.$records_returned.')<br/>Page Number ('.$page_number.')';
				$data['result']  =  $message;
				$data['records_per_page']  =  $records_per_page;
				$data['page_number']  =  $page_number1;
				$data['content']  = 'API/ad_api_coupons';
				$this->load->view('Template/template',$data);
			}
			else
			{
				
				$message = "Error: Record Not Found..!";
				$data['result']  =  $message;
				$data['records_per_page']  =  $records_per_page;
				$data['page_number']  =  $page_number1;
				$data['content']  = 'API/ad_api_coupons';
				$this->load->view('Template/template',$data);
			}
		}
		
		
		
		//ad API
		public function ad_api_stores()
		{
			$data['content']  = 'API/ad_api_stores';
			$this->load->view('Template/template',$data);
			
		}
		
		
	}	